/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.treeview;

import com.nokia.em.poseidon.gui.treeview.PAbstractNode;
import com.nokia.em.poseidon.gui.treeview.PTableLeafNode;
import com.nokia.em.poseidon.gui.treeview.PTableLeafNodeHeaderGroup;
import com.nokia.em.poseidon.gui.treeview.PTreeViewTree;
import com.nokia.em.poseidon.gui.treeview.TreeViewTreeHighlight;
import com.nokia.widgets.tree.TreeSearchTextField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class PTreeViewTreeSearchField
extends TreeSearchTextField {
    private static final String HEADER_GROUP_POSTFIX = "_headergroup";

    public PTreeViewTreeSearchField(JTree tree) {
        super(tree);
    }

    @Override
    protected void collectMatches(Iterator<?> iter, Pattern pattern) {
        PTreeViewTree tree = (PTreeViewTree)this.getTree();
        boolean isFirstMatchInTree = true;
        while (iter.hasNext()) {
            if (this.myMaxSearchCount != -1 && this.getMatches().size() > this.myMaxSearchCount) break;
            Object nextNode = iter.next();
            if (!(nextNode instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)nextNode;
            if (!tree.isRootVisible() && defaultMutableTreeNode.isRoot()) continue;
            TreePath path = new TreePath(defaultMutableTreeNode.getPath());
            PAbstractNode node = (PAbstractNode)defaultMutableTreeNode.getUserObject();
            String[] text = node.getValues();
            boolean isFirstMatchInNode = true;
            ArrayList<String> nodeTexts = new ArrayList<String>();
            int idx = 0;
            int columnCount = node.getValues().length;
            boolean isLeaf = false;
            if (node instanceof PTableLeafNode) {
                isLeaf = true;
                PTableLeafNode tableNode = (PTableLeafNode)node;
                columnCount = tableNode.getTableModel().getColumnCount();
                String title = tableNode.getTitle();
                if (tableNode.isShowTitle() && title != null && columnCount > 0) {
                    List<String> titleRow = this.getTitleRow(columnCount, title);
                    nodeTexts.addAll(0, titleRow);
                }
                if (tableNode.getHeaderGroup() != null) {
                    for (PTableLeafNodeHeaderGroup headerGroup : tableNode.getHeaderGroup().values()) {
                        nodeTexts.add(String.valueOf(headerGroup.getText()) + "_" + headerGroup.getStartColumn() + HEADER_GROUP_POSTFIX);
                    }
                }
                List headers = tableNode.getHeaders();
                if (tableNode.isShowHeaders() && headers != null) {
                    nodeTexts.addAll(headers);
                }
            }
            nodeTexts.addAll(Arrays.asList(text));
            for (String nodeText : nodeTexts) {
                if (nodeText == null) {
                    ++idx;
                    continue;
                }
                boolean isHeaderGroup = nodeText.endsWith(HEADER_GROUP_POSTFIX);
                Matcher m = pattern.matcher((isHeaderGroup ? this.removeHeaderGroupText(nodeText) : nodeText).toUpperCase());
                while (m.find()) {
                    int column;
                    int row = isLeaf && columnCount > 0 ? idx / columnCount : 0;
                    int n = column = columnCount > 0 ? idx % columnCount : 0;
                    if (isHeaderGroup) {
                        String[] headerGroup = nodeText.split("_");
                        row = -2;
                        column = Integer.parseInt(headerGroup[1]);
                    }
                    this.getMatches().add(new TreeViewTreeHighlight(path, row, column, pattern.pattern(), m.start()));
                    if (isFirstMatchInTree) {
                        tree.scrollRowToVisible(path, row);
                        isFirstMatchInTree = false;
                    }
                    if (!isFirstMatchInNode) continue;
                    tree.expandPath(path.getParentPath());
                    isFirstMatchInNode = false;
                }
                if (nodeText.endsWith(HEADER_GROUP_POSTFIX)) continue;
                ++idx;
            }
        }
    }

    private String removeHeaderGroupText(String input) {
        return input.replaceAll("_[0-9]+_headergroup", "");
    }

    private List<String> getTitleRow(int columnCount, String title) {
        ArrayList<String> titleRow = new ArrayList<String>();
        titleRow.add(title);
        int i = 0;
        while (i < columnCount - 1) {
            titleRow.add(" ");
            ++i;
        }
        return titleRow;
    }
}

