/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.userauthentication;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.mvc.ControllerBase;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.gui.common.CloseConfirmationMessage;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationMessageFactory;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationPollingHandler;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationValidationResult;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationValidator;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationView;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.em.poseidon.services.userauthentication.UserAuthenticationListener;
import com.nokia.em.poseidon.services.userauthentication.UserAuthenticationService;
import com.nokia.em.poseidon.services.userauthentication.event.AddListenerEvent;
import com.nokia.em.poseidon.services.userauthentication.event.CurrentStateEvent;
import com.nokia.em.poseidon.services.userauthentication.event.GetCurrentStateEvent;
import com.nokia.em.poseidon.services.userauthentication.event.PollingRequestEvent;
import com.nokia.em.poseidon.services.userauthentication.event.RemoveListenerEvent;
import com.nokia.em.poseidon.services.userauthentication.event.SendRequestEvent;
import com.nokia.em.poseidon.services.userauthentication.event.StatusEvent;
import com.nokia.em.poseidon.util.PSettings;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class UserAuthenticationController
extends ControllerBase
implements UserAuthenticationListener,
ActionListener {
    private PHelp myHelpService;
    private UserAuthenticationService myService;
    private UserAuthenticationValidator myValidator;
    private int myTimeout = 300;
    private boolean myTimeoutMessageIsShown = true;
    protected static final int TIMER_UPDATE_INTERVAL = 1000;
    protected Timer myTimer;
    protected int myCounter;
    protected Logger myLogger;
    private static final String START_TIME = "start_time";
    private static final long UNDEFINED_START_TIME = -1L;
    private CloseConfirmationMessage myCloseMsg = PoseidonRuntime.getRuntime().getObject(CloseConfirmationMessage.class);
    private UserAuthenticationPollingHandler myPollingHandler;

    public UserAuthenticationController() {
        this.myValidator = new UserAuthenticationValidator();
        this.myService = PoseidonRuntime.getRuntime().getService(UserAuthenticationService.class);
        this.myService.processEvent(new AddListenerEvent(this, this));
        this.myTimer = new Timer(1000, this);
        Object showTimeChange = PoseidonRuntime.getRuntime().getRuntimeProperty("show_time_change");
        if (showTimeChange instanceof Boolean && ((Boolean)showTimeChange).booleanValue()) {
            this.myPollingHandler = new UserAuthenticationPollingHandler(this);
            this.myPollingHandler.start();
        }
        this.myLogger = Logger.getLogger(this.getClass());
    }

    @Override
    public void setView(View view) {
        super.setView(view);
        this.myService.processEvent(new GetCurrentStateEvent(this));
    }

    public void enableTimeoutNotification(boolean value) {
        this.myTimeoutMessageIsShown = value;
    }

    public void setTimeoutTime(int time) {
        this.myTimeout = time;
    }

    public void setValidator(UserAuthenticationValidator validator) {
        this.myValidator = validator;
    }

    public void setMessagefactory(UserAuthenticationMessageFactory factory) {
        if (this.isViewValid()) {
            ((UserAuthenticationView)((Object)this.getView())).setMessageFactory(factory);
        }
    }

    @Override
    public void destroy() {
        if (this.isViewValid() && ((UserAuthenticationView)((Object)this.getView())).confirmClose()) {
            this.myTimer.stop();
            if (this.myPollingHandler != null) {
                this.myPollingHandler.stop();
            }
            this.myService.processEvent(new RemoveListenerEvent(this, this));
            super.destroy();
        }
    }

    public void sendRequest(String userName, char[] password) {
        this.myService.processEvent(new SendRequestEvent(this, userName, password));
    }

    public UserAuthenticationValidationResult validate(String userName, char[] firstPassword, char[] secondPassword) {
        return this.myValidator.validate(userName, firstPassword, secondPassword);
    }

    public void showHelpRequest(Window window, String helpID) {
        if (this.myHelpService == null) {
            this.myHelpService = PoseidonRuntime.getRuntime().getService(PHelp.class);
        }
        if (this.myHelpService != null) {
            this.myHelpService.showHelp(window, helpID);
        }
    }

    protected boolean isViewValid() {
        return this.getView() instanceof UserAuthenticationView;
    }

    private void handleProgressStopped() {
        PSettings.getInstance().set(START_TIME, -1L);
        if (this.isViewValid()) {
            ((UserAuthenticationView)((Object)this.getView())).updateElapsedTime(0);
        }
        this.myCounter = 0;
        this.myTimer.stop();
        if (this.myCloseMsg != null) {
            this.myCloseMsg.operationFinished(null);
        }
    }

    private int safeLongToInt(long l) {
        return (int)Math.max(Math.min(Integer.MAX_VALUE, l), Integer.MIN_VALUE);
    }

    @Override
    public void processEvent(final EventObject event) {
        this.myLogger.debug("Received event: " + event);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (event instanceof StatusEvent) {
                    switch (((StatusEvent)event).getStatus()) {
                        case SENDING_IN_PROGRESS: {
                            PSettings.getInstance().set(UserAuthenticationController.START_TIME, System.currentTimeMillis());
                            UserAuthenticationController.this.myCounter = 0;
                            UserAuthenticationController.this.myTimer.restart();
                            break;
                        }
                        case SENDING_FAILED: {
                            UserAuthenticationController.this.handleProgressStopped();
                            break;
                        }
                        case SENDING_FINISHED: {
                            UserAuthenticationController.this.handleProgressStopped();
                            break;
                        }
                        case SENDING_NOT_SUPPORTED: {
                            UserAuthenticationController.this.handleProgressStopped();
                            break;
                        }
                    }
                }
                if (event instanceof PollingRequestEvent) {
                    UserAuthenticationController.this.myService.processEvent(event);
                }
                if (UserAuthenticationController.this.isViewValid()) {
                    ((UserAuthenticationView)((Object)UserAuthenticationController.this.getView())).processEvent(event);
                }
                if (event instanceof CurrentStateEvent) {
                    CurrentStateEvent state = (CurrentStateEvent)event;
                    if (StatusEvent.STATUS.NOT_AVAILABLE.equals((Object)state.getStatus())) {
                        UserAuthenticationController.this.myLogger.debug("User authentication service provider is not available, closing controller.");
                        UserAuthenticationController.this.destroy();
                    } else if (StatusEvent.STATUS.SENDING_IN_PROGRESS.equals((Object)state.getStatus())) {
                        UserAuthenticationController.this.myTimer.restart();
                        long time = PSettings.getInstance().get(UserAuthenticationController.START_TIME, -1L);
                        if (time != -1L) {
                            UserAuthenticationController.this.myCounter = UserAuthenticationController.this.safeLongToInt((System.currentTimeMillis() - time) / 1000L);
                            if (UserAuthenticationController.this.isViewValid()) {
                                ((UserAuthenticationView)((Object)UserAuthenticationController.this.getView())).updateElapsedTime(UserAuthenticationController.this.myCounter);
                            }
                        }
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isViewValid()) {
            ((UserAuthenticationView)((Object)this.getView())).updateElapsedTime(++this.myCounter);
        }
        if (this.myCounter == this.myTimeout && this.myTimeoutMessageIsShown && this.isViewValid() && ((UserAuthenticationView)((Object)this.getView())).confirmTimeout()) {
            this.myTimer.stop();
            this.destroy();
        }
    }

    public CloseConfirmationMessage getCloseMsg() {
        return this.myCloseMsg;
    }
}

