/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.userauthentication;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.frameworks.mvc.swing.JDialogViewBase;
import com.nokia.em.poseidon.gui.common.PStaticDialogs;
import com.nokia.em.poseidon.gui.common.taskview.PTaskViewButtonBar;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationController;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationMessageFactory;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationPanel;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationView;
import com.nokia.em.poseidon.services.userauthentication.event.CurrentStateEvent;
import com.nokia.em.poseidon.services.userauthentication.event.StatusEvent;
import com.nokia.widgets.buttons.PHelpButton;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class UserAuthenticationDialog
extends JDialogViewBase
implements UserAuthenticationView {
    private UserAuthenticationPanel myInnerPanel;
    private Logger myLogger = Logger.getLogger(this.getClass());
    private JButton myCloseButton;
    private boolean isOperationOngoing;

    @Override
    protected void handleWindowClosing() {
        this.myCloseButton.getModel().setPressed(true);
        new ClosingListener().actionPerformed(null);
    }

    public UserAuthenticationDialog(Controller controller, Frame owner, boolean modal) throws HeadlessException {
        super(controller, owner, modal);
        this.buildUI(controller);
        this.restoreSettings();
        this.myLogger.debug("User authentication dialog view created.");
    }

    protected void buildUI(Controller controller) {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        ResourceBundle bundle = I18n.getI18n().getBundle(this.getClass());
        this.setTitle(bundle.getString("UserAuthenticationDialog.UserAuthentication_Title"));
        this.myInnerPanel = new UserAuthenticationPanel(controller, false);
        this.add(this.myInnerPanel);
        this.myCloseButton = this.createCloseButton();
        this.myInnerPanel.addNoValidationComponents(this.myCloseButton);
        AbstractButton[] buttons = new AbstractButton[]{this.myInnerPanel.getSendButton(), this.myCloseButton, this.createHelpButton()};
        this.add(new PTaskViewButtonBar(buttons));
        Localizer myLocalizer = LocalizerRegistry.lookup("swing");
        myLocalizer.setResourceBundle(bundle);
        myLocalizer.localizeObjectHierarchy(new SwingHierarchyIterator(this));
        this.setResizable(false);
        this.pack();
    }

    protected JButton createCloseButton() {
        JButton button = new JButton();
        button.setName("CloseAction");
        button.addActionListener(new ClosingListener());
        return button;
    }

    protected JButton createHelpButton() {
        PHelpButton button = new PHelpButton();
        button.setName("UserAuthenticationDialog.HelpButton");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((UserAuthenticationController)UserAuthenticationDialog.this.getController()).showHelpRequest(UserAuthenticationDialog.this, "BTS_UserAuthentication");
            }
        });
        return button;
    }

    @Override
    public void setMessageFactory(UserAuthenticationMessageFactory factory) {
        this.myInnerPanel.setMessageFactory(factory);
    }

    @Override
    public void processEvent(EventObject event) {
        CurrentStateEvent state;
        if (event instanceof StatusEvent) {
            switch (((StatusEvent)event).getStatus()) {
                case SENDING_IN_PROGRESS: {
                    this.myCloseButton.setEnabled(false);
                    this.isOperationOngoing = true;
                    break;
                }
                case SENDING_FAILED: {
                    this.myCloseButton.setEnabled(true);
                    this.isOperationOngoing = false;
                    break;
                }
                case SENDING_FINISHED: {
                    this.myCloseButton.setEnabled(true);
                    this.isOperationOngoing = false;
                    break;
                }
                case NOT_AVAILABLE: {
                    this.getController().destroy();
                    this.isOperationOngoing = false;
                    break;
                }
                case SENDING_NOT_SUPPORTED: {
                    this.myCloseButton.setEnabled(true);
                    this.isOperationOngoing = false;
                    break;
                }
            }
        }
        if (event instanceof CurrentStateEvent && StatusEvent.STATUS.SENDING_IN_PROGRESS.equals((Object)(state = (CurrentStateEvent)event).getStatus())) {
            this.myCloseButton.setEnabled(false);
        }
        this.myInnerPanel.processEvent(event);
    }

    @Override
    public boolean confirmClose() {
        return this.myInnerPanel.confirmClose();
    }

    @Override
    public boolean confirmTimeout() {
        return this.myInnerPanel.confirmTimeout();
    }

    @Override
    public void updateElapsedTime(int timeInseconds) {
        this.myInnerPanel.updateElapsedTime(timeInseconds);
    }

    public void add(View view, Object constraint) {
    }

    private class ClosingListener
    implements ActionListener {
        ResourceBundle myBundle = I18n.getI18n().getBundle(this.getClass());

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isUserNameOrPwdChanged() && !this.isSnapshotMode() && !this.isReadOnlyMode()) {
                this.showUnsavedDataConfirmDialog();
            } else {
                UserAuthenticationDialog.this.getController().destroy();
            }
        }

        private boolean isUserNameOrPwdChanged() {
            return UserAuthenticationDialog.this.myInnerPanel.isUserNameChanged() || String.valueOf(UserAuthenticationDialog.this.myInnerPanel.getMyPassword().getPassword()).length() != 0 || String.valueOf(UserAuthenticationDialog.this.myInnerPanel.getMyConfirmPassword().getPassword()).length() != 0;
        }

        public void showUnsavedDataConfirmDialog() {
            if (UserAuthenticationDialog.this.isOperationOngoing) {
                if (((UserAuthenticationController)UserAuthenticationDialog.this.getController()).getCloseMsg() != null) {
                    ((UserAuthenticationController)UserAuthenticationDialog.this.getController()).getCloseMsg().stopAndDisconnectRequested(null, this.myBundle.getString("UserAuthenticationDialog.UserAuthentication_Title"), this.myBundle.getString("UserAuthenticationPanel.StopOngoingAction"));
                }
            } else {
                Action[] actions = new Action[]{new DiscardAndCloseAction(), PStaticDialogs.getEmptyAction(this.myBundle.getString("UserAuthenticationPanel.CloseConfirm.Cancel_Text"))};
                PStaticDialogs.showQuestionMessage(UserAuthenticationDialog.this.myInnerPanel, this.myBundle.getString("UserAuthenticationPanel.CloseConfirm._Title"), this.myBundle.getString("UserAuthenticationPanel.CloseConfirm._Header"), this.myBundle.getString("UserAuthenticationPanel.CloseConfirm._Message"), null, actions);
            }
        }

        public boolean isSnapshotMode() {
            Object isSnapshot = PoseidonRuntime.getRuntime().getRuntimeProperty("isSnapshotMode");
            if (isSnapshot instanceof Boolean) {
                return (Boolean)isSnapshot;
            }
            return false;
        }

        public boolean isReadOnlyMode() {
            Object isReadOnly = PoseidonRuntime.getRuntime().getRuntimeProperty("isReadOnlyMode");
            if (isReadOnly instanceof Boolean) {
                return (Boolean)isReadOnly;
            }
            return false;
        }

        private class DiscardAndCloseAction
        extends AbstractAction {
            private static final long serialVersionUID = 5946765411496347115L;

            public DiscardAndCloseAction() {
                ClosingListener.this.myBundle = I18n.getI18n().getBundle(this.getClass());
                this.putValue("Name", ClosingListener.this.myBundle.getString("UserAuthenticationPanel.CloseConfirm.Discard_And_Close_Text"));
                this.putValue("MnemonicKey", ClosingListener.this.myBundle.getMnemonic("UserAuthenticationPanel.CloseConfirm.Discard_And_Close_Mnemonic"));
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                UserAuthenticationDialog.this.getController().destroy();
            }
        }
    }
}

