/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.userauthentication;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.frameworks.mvc.swing.JPanelViewBase;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationController;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationMessageFactory;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationValidationResult;
import com.nokia.em.poseidon.gui.userauthentication.UserAuthenticationView;
import com.nokia.em.poseidon.services.userauthentication.event.CurrentStateEvent;
import com.nokia.em.poseidon.services.userauthentication.event.PollingResultEvent;
import com.nokia.em.poseidon.services.userauthentication.event.StatusEvent;
import com.nokia.laf.NetTheme;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.balloon.Balloon;
import com.nokia.widgets.buttons.PButton;
import com.nokia.widgets.infotip.InfoButton;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.labels.PStaticLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.progress.ProgressController;
import com.nokia.widgets.progress.ProgressFactory;
import com.nokia.widgets.progress.models.ProgressBarModel;
import com.nokia.widgets.progress.views.ProgressBarUI;
import com.nokia.widgets.text.PPasswordField;
import com.nokia.widgets.text.PTextComponent;
import com.nokia.widgets.text.PTextField;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class UserAuthenticationPanel
extends JPanelViewBase
implements UserAuthenticationView,
FocusListener,
DocumentListener {
    protected static String INVALID_ENTRY = "invalid_Entry";
    private final ResourceBundle myBundle = I18n.getI18n().getBundle(this.getClass());
    private final Logger myLogger = Logger.getLogger(this.getClass());
    private PTextField myUserName;
    private PPasswordField myPassword;
    private PPasswordField myConfirmPassword;
    private PStaticLabel myPwdChangeTimeField;
    private PPanel myProgressPanel;
    private ProgressBarModel myProgressModel;
    private ProgressController myProgressController;
    private PButton mySendButton;
    private PLabel myProgressLabel;
    private int SMALL_FONT = 12;
    public static final String SHOW_TIME_CHANGE = "show_time_change";
    private UserAuthenticationMessageFactory myMessageFactory = new UserAuthenticationMessageFactory();
    private final List<AbstractButton> myNoValidationComponenets = new ArrayList<AbstractButton>();
    private String mySavedUserName;
    private static final int MAX_PASSWORD_LENGTH = 128;

    public UserAuthenticationPanel(Controller controller, boolean showSend) {
        super(controller);
        this.buildUI(showSend);
        this.init();
        this.myLogger.debug("User authentication panelview created.");
    }

    public JButton getSendButton() {
        return this.mySendButton;
    }

    public PTextField getMyUserName() {
        return this.myUserName;
    }

    public PPasswordField getMyPassword() {
        return this.myPassword;
    }

    public PPasswordField getMyConfirmPassword() {
        return this.myConfirmPassword;
    }

    protected void init() {
        this.checkStatus();
        this.myProgressModel.setProperty("progresstate", 2);
    }

    protected void buildUI(boolean showSend) {
        Insets indentedInsets = new Insets(9, 22, 3, 0);
        Insets textFieldInsets = new Insets(3, 12, 3, 10);
        this.setLayout(new GridBagLayout());
        ExtendedGridBagConstraints gbc = new ExtendedGridBagConstraints();
        gbc.setAnchor(512);
        PLabel newNameLabel = new PLabel();
        newNameLabel.setName("UserAuthenticationPanel.NewName");
        newNameLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        gbc.jumpToColumn(0);
        gbc.nextRow();
        gbc.useSpecificInsets(new Insets(30, 22, 3, 12));
        this.add((Component)newNameLabel, (Object)gbc);
        this.myUserName = new PTextField(15);
        this.myUserName.setDocument(new TextDocument(this.myUserName, 16, null, false));
        this.myUserName.setName("myUserName");
        this.myUserName.addDocumentListener(this);
        this.myUserName.setMandatoryEntry(true);
        this.myUserName.addFocusListener(this);
        this.myUserName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                UserAuthenticationPanel.this.myMessageFactory.closeAllMessages();
            }
        });
        newNameLabel.setLabelFor(this.myUserName);
        gbc.nextColumn();
        gbc.useSpecificInsets(new Insets(24, 12, 3, 10));
        gbc.fillHorizontal();
        this.add((Component)this.myUserName, (Object)gbc);
        final InfoButton userNameInfoButton = new InfoButton();
        userNameInfoButton.setFocusable(false);
        userNameInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                userNameInfoButton.getInfoTip().setTipContent(UserAuthenticationPanel.this.myBundle.getString("UserAuthenticationPanel.NewName_InfoTip"));
            }
        });
        gbc.nextColumn();
        gbc.useSpecificInsets(new Insets(26, 0, 3, 26));
        this.add((Component)userNameInfoButton, (Object)gbc);
        PLabel newPasswordLabel = new PLabel();
        newPasswordLabel.setName("UserAuthenticationPanel.NewPassword");
        newPasswordLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        gbc.jumpToColumn(0);
        gbc.nextRow();
        gbc.useSpecificInsets(indentedInsets);
        gbc.fillNone();
        this.add((Component)newPasswordLabel, (Object)gbc);
        this.myPassword = new PPasswordField();
        this.myPassword.setColumns(30);
        this.myPassword.setDocument(new TextDocument(this.myPassword, 128, null, false));
        this.myPassword.setName("myPassword");
        this.myPassword.addDocumentListener(this);
        this.myPassword.setMandatoryEntry(true);
        this.myPassword.addFocusListener(this);
        this.myPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                UserAuthenticationPanel.this.myMessageFactory.closeAllMessages();
            }
        });
        newPasswordLabel.setLabelFor(this.myPassword);
        gbc.nextColumn();
        gbc.fillHorizontal();
        gbc.useSpecificInsets(textFieldInsets);
        this.add((Component)this.myPassword, (Object)gbc);
        final InfoButton pwInfoButton = new InfoButton();
        pwInfoButton.setFocusable(false);
        pwInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String messageKey = UserAuthenticationPanel.this.isWnProduct() ? "UserAuthenticationPanel.NewPassword_WN_InfoTip" : "UserAuthenticationPanel.NewPassword_InfoTip";
                pwInfoButton.getInfoTip().setTipContent(UserAuthenticationPanel.this.myBundle.getString(messageKey));
            }
        });
        gbc.nextColumn();
        gbc.useSpecificInsets(new Insets(5, 0, 3, 26));
        this.add((Component)pwInfoButton, (Object)gbc);
        PLabel confirmPasswdLabel = new PLabel();
        confirmPasswdLabel.setName("UserAuthenticationPanel.ConfirmPassword");
        confirmPasswdLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        gbc.jumpToColumn(0);
        gbc.nextRow();
        gbc.fillNone();
        gbc.useSpecificInsets(indentedInsets);
        this.add((Component)confirmPasswdLabel, (Object)gbc);
        this.myConfirmPassword = new PPasswordField();
        this.myConfirmPassword.setColumns(30);
        this.myConfirmPassword.setDocument(new TextDocument(this.myConfirmPassword, 128, null, false));
        this.myConfirmPassword.setName("myConfirmPassword");
        this.myConfirmPassword.addDocumentListener(this);
        this.myConfirmPassword.setMandatoryEntry(true);
        this.myConfirmPassword.addFocusListener(this);
        this.myConfirmPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                UserAuthenticationPanel.this.myMessageFactory.closeAllMessages();
            }
        });
        confirmPasswdLabel.setLabelFor(this.myConfirmPassword);
        gbc.nextColumn();
        gbc.fillHorizontal();
        gbc.useSpecificInsets(textFieldInsets);
        this.add((Component)this.myConfirmPassword, (Object)gbc);
        PLabel pwdChangedLabel = new PLabel();
        pwdChangedLabel.setName("UserAuthenticationPanel.PasswordChanged");
        pwdChangedLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.myPwdChangeTimeField = new PStaticLabel(30);
        pwdChangedLabel.setLabelFor(this.myPwdChangeTimeField);
        Object showTimeChange = PoseidonRuntime.getRuntime().getRuntimeProperty(SHOW_TIME_CHANGE);
        if (showTimeChange instanceof Boolean && ((Boolean)showTimeChange).booleanValue()) {
            gbc.jumpToColumn(0);
            gbc.nextRow();
            gbc.fillNone();
            gbc.useSpecificInsets(indentedInsets);
            this.add((Component)pwdChangedLabel, (Object)gbc);
            gbc.nextColumn();
            gbc.fillHorizontal();
            gbc.useSpecificInsets(new Insets(9, 12, 3, 0));
            this.add((Component)this.myPwdChangeTimeField, (Object)gbc);
        }
        this.myProgressLabel = PLabel.createValueText(" ");
        this.myProgressPanel = new PPanel((LayoutManager)new MigLayout("ins 0 0 0 0,fillx", ""));
        this.myProgressPanel.add((Component)this.myProgressLabel, "wrap");
        this.myProgressPanel.add((Component)this.createProgressPanel(), "w 170!");
        gbc.jumpToColumn(0);
        gbc.nextRow();
        gbc.fillNone();
        gbc.setColumnWidth(2);
        this.setSpecificInsets(gbc);
        this.add((Component)this.myProgressPanel, (Object)gbc);
        this.mySendButton = this.createSendButton();
        this.mySendButton.setDefaultButton(true);
        gbc.fillNone();
        gbc.nextRow();
        gbc.useSpecificInsets(indentedInsets);
        if (showSend) {
            this.add((Component)this.mySendButton, (Object)gbc);
        }
        Localizer myLocalizer = LocalizerRegistry.lookup("swing");
        myLocalizer.setResourceBundle(this.myBundle);
        myLocalizer.localizeObjectHierarchy(new SwingHierarchyIterator(this));
    }

    private boolean isWnProduct() {
        String managerType = (String)PoseidonRuntime.getRuntime().getRuntimeProperty("manageType");
        return "BTS".equals(managerType) || "WLBTS".equals(managerType);
    }

    private void setSpecificInsets(ExtendedGridBagConstraints gbc) {
        if (this.getFont().getSize() == this.SMALL_FONT) {
            gbc.useSpecificInsets(new Insets(50, 22, 12, 0));
        } else {
            gbc.useSpecificInsets(new Insets(80, 22, 12, 0));
        }
    }

    protected ProgressBarUI createProgressPanel() {
        this.myProgressModel = new ProgressBarModel();
        this.myProgressModel.setIndeterminated(true);
        this.myProgressModel.setProperty("progresstate", 2);
        this.myProgressModel.setProperty("showduration", Boolean.FALSE);
        this.myProgressModel.setActionButtonVisible(false);
        this.myProgressController = ProgressFactory.createProgressBarControl(this.myProgressModel);
        return (ProgressBarUI)this.myProgressController.getView();
    }

    protected PButton createSendButton() {
        PButton button = new PButton();
        button.setDefaultButton(true);
        button.setName("UserAuthenticationPanel.SendButton");
        button.addFocusListener(this);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (UserAuthenticationPanel.this.validateParams()) {
                    ((UserAuthenticationController)UserAuthenticationPanel.this.getController()).sendRequest(UserAuthenticationPanel.this.myUserName.getText(), UserAuthenticationPanel.this.myPassword.getPassword());
                }
            }
        });
        return button;
    }

    protected void setInitialState() {
        this.myProgressLabel.setIcon(null);
        this.myProgressLabel.setText(" ");
        this.myProgressModel.setProperty("progresstate", 2);
    }

    protected void setSendingState() {
        this.myProgressLabel.setIcon(null);
        this.myProgressLabel.setText(this.myBundle.getString("UserAuthenticationPanel.ProgressOngoining"));
        this.myProgressController.start();
        this.myUserName.setEnabled(false);
        this.myPassword.setEnabled(false);
        this.myConfirmPassword.setEnabled(false);
        this.mySendButton.setEnabled(false);
    }

    protected void setNormalState(String iconKey, String textKey, boolean progressStatusFailed) {
        if (iconKey == null) {
            this.myProgressLabel.setIcon(null);
        } else {
            this.myProgressLabel.setIcon(this.myBundle.getImageIcon(iconKey));
        }
        this.myProgressLabel.setText(this.myBundle.getString(textKey));
        if (progressStatusFailed) {
            this.myProgressController.fail();
        } else {
            this.myProgressController.stop();
        }
        this.myUserName.setEnabled(true);
        this.myPassword.setEnabled(true);
        this.myConfirmPassword.setEnabled(true);
        this.checkStatus();
    }

    protected void checkStatus() {
        this.mySendButton.setEnabled(!this.isIndicatingFault(this.myUserName) && !this.isIndicatingFault(this.myPassword) && !this.isConfirmPasswordIndicatingFault(this.myConfirmPassword) && !this.isOperationStarted());
        this.repaint();
    }

    private boolean isOperationStarted() {
        return this.myProgressController == null ? false : this.myProgressController.isStarted();
    }

    protected void showError(final JComponent comp, UserAuthenticationValidationResult result) {
        this.myMessageFactory.closeAllMessages();
        this.mySendButton.setEnabled(false);
        this.repaint();
        comp.putClientProperty("invalidEntry", true);
        Balloon balloon = this.myMessageFactory.showMessage(comp, result);
        if (balloon != null) {
            balloon.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    comp.requestFocusInWindow();
                }
            });
        }
    }

    protected boolean isIndicatingFault(JComponent comp) {
        return Boolean.TRUE.equals(comp.getClientProperty("requiredButMissing")) || Boolean.TRUE.equals(comp.getClientProperty("invalidEntry"));
    }

    protected boolean isConfirmPasswordIndicatingFault(JComponent comp) {
        return Boolean.TRUE.equals(comp.getClientProperty("requiredButMissing")) || Boolean.TRUE.equals(comp.getClientProperty(INVALID_ENTRY));
    }

    protected void clearErrors(DocumentEvent event) {
        Document doc = event.getDocument();
        if (this.myUserName.getDocument() == doc && this.isIndicatingFault(this.myUserName)) {
            this.myUserName.setBackground(NetTheme.COLOR_WHITE_20);
        } else if (this.myPassword.getDocument() == doc && this.isIndicatingFault(this.myPassword)) {
            this.myPassword.setBackground(NetTheme.COLOR_WHITE_20);
        } else if (this.myConfirmPassword.getDocument() == doc && this.isConfirmPasswordIndicatingFault(this.myConfirmPassword)) {
            this.myConfirmPassword.setBackground(NetTheme.COLOR_WHITE_20);
        }
    }

    protected void clearErrors() {
        this.myUserName.putClientProperty("invalidEntry", false);
        this.myPassword.putClientProperty("invalidEntry", false);
        this.myConfirmPassword.putClientProperty("invalidEntry", false);
    }

    protected boolean validateParams() {
        UserAuthenticationValidationResult result;
        block9: {
            block8: {
                result = ((UserAuthenticationController)this.getController()).validate(this.myUserName.getText(), this.myPassword.getPassword(), this.myConfirmPassword.getPassword());
                if (result.isValid()) break block8;
                switch (result.getFailedFragment()) {
                    case USERNAME: {
                        if (!this.isIndicatingFault(this.myUserName)) {
                            this.showError(this.myUserName, result);
                            break;
                        }
                        break block9;
                    }
                    case PASSWORD: {
                        if (!this.isIndicatingFault(this.myPassword)) {
                            this.showError(this.myPassword, result);
                            break;
                        }
                        break block9;
                    }
                    case CONFIRMPASSWORD: {
                        if (!this.isConfirmPasswordIndicatingFault(this.myConfirmPassword)) {
                            this.showError(this.myConfirmPassword, result);
                            this.myConfirmPassword.putClientProperty(INVALID_ENTRY, true);
                            this.myConfirmPassword.putClientProperty("invalidEntry", true);
                            break;
                        }
                        this.myPassword.putClientProperty("invalidEntry", false);
                        this.myPassword.repaint();
                        break;
                    }
                }
                break block9;
            }
            this.clearErrors();
            this.checkStatus();
        }
        return result.isValid();
    }

    protected void addNoValidationComponents(AbstractButton ... buttons) {
        this.myNoValidationComponenets.addAll(Arrays.asList(buttons));
    }

    @Override
    public void setMessageFactory(UserAuthenticationMessageFactory factory) {
        this.myMessageFactory = factory;
    }

    @Override
    public void processEvent(EventObject event) {
        if (event instanceof StatusEvent) {
            switch (((StatusEvent)event).getStatus()) {
                case SENDING_IN_PROGRESS: {
                    this.setSendingState();
                    break;
                }
                case SENDING_FAILED: {
                    this.setNormalState("Warning_Icon", "UserAuthenticationPanel.ProgressFailed", true);
                    this.myMessageFactory.cannotSendParams(this, ((StatusEvent)event).getStatusType());
                    break;
                }
                case SENDING_FINISHED: {
                    this.mySavedUserName = this.myUserName.getText();
                    this.myPassword.setText("");
                    this.myConfirmPassword.setText("");
                    this.setNormalState(null, "UserAuthenticationPanel.ProgressFifished", false);
                    this.resetDefaultFocus();
                    break;
                }
                case SENDING_NOT_SUPPORTED: {
                    this.myMessageFactory.cannotSendParams(this, ((StatusEvent)event).getStatusType());
                    break;
                }
            }
        }
        if (event instanceof CurrentStateEvent) {
            CurrentStateEvent state = (CurrentStateEvent)event;
            if (!StatusEvent.STATUS.NOT_AVAILABLE.equals((Object)state.getStatus())) {
                this.myUserName.setText(state.getUsername());
                this.myPwdChangeTimeField.setText(state.getPasswordChangedTime());
            }
            this.mySavedUserName = this.myUserName.getText();
            if (StatusEvent.STATUS.SENDING_IN_PROGRESS.equals((Object)state.getStatus())) {
                this.myPassword.setEnabled(true);
                this.myConfirmPassword.setEnabled(true);
                this.myPassword.setText(new String(state.getPassword()));
                this.myConfirmPassword.setText(new String(state.getPassword()));
                this.setSendingState();
            }
            this.validateParams();
        }
        if (event instanceof PollingResultEvent) {
            this.myPwdChangeTimeField.setText(((PollingResultEvent)event).getPasswordChangeTime());
        }
    }

    private void resetDefaultFocus() {
        this.myUserName.requestFocus();
    }

    @Override
    public boolean confirmClose() {
        if (this.myProgressController.isStarted()) {
            return this.myMessageFactory.confirmCloseSending(this);
        }
        return true;
    }

    @Override
    public boolean confirmTimeout() {
        return this.myMessageFactory.sendingTimeout(this);
    }

    @Override
    public void updateElapsedTime(int timeInseconds) {
        int minutes = timeInseconds / 60;
        int seconds = timeInseconds % 60;
        String minutesStr = minutes < 10 ? "0" + minutes : String.valueOf(minutes);
        String secondsStr = seconds < 10 ? "0" + seconds : String.valueOf(seconds);
        this.myProgressController.getView().getTimeLabel().setText(String.valueOf(minutesStr) + ":" + secondsStr);
    }

    public void add(View view, Object constraint) {
    }

    @Override
    public void focusGained(FocusEvent event) {
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.getOppositeComponent() == null) {
            event.getComponent().requestFocusInWindow();
        } else {
            for (AbstractButton button : this.myNoValidationComponenets) {
                if (!button.getModel().isPressed()) continue;
                return;
            }
            this.validateParams();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.clearErrors(e);
        this.checkStatus();
        this.setInitialState();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.clearErrors(e);
        this.checkStatus();
        this.setInitialState();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public boolean isUserNameChanged() {
        return !this.myUserName.getText().equals(this.mySavedUserName);
    }

    class TextDocument
    extends PlainDocument {
        private int myMaxLength = 0;
        private char[] myValidChars;
        private char[] myInvalidChars;
        private PTextComponent myTextComponent;
        private String myRegexString;

        public TextDocument() {
        }

        public TextDocument(int textLength, char[] chars, boolean validChars) {
            this(null, textLength, chars, validChars);
        }

        public TextDocument(PTextComponent textComponent, int textLength, String regexString) {
            this.myMaxLength = textLength;
            this.myRegexString = regexString;
            this.myTextComponent = textComponent;
        }

        public TextDocument(PTextComponent textComponent, int textLength, char[] chars, boolean validChars) {
            this.myMaxLength = textLength;
            if (validChars) {
                this.myValidChars = chars;
            } else {
                this.myInvalidChars = chars;
            }
            this.myTextComponent = textComponent;
        }

        public TextDocument(int textLength) {
            this.myMaxLength = textLength;
        }

        public void setMaxLength(int textLength) {
            this.myMaxLength = textLength;
        }

        public int getMaxLength() {
            return this.myMaxLength;
        }

        public void setValidCharacters(char[] validChars) {
            this.myValidChars = validChars;
            this.myInvalidChars = null;
        }

        public void setInValidCharacters(char[] invalidChars) {
            this.myInvalidChars = invalidChars;
            this.myValidChars = null;
        }

        public void setRegexString(String regexString) {
            this.myRegexString = regexString;
        }

        public boolean isValidString(String str) {
            return this.isValidByRegex(str) && this.isValidByChars(str);
        }

        private boolean isValidByRegex(String str) {
            if (this.myRegexString != null && this.myRegexString.length() > 0) {
                return str.matches(this.myRegexString);
            }
            return true;
        }

        private boolean isValidByChars(String str) {
            if (this.myValidChars == null && this.myInvalidChars == null) {
                return true;
            }
            int idx = 0;
            while (idx < str.length()) {
                if (!this.isValidChar(str.charAt(idx))) {
                    return false;
                }
                ++idx;
            }
            return true;
        }

        private boolean isValidChar(char character) {
            boolean charFound = false;
            char[] chars = this.myValidChars != null ? this.myValidChars : this.myInvalidChars;
            int idx = 0;
            while (idx < chars.length) {
                if (character >= chars[idx] && character <= chars[idx + 1]) {
                    charFound = true;
                    break;
                }
                idx += 2;
            }
            boolean isValid = this.myValidChars != null && charFound || this.myInvalidChars != null && !charFound;
            return isValid;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if ((this.myMaxLength == 0 || super.getLength() + str.length() <= this.myMaxLength) && this.isValidString(str)) {
                if (this.myTextComponent.equals(UserAuthenticationPanel.this.myConfirmPassword) || this.myTextComponent.equals(UserAuthenticationPanel.this.myPassword)) {
                    UserAuthenticationPanel.this.myConfirmPassword.putClientProperty(INVALID_ENTRY, false);
                }
                super.insertString(offs, str, a);
                return;
            }
            if (this.myTextComponent != null) {
                this.myTextComponent.flashField();
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (len <= 0) {
                return;
            }
            if (this.myTextComponent.equals(UserAuthenticationPanel.this.myConfirmPassword) || this.myTextComponent.equals(UserAuthenticationPanel.this.myPassword)) {
                UserAuthenticationPanel.this.myConfirmPassword.putClientProperty(INVALID_ENTRY, false);
            }
            super.remove(offs, len);
        }
    }
}

