/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.wizard;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.wizard.PWizardPage;
import com.nokia.em.poseidon.gui.wizard.PProgressStyle;
import com.nokia.em.poseidon.gui.wizard.PWizardToolTip;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.icons.PEmptyIcon;
import com.nokia.widgets.infotip.InfoButton;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PHorizontalLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PWizardBar
extends PPanel {
    public static final int MOVE_STEP = 16;
    public static final int ANIM_STEP = 3;
    public static final int ANIM_DELAY = 30;
    public static final int DIRECTION_LEFT = -1;
    public static final int DIRECTION_RIGHT = 1;
    public static final int DIRECTION_NONE = 0;
    public static final int BAR_HEIGHT = 37;
    public static final String HELP_BUTTON_COMMAND = "PWizardBar.HelpButton";
    private final ResourceBundle myResourceBundle;
    private final List myStepLabels;
    private final PPanel myProgressPanel;
    private final JViewport myViewport;
    private final Timer myAnimationTimer;
    private final AnimationListener myAnimationListener;
    private final PLabel myIconLabel;
    private final PWizardToolTip myTooltip;
    private final PWizardToolTip mySCFNameTooltip;
    private final Icon myLeftArrowIcon;
    private final Icon myRightArrowIcon;
    private final StepNameLabel myStepNameLabel;
    private final PLabel myStepNumberLabel;
    private final InfoButton myInfoButton;
    private final InfoButton mySCFNameInfoButton;
    private final PLabel myLeftArrowLabel;
    private final PLabel myRightArrowLabel;
    private final PPanel myWizardNamePanel;
    private final PLabel myStatusTextLabel;
    private final Box myWizardNameStepNameSpace;
    private final Box mySCFNameStepNameSpace;
    private JScrollPane scrollPaneForTip;
    private static final Color HEADER_TEXT_COLOR = Color.decode("#1B1B1B");

    public PWizardBar(String iconName, String wizardName, Action helpAction) {
        this.setLayout(new BoxLayout(this, 0));
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myAnimationListener = new AnimationListener();
        this.myAnimationTimer = new Timer(30, this.myAnimationListener);
        this.myAnimationTimer.setRepeats(true);
        this.myIconLabel = new PLabel();
        this.myIconLabel.setBorder(new EmptyBorder(2, 6, 2, 12));
        if (iconName != null) {
            this.myIconLabel.setName(iconName);
        }
        PPanel stepNamePanel = new PPanel(new PHorizontalLayout(2, 1, 1, 0));
        PLabel wizardNameLabel = PLabel.createHeader(wizardName);
        wizardNameLabel.setName(wizardName);
        this.myStatusTextLabel = PLabel.createSubHeader();
        this.myWizardNamePanel = new PPanel();
        this.myWizardNamePanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.myWizardNamePanel.setLayout(new BoxLayout(this.myWizardNamePanel, 0));
        this.myWizardNamePanel.add(wizardNameLabel);
        this.myWizardNamePanel.add(this.myStatusTextLabel);
        this.myStepNameLabel = new StepNameLabel();
        stepNamePanel.add(this.myStepNameLabel);
        this.add(this.myIconLabel);
        this.add(this.myWizardNamePanel);
        this.mySCFNameStepNameSpace = Box.createHorizontalBox();
        this.mySCFNameStepNameSpace.setPreferredSize(new Dimension(50, 1));
        this.mySCFNameStepNameSpace.setMinimumSize(new Dimension(5, 1));
        this.add(this.mySCFNameStepNameSpace);
        this.mySCFNameTooltip = new PWizardToolTip();
        this.mySCFNameInfoButton = new InfoButton(this.mySCFNameTooltip);
        this.mySCFNameInfoButton.setTipLocation(new Point(-10, this.mySCFNameInfoButton.getPreferredSize().height));
        this.mySCFNameInfoButton.setIcon(CommonIcons.getFileInfoIcon());
        this.add(this.mySCFNameInfoButton);
        this.myWizardNameStepNameSpace = Box.createHorizontalBox();
        this.myWizardNameStepNameSpace.setPreferredSize(new Dimension(50, 1));
        this.myWizardNameStepNameSpace.setMinimumSize(new Dimension(5, 1));
        this.add(this.myWizardNameStepNameSpace);
        this.add(stepNamePanel);
        Box box = Box.createHorizontalBox();
        box.setPreferredSize(new Dimension(100, 1));
        box.setMinimumSize(new Dimension(10, 1));
        this.add(box);
        this.add(Box.createGlue());
        this.myStepNumberLabel = new PLabel();
        this.myStepNumberLabel.setForeground(HEADER_TEXT_COLOR);
        this.add(this.myStepNumberLabel);
        this.add(Box.createHorizontalStrut(18));
        this.myTooltip = new PWizardToolTip();
        this.scrollPaneForTip = new JScrollPane(this.myTooltip, 20, 31);
        this.scrollPaneForTip.setBackground(Color.WHITE);
        this.scrollPaneForTip.setBorder(null);
        this.myInfoButton = new InfoButton(this.scrollPaneForTip);
        this.myInfoButton.getInfoTip().setBackground(Color.WHITE);
        this.myInfoButton.setTipLocation(new Point(-5, this.myInfoButton.getPreferredSize().height));
        this.add(this.myInfoButton);
        this.myLeftArrowLabel = new PLabel(PEmptyIcon.ICON_16);
        this.myLeftArrowLabel.setBorder(new EmptyBorder(0, 0, 0, 2));
        this.myLeftArrowIcon = this.myResourceBundle.getImageIcon("PWizardConcept.ProgressLeft_Icon");
        this.myRightArrowLabel = new PLabel(PEmptyIcon.ICON_16);
        this.myRightArrowLabel.setBorder(new EmptyBorder(0, 2, 0, 5));
        this.myRightArrowIcon = this.myResourceBundle.getImageIcon("PWizardConcept.ProgressRight_Icon");
        this.add(this.myLeftArrowLabel);
        this.myProgressPanel = new PPanel();
        this.myProgressPanel.setLayout(new BoxLayout(this.myProgressPanel, 0));
        this.myViewport = new JViewport(){

            @Override
            public Dimension getMaximumSize() {
                return PWizardBar.this.myProgressPanel.getPreferredSize();
            }
        };
        this.myViewport.setView(this.myProgressPanel);
        this.myViewport.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                PWizardBar.this.myLeftArrowLabel.setIcon(PWizardBar.this.isLeftArrowShown() ? PWizardBar.this.myLeftArrowIcon : PEmptyIcon.ICON_16);
                PWizardBar.this.myRightArrowLabel.setIcon(PWizardBar.this.isRightArrowShown() ? PWizardBar.this.myRightArrowIcon : PEmptyIcon.ICON_16);
                if (PWizardBar.this.myViewport != null && PWizardBar.this.myViewport.getSize() != null) {
                    int widthTemp = ((PWizardBar)PWizardBar.this).myViewport.getSize().width;
                    int heightTemp = ((PWizardBar)PWizardBar.this).myViewport.getSize().height;
                    int iconWidth = 16;
                    if (widthTemp > 0 && widthTemp % iconWidth > 0) {
                        widthTemp = widthTemp / iconWidth * iconWidth;
                        PWizardBar.this.myViewport.setSize(widthTemp, heightTemp);
                    }
                }
                PWizardBar.this.repaint();
            }
        });
        this.myStepLabels = new ArrayList();
        this.add(this.myViewport);
        this.add(this.myRightArrowLabel);
        if (helpAction != null) {
            PHelp help = PoseidonRuntime.getRuntime().getService(PHelp.class);
            help.addContextSensitiveHelpAction(this, helpAction);
        }
        Localizer myLocaliser = LocalizerRegistry.lookup("swing");
        myLocaliser.setResourceBundle(this.myResourceBundle);
        myLocaliser.localizeObjectHierarchy(new SwingHierarchyIterator(this));
    }

    public void setStatusText(String text) {
        this.myStatusTextLabel.setText(text);
    }

    public void clear() {
        this.myProgressPanel.removeAll();
        this.myStepLabels.clear();
        this.mySCFNameTooltip.clear();
        this.myTooltip.clear();
    }

    public void setWizardNameVisible(boolean value) {
        this.myWizardNamePanel.setVisible(value);
        this.myWizardNameStepNameSpace.setVisible(value);
    }

    public void setHelpButtonVisible(boolean value) {
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        return new Dimension(prefSize.width, 37);
    }

    protected void setCurrentPage(PWizardPage page) {
        if (page == null) {
            return;
        }
        String stepName = page.getName();
        int stepNumber = page.getIndex();
        int pageCount = page.getModel().getPageCount();
        if (pageCount == 1) {
            this.setNormalDataVisible(false, stepName, "");
        } else {
            Object[] args = new String[]{String.valueOf(stepNumber), String.valueOf(pageCount)};
            String pages = MessageFormat.format(this.myResourceBundle.getString("PWizardConcept.StepNumber_Text"), args);
            this.setNormalDataVisible(true, stepName, pages);
        }
        if (!this.isStepLabelVisible(stepNumber)) {
            int direction = this.getHideDirection(stepNumber);
            int visible = this.getNumberOfVisibleSteps();
            if (visible > 1) {
                this.move(direction * (visible - 1));
            } else {
                this.scrollToVisible(stepNumber);
            }
        }
    }

    protected void setNormalDataVisible(boolean value, String stepName, String stepNumber) {
        this.myStepNameLabel.setText(stepName);
        this.myStepNumberLabel.setText(stepNumber);
        this.myViewport.setVisible(value);
        this.myLeftArrowLabel.setVisible(value);
        this.myRightArrowLabel.setVisible(value);
        this.myInfoButton.setEnabled(value);
    }

    protected void enableSCFNameButton(boolean enable) {
        this.mySCFNameInfoButton.setEnabled(enable);
    }

    protected void setProgressStyle(PWizardPage page, PProgressStyle style, boolean animate) {
        int pageIdx = page.getIndex();
        if (pageIdx <= 0) {
            return;
        }
        JLabel label = (JLabel)this.myStepLabels.get(pageIdx - 1);
        if (!animate) {
            label.setIcon(style.myNonAnimatedIcon);
        } else {
            Image image = style.myIcon.getImage();
            Image tempImage = Toolkit.getDefaultToolkit().createImage(image.getSource());
            ImageIcon tempIcon = new ImageIcon(tempImage);
            label.setIcon(tempIcon);
            tempIcon.setImageObserver(label);
        }
        this.myTooltip.setStepStyle(pageIdx, style);
    }

    public void setSCFNames(List<String> scfNames) {
        if (scfNames != null) {
            for (String scfName : scfNames) {
                this.mySCFNameTooltip.addLabel(scfName);
            }
        }
    }

    protected PWizardToolTip getTooltip() {
        return this.myTooltip;
    }

    protected JScrollPane getScrollPane() {
        return this.scrollPaneForTip;
    }

    protected void scrollToVisible(int stepIdx) {
        if (stepIdx < 1) {
            return;
        }
        JLabel label = (JLabel)this.myStepLabels.get(stepIdx - 1);
        Rectangle bounds = label.getBounds();
        int newX = Math.min(bounds.x, this.myViewport.getView().getWidth() - this.myViewport.getViewRect().width);
        if (newX >= 0) {
            this.myViewport.setViewPosition(new Point(newX, bounds.y));
            this.myViewport.repaint();
        }
    }

    protected void addPage(PWizardPage page, PProgressStyle style) {
        JLabel label = new JLabel(style.myNonAnimatedIcon);
        label.setToolTipText(this.getProgressToolTipText(page));
        this.myProgressPanel.add(label);
        this.myStepLabels.add(label);
        this.myTooltip.addStep(this.getListToolTipText(page), style);
    }

    protected StepNameLabel getStepNameLabel() {
        return this.myStepNameLabel;
    }

    private boolean isLeftArrowShown() {
        return (int)this.myViewport.getViewPosition().getX() >= 16;
    }

    private boolean isRightArrowShown() {
        return this.myViewport.getViewRect().getX() + this.myViewport.getViewRect().getWidth() < (double)(this.myViewport.getView().getWidth() - 8);
    }

    private void move(int steps) {
        Point pt = this.myViewport.getViewPosition();
        pt.x += steps * 16;
        int direction = 1;
        if (steps < 0) {
            direction = -1;
        }
        this.myAnimationListener.setDest(pt);
        this.myAnimationListener.setDirection(direction);
        this.myAnimationTimer.start();
    }

    private int getHideDirection(int index) {
        JComponent label = (JComponent)this.myStepLabels.get(index - 1);
        Rectangle bounds = label.getBounds();
        if (bounds.x < this.myViewport.getViewRect().x) {
            return -1;
        }
        if (bounds.x + bounds.width > this.myViewport.getViewRect().x + this.myViewport.getViewRect().width) {
            return 1;
        }
        return 0;
    }

    private int getNumberOfVisibleSteps() {
        return this.myViewport.getViewRect().width / 16;
    }

    private int leftAlignViewportLocation(int xPos) {
        for (JComponent nextLabel : this.myStepLabels) {
            Rectangle nextBounds = nextLabel.getBounds();
            if (xPos < nextBounds.x || xPos >= nextBounds.x + nextBounds.width) continue;
            return nextBounds.x;
        }
        return xPos;
    }

    private int rightAlignViewportLocation(int xPos) {
        int width = this.myViewport.getViewRect().width;
        int viewportRightEdge = xPos + width;
        for (JComponent nextLabel : this.myStepLabels) {
            Rectangle nextBounds = nextLabel.getBounds();
            if (viewportRightEdge < nextBounds.x || viewportRightEdge >= nextBounds.x + nextBounds.width) continue;
            return nextBounds.x + nextBounds.width - width;
        }
        return xPos;
    }

    private boolean isStepLabelVisible(int index) {
        if (index < 1) {
            return false;
        }
        JComponent label = (JComponent)this.myStepLabels.get(index - 1);
        return this.myViewport.getViewRect().intersection(label.getBounds()).equals(label.getBounds());
    }

    protected String getProgressToolTipText(PWizardPage page) {
        int numberOfPages = page.getModel().getPageCount();
        Object[] args = new Object[]{String.valueOf(page.getIndex()), String.valueOf(numberOfPages), page.getName()};
        return MessageFormat.format(this.myResourceBundle.getString("PWizardConcept.Progress_ToolTipText"), args);
    }

    protected String getListToolTipText(PWizardPage page) {
        Object[] args = new Object[]{String.valueOf(page.getIndex()), page.getName()};
        return MessageFormat.format(this.myResourceBundle.getString("PWizardConcept.TooltipStep_Text"), args);
    }

    private class AnimationListener
    implements ActionListener {
        Point myDest;
        int myDirection;

        private AnimationListener() {
        }

        public void setDest(Point dest) {
            this.myDest = dest;
        }

        public void setDirection(int direction) {
            this.myDirection = direction;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Point pt = PWizardBar.this.myViewport.getViewPosition();
            Point newPos = new Point(pt);
            switch (this.myDirection) {
                case -1: {
                    newPos.x -= 3;
                    if (pt.x > this.myDest.x && newPos.x >= 0) break;
                    PWizardBar.this.myAnimationTimer.stop();
                    pt.x = PWizardBar.this.leftAlignViewportLocation(pt.x);
                    PWizardBar.this.myViewport.setViewPosition(pt);
                    return;
                }
                case 1: {
                    newPos.x += 3;
                    int maxX = PWizardBar.this.myViewport.getView().getWidth() - ((PWizardBar)PWizardBar.this).myViewport.getViewRect().width;
                    if (pt.x >= this.myDest.x || newPos.x > maxX) {
                        PWizardBar.this.myAnimationTimer.stop();
                        pt.x = PWizardBar.this.rightAlignViewportLocation(pt.x);
                        PWizardBar.this.myViewport.setViewPosition(pt);
                        return;
                    }
                    pt.x += 3;
                    break;
                }
            }
            PWizardBar.this.myViewport.setViewPosition(newPos);
        }
    }

    public static class StepNameLabel
    extends PLabel {
        private static final long serialVersionUID = 1L;
        private int myFixedWidth;

        public StepNameLabel() {
            this.setName("SetpNameLabel");
            this.setLabelType(ClientProperties.LABEL_SUB_HEADER);
            this.setOffsetForeground(null);
            this.setForeground(HEADER_TEXT_COLOR);
        }

        public void setFixedWidth(int fixedWidth) {
            this.myFixedWidth = fixedWidth;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            int width = this.myFixedWidth != 0 ? this.myFixedWidth : dim.width;
            return new Dimension(width, dim.height);
        }
    }
}

