/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.wizard;

import com.nokia.em.poseidon.frameworks.mvc.ControllerBase;
import com.nokia.em.poseidon.frameworks.wizard.PWizardAdapter;
import com.nokia.em.poseidon.frameworks.wizard.PWizardListener;
import com.nokia.em.poseidon.frameworks.wizard.PWizardModeling;
import com.nokia.em.poseidon.frameworks.wizard.PWizardPage;
import com.nokia.em.poseidon.frameworks.wizard.WizardModelListener;
import com.nokia.em.poseidon.gui.wizard.PWizardView;
import com.nokia.em.poseidon.util.progressoperation.ProgressOperation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PWizardController
extends ControllerBase
implements WizardModelListener,
PropertyChangeListener {
    protected PWizardModeling myWinModel;
    private String myWizardName;
    private boolean myShowProgress;

    public PWizardController(String iconName, String wizardName, PWizardModeling model) {
        this.myWinModel = model;
        this.myWizardName = wizardName;
        this.setCurrentPage(this.myWinModel.getFirstPage());
        this.myView = this.createView(this, wizardName, iconName);
        this.myWinModel.addPropertyChangeListener((PWizardView)this.myView);
        this.myWinModel.addPropertyChangeListener(this);
        this.myWinModel.addWizardModelListener(this);
        this.setView(this.myView);
        ((PWizardView)this.myView).refresh(this.myWinModel);
        ((PWizardView)this.myView).showPage(this.getCurrentPage(), this.getCurrentPage());
        if (this.getCurrentPage() != null && this.getCurrentPage().doActivate()) {
            this.myWinModel.fireActivateNotify();
        }
    }

    public void setShowProgress(boolean showProgress) {
        this.myShowProgress = showProgress;
    }

    protected PWizardView createView(PWizardController controller, String wizardName, String iconName) {
        return new PWizardView(controller, wizardName, iconName);
    }

    @Override
    public void modelUpdated(PWizardModeling model) {
        if (model.indexOf(this.getCurrentPage()) < 1) {
            this.myWinModel.removePropertyChangeListener(this);
            this.setCurrentPage(model.getFirstPage());
            this.myWinModel.addPropertyChangeListener(this);
        }
        ((PWizardView)this.myView).refresh(model);
    }

    public PWizardPage getCurrentPage() {
        return this.myWinModel.getCurrentPage();
    }

    public int getCurrentPageIndex() {
        return this.myWinModel.indexOf(this.getCurrentPage());
    }

    public void addWizardListener(PWizardListener listener) {
        if (listener != null) {
            this.myWinModel.addWizardListener(listener);
        }
    }

    public void removeWizardListener(PWizardListener listener) {
        this.myWinModel.removeWizardListener(listener);
    }

    public void setParentContainer(JPanel panel) {
        panel.removeAll();
        panel.setLayout(new BorderLayout());
        panel.add((Component)((Object)this.getView()), "Center");
        panel.revalidate();
        panel.repaint();
    }

    public void setParentContainer(JDialog dialog) {
        this.setParentContainer(dialog, this.myWizardName);
    }

    public void setParentContainer(JDialog dialog, String title) {
        dialog.setDefaultCloseOperation(0);
        dialog.setTitle(title);
        this.setParentHelper(dialog);
    }

    public void setParentContainer(JFrame frame) {
        this.setParentContainer(frame, this.myWizardName);
    }

    public void setParentContainer(JFrame frame, String title) {
        frame.setDefaultCloseOperation(0);
        frame.setTitle(title);
        this.setParentHelper(frame);
    }

    @Override
    public void destroy() {
        Logger.getLogger(this.getClass()).debug("Destroy called.");
        this.myWinModel.removePropertyChangeListener((PWizardView)this.myView);
        this.myView = null;
        this.myWinModel.removePropertyChangeListener(this);
        this.myWinModel.removeWizardModelListener(this);
        this.myWinModel.destroyModel();
        this.myWinModel = null;
    }

    public void pageSpecificHelpRequest() {
        this.getCurrentPage().helpClicked();
    }

    public void generalHelpRequest() {
    }

    public void nextRequest() {
        this.invokePageChange(new Runnable(){

            @Override
            public void run() {
                if (PWizardController.this.getCurrentPage().doNext()) {
                    PWizardPage nextPage = PWizardController.this.myWinModel.getNextEnabledPage(PWizardController.this.getCurrentPage());
                    if (nextPage == null) {
                        return;
                    }
                    PWizardPage oldPage = PWizardController.this.getCurrentPage();
                    PWizardController.this.myWinModel.removePropertyChangeListener(PWizardController.this);
                    PWizardController.this.setCurrentPage(nextPage);
                    if (!nextPage.doActivate()) {
                        PWizardController.this.setCurrentPage(oldPage);
                    }
                    PWizardController.this.myWinModel.addPropertyChangeListener(PWizardController.this);
                    ((PWizardView)PWizardController.this.myView).showPage(PWizardController.this.getCurrentPage(), oldPage);
                    PWizardController.this.myWinModel.fireNextNotify();
                    PWizardController.this.myWinModel.fireActivateNotify();
                }
            }
        });
    }

    public void previousRequest() {
        this.invokePageChange(new Runnable(){

            @Override
            public void run() {
                if (PWizardController.this.getCurrentPage().doPrevious()) {
                    PWizardPage prevPage = PWizardController.this.myWinModel.getPreviousEnabledPage(PWizardController.this.getCurrentPage());
                    if (prevPage == null) {
                        return;
                    }
                    PWizardPage oldPage = PWizardController.this.getCurrentPage();
                    PWizardController.this.myWinModel.removePropertyChangeListener(PWizardController.this);
                    PWizardController.this.setCurrentPage(prevPage);
                    if (!prevPage.doActivate()) {
                        PWizardController.this.setCurrentPage(oldPage);
                    }
                    PWizardController.this.myWinModel.addPropertyChangeListener(PWizardController.this);
                    ((PWizardView)PWizardController.this.myView).showPage(PWizardController.this.getCurrentPage(), oldPage);
                    PWizardController.this.myWinModel.firePreviousNotify();
                    PWizardController.this.myWinModel.fireActivateNotify();
                }
            }
        });
    }

    public void cancelRequest() {
        if (this.getCurrentPage().doCancel()) {
            this.myWinModel.fireCancelNotify();
        }
    }

    public void finishRequest() {
        if (this.getCurrentPage().doFinish()) {
            this.myWinModel.fireFinishNotify();
        }
    }

    protected void invokePageChange(Runnable change) {
        if (this.myShowProgress) {
            ProgressOperation.createOperation(change).run();
        } else {
            change.run();
        }
    }

    private void setParentHelper(Window window) {
        ((PWizardView)this.myView).setForDialog(true);
        ((RootPaneContainer)((Object)window)).setContentPane((Container)((Object)this.getView()));
        this.addWizardListener(new FrameCloser(window));
        window.addWindowListener(new WindowCloseGuard(window));
        window.pack();
        window.setVisible(true);
        window.toFront();
    }

    protected void setCurrentPage(PWizardPage currentPage) {
        this.myWinModel.setCurrentPage(currentPage);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentPage".equals(evt.getPropertyName())) {
            final PWizardPage currentPage = (PWizardPage)evt.getNewValue();
            final PWizardPage oldValue = (PWizardPage)evt.getOldValue();
            if (currentPage == null || !currentPage.isEnabled()) {
                return;
            }
            currentPage.doActivate();
            this.myWinModel.fireActivateNotify();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((PWizardView)PWizardController.this.myView).showPage(currentPage, oldValue);
                    ((PWizardView)PWizardController.this.myView).refresh(PWizardController.this.myWinModel);
                }
            });
        } else if ("refreshPage".equals(evt.getPropertyName())) {
            ((PWizardView)this.myView).showPage(this.myWinModel.getCurrentPage(), this.myWinModel.getCurrentPage());
        }
    }

    private class FrameCloser
    extends PWizardAdapter {
        private Window myParentFrame;

        public FrameCloser(Window parentFrame) {
            this.myParentFrame = parentFrame;
        }

        @Override
        public void cancelNotify() {
            this.closeWizard();
            PWizardController.this.myWinModel.removeWizardListener(this);
        }

        @Override
        public void finishNotify() {
            this.closeWizard();
            PWizardController.this.myWinModel.removeWizardListener(this);
        }

        private void closeWizard() {
            this.myParentFrame.setVisible(false);
            this.myParentFrame.dispose();
        }
    }

    private class WindowCloseGuard
    extends WindowAdapter {
        private Window myParentWindow;

        public WindowCloseGuard(Window window) {
            this.myParentWindow = window;
        }

        @Override
        public void windowClosing(WindowEvent event) {
            if (PWizardController.this.getCurrentPage().doCancel()) {
                this.myParentWindow.setVisible(false);
                this.myParentWindow.dispose();
                this.myParentWindow.removeWindowListener(this);
                PWizardController.this.myWinModel.fireCancelNotify();
            }
        }
    }
}

