/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.wizard;

import com.nokia.em.poseidon.gui.wizard.PProgressStyle;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PVerticalLayout;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class PWizardToolTip
extends PPanel {
    protected List myStepLabels;
    private static int STEP_SPACING = 6;
    protected Font myStepFont;

    public PWizardToolTip() {
        this.buildUI();
    }

    public void clear() {
        this.removeAll();
        this.myStepLabels.clear();
    }

    public void addStep(String text, PProgressStyle style) {
        PLabel label = new PLabel(text, style.myTooltipIcon, 0);
        label.setFont(this.myStepFont.deriveFont(style.myFontModifiers));
        label.setForeground(style.myTooltipFontColor);
        this.myStepLabels.add(label);
        this.add(label);
    }

    public void addTitle(String text) {
        if (text == null || "".equals(text)) {
            return;
        }
        PLabel label = PLabel.createTitle(text);
        label.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.add(label);
    }

    public void addLabel(String text) {
        if (text == null || "".equals(text)) {
            return;
        }
        PLabel label = PLabel.createTipText(text);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add(label);
    }

    public void addGroupTitle(String text) {
        if (text == null || "".equals(text)) {
            return;
        }
        PLabel label = new PLabel(text);
        label.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        label.setFont(this.myStepFont);
        this.add(label);
    }

    public void setStepStyle(int index, PProgressStyle style) {
        if (index > 0 && index <= this.myStepLabels.size()) {
            PLabel label = (PLabel)this.myStepLabels.get(index - 1);
            label.setIcon(style.myTooltipIcon);
            label.setForeground(style.myTooltipFontColor);
            label.setFont(label.getFont().deriveFont(style.myFontModifiers));
        }
    }

    protected void buildUI() {
        this.setLayout(new PVerticalLayout(0, STEP_SPACING, STEP_SPACING, STEP_SPACING));
        this.myStepFont = NetLookAndFeel.getUserTextFont().deriveFont((float)(12 + NetLookAndFeel.getFontSizeIncrement()));
        this.myStepLabels = new ArrayList();
        this.setBackground(Color.white);
        Border border = BorderFactory.createEmptyBorder(1, 4, 4, 8);
        this.setBorder(border);
    }
}

