/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.wizard;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.mvc.swing.JPanelViewBase;
import com.nokia.em.poseidon.frameworks.wizard.PWizardGroup;
import com.nokia.em.poseidon.frameworks.wizard.PWizardModel;
import com.nokia.em.poseidon.frameworks.wizard.PWizardModeling;
import com.nokia.em.poseidon.frameworks.wizard.PWizardPage;
import com.nokia.em.poseidon.gui.wizard.PProgressStyle;
import com.nokia.em.poseidon.gui.wizard.PWizardBar;
import com.nokia.em.poseidon.gui.wizard.PWizardController;
import com.nokia.em.poseidon.gui.wizard.PWizardToolTip;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.buttons.PButton;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.labels.PMultiLineLabel;
import com.nokia.widgets.layout.WizardButtonBarLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.AbstractBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class PWizardView
extends JPanelViewBase
implements ActionListener,
PropertyChangeListener {
    protected PPanel myButtonBar;
    protected PWizardBar myWizardBar;
    protected List myExtraButtons;
    protected PProgressStyle myDoneStyle;
    protected PProgressStyle myUpcomingStyle;
    protected PProgressStyle mySkippedStyle;
    protected PProgressStyle myCurrentStyle;
    private PButton myNextButton;
    private JButton myBackButton;
    private JButton myCancelButton;
    private PButton myFinishButton;
    private static final String CANCEL_ACTION = "CANCEL";
    private final PWizardController myWizardController;
    private final ResourceBundle myResourceBundle;
    private PageArea myCenterPanel;

    public PWizardView(PWizardController controller, String wizardName, String iconName) {
        super(controller);
        this.myWizardController = controller;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myExtraButtons = new ArrayList();
        this.setLayout(new BorderLayout());
        this.buildUI(iconName, wizardName);
    }

    public PWizardBar getWizardBar() {
        return this.myWizardBar;
    }

    public void refresh(PWizardModeling model) {
        this.myWizardBar.clear();
        if (((PWizardModel)model).isSCFNameDisabled() || ((PWizardModel)model).getCurrentPage().getModel().getPageCount() == 1) {
            this.myWizardBar.enableSCFNameButton(false);
        } else {
            List<String> scfNames = ((PWizardModel)model).getBTSSCFNames();
            this.myWizardBar.setSCFNames(scfNames);
            this.myWizardBar.enableSCFNameButton(true);
        }
        PWizardToolTip tooltip = this.myWizardBar.getTooltip();
        tooltip.addTitle(model.getStepListTitle());
        List groups = model.getGroups();
        int maxNameWidth = 0;
        for (PWizardGroup group : groups) {
            tooltip.addGroupTitle(group.getName());
            List pages = group.getPages();
            int groupNameWidth = this.getFontMetrics(this.myWizardBar.getStepNameLabel().getFont()).stringWidth(group.getName());
            maxNameWidth = Math.max(maxNameWidth, groupNameWidth);
            PWizardPage page2 = null;
            for (PWizardPage page2 : pages) {
                int nameWidth = this.calculatePageTitleWidth(page2);
                maxNameWidth = Math.max(maxNameWidth, nameWidth);
                PProgressStyle style = this.getProgressStyle(page2);
                this.myWizardBar.addPage(page2, style);
            }
        }
        PWizardBar.StepNameLabel stepNameLabel = this.myWizardBar.getStepNameLabel();
        Insets insets = stepNameLabel.getInsets();
        stepNameLabel.setFixedWidth(maxNameWidth += insets.right + insets.left);
        Dimension toolTipDi = tooltip.getPreferredSize();
        int scrollbarWidth = (int)this.myWizardBar.getScrollPane().getVerticalScrollBar().getPreferredSize().getWidth();
        this.myWizardBar.getScrollPane().setPreferredSize(new Dimension(maxNameWidth + scrollbarWidth + 22, (int)toolTipDi.getHeight() + 10));
        this.myWizardBar.setCurrentPage(this.myWizardController.getCurrentPage());
        this.myWizardBar.setStatusText(model.getStatus());
        this.myWizardBar.revalidate();
        this.myWizardBar.repaint();
    }

    public void showPage(PWizardPage page, PWizardPage previousPage) {
        if (page == null) {
            return;
        }
        if (!page.isInitialized()) {
            page.resetToDefaults();
        }
        this.displayPageDescription(page);
        this.displayPageContent(page);
        this.updateWizardButtons(page);
        this.updateExtraButtons(page);
        this.updateProgressBar(page, previousPage);
        this.revalidate();
        this.repaint();
    }

    protected void displayPageContent(PWizardPage page) {
        this.myCenterPanel.setPage(page.getPageView());
    }

    protected void displayPageDescription(PWizardPage page) {
        String text = page.getDescription();
        this.myCenterPanel.setHeader(text);
    }

    public JButton getNextButton() {
        return this.myNextButton;
    }

    public JButton getBackButton() {
        return this.myBackButton;
    }

    public JButton getCancelButton() {
        return this.myCancelButton;
    }

    public JButton getFinishButton() {
        return this.myFinishButton;
    }

    public PPanel getButtonPanel() {
        return this.myButtonBar;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.myNextButton) {
            this.myWizardController.nextRequest();
        } else if (src == this.myBackButton) {
            this.myWizardController.previousRequest();
        } else if (src == this.myCancelButton) {
            this.myWizardController.cancelRequest();
        } else if (src == this.myFinishButton) {
            this.myWizardController.finishRequest();
        } else if (event.getActionCommand().equals("PWizardBar.HelpButton")) {
            this.myWizardController.generalHelpRequest();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String changedProperty = evt.getPropertyName();
        Object src = evt.getSource();
        if (!(this.myWizardController.getCurrentPage() == src || (changedProperty.equals("enabled") || changedProperty.equals("nameUpdate")) && src instanceof PWizardPage)) {
            return;
        }
        PWizardPage page = (PWizardPage)src;
        if (changedProperty.equals("enabled")) {
            PProgressStyle style = this.getProgressStyle(page);
            this.myWizardBar.setProgressStyle(page, style, false);
        } else if (changedProperty.equals("cancelEnabled")) {
            this.myCancelButton.setEnabled(page.isCancelEnabled());
        } else if (changedProperty.equals("finishEnabled")) {
            this.myFinishButton.setEnabled(page.isFinishEnabled());
        } else if (changedProperty.equals("backEnabled")) {
            this.myBackButton.setEnabled(page.isBackEnabled());
        } else if (changedProperty.equals("nextEnabled")) {
            this.myNextButton.setEnabled(page.isNextEnabled());
        } else if (changedProperty.equals("cancelVisible")) {
            this.myCancelButton.setVisible(page.isCancelVisible());
        } else if (changedProperty.equals("finishVisible")) {
            this.myFinishButton.setVisible(page.isFinishVisible());
        } else if (changedProperty.equals("backVisible")) {
            this.myBackButton.setVisible(page.isBackVisible());
        } else if (changedProperty.equals("nextVisible")) {
            this.myNextButton.setVisible(page.isNextVisible());
        } else if (changedProperty.equals("nameUpdate")) {
            this.refresh(page.getModel());
        }
    }

    protected PProgressStyle getProgressStyle(PWizardPage page) {
        PProgressStyle style = null;
        int currentIdx = this.myWizardController.getCurrentPageIndex();
        int indexRelativeToCurrent = page.getIndex() - currentIdx;
        style = !page.isEnabled() ? this.mySkippedStyle : (indexRelativeToCurrent > 0 ? this.myUpcomingStyle : (indexRelativeToCurrent < 0 ? this.myDoneStyle : this.myCurrentStyle));
        return style;
    }

    protected void updateExtraButtons(PWizardPage page) {
        if (this.myExtraButtons != null) {
            for (Component button : this.myExtraButtons) {
                this.myButtonBar.remove(button.getParent());
            }
        }
        this.myExtraButtons = page.getExtraButtons();
        if (this.myExtraButtons != null) {
            int position = 0;
            Iterator iter = this.myExtraButtons.iterator();
            while (iter.hasNext()) {
                JPanel tempPanel = new JPanel(new BorderLayout());
                AbstractButton button = (AbstractButton)iter.next();
                if (!iter.hasNext()) {
                    tempPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
                } else {
                    tempPanel.setBorder(null);
                }
                tempPanel.add(button);
                this.myButtonBar.add((Component)tempPanel, position++);
            }
        }
    }

    protected void updateWizardButtons(PWizardPage page) {
        this.myNextButton.setVisible(page.isNextVisible());
        this.myBackButton.setVisible(page.isBackVisible());
        this.myFinishButton.setVisible(page.isFinishVisible());
        this.myCancelButton.setVisible(page.isCancelVisible());
        this.myNextButton.setEnabled(page.isNextEnabled());
        this.myBackButton.setEnabled(page.isBackEnabled());
        this.myFinishButton.setEnabled(page.isFinishEnabled());
        this.myCancelButton.setEnabled(page.isCancelEnabled());
        this.myNextButton.setDefaultButton(false);
        this.myFinishButton.setDefaultButton(false);
        if (this.myNextButton.isEnabled() || !this.myFinishButton.isEnabled() || !this.myFinishButton.isVisible()) {
            this.myNextButton.setDefaultButton(true);
        } else {
            this.myFinishButton.setDefaultButton(true);
        }
    }

    protected void setForDialog(boolean dialog) {
        if (dialog) {
            this.myWizardBar.setWizardNameVisible(false);
            PWizardBar.StepNameLabel stepName = this.myWizardBar.getStepNameLabel();
            stepName.setBorder(new EmptyBorder(9, 0, 0, 0));
        } else {
            this.myWizardBar.setWizardNameVisible(true);
            PWizardBar.StepNameLabel stepName = this.myWizardBar.getStepNameLabel();
            stepName.setBorder(null);
        }
    }

    protected void buildUI(String iconName, String wizardName) {
        this.myDoneStyle = new PProgressStyle(CommonIcons.getProgressSuccessIcon(), CommonIcons.getProgressSuccessIcon(), CommonIcons.getProgressSuccessIcon(), NetLookAndFeel.getCurrentTheme().getControlInfo(), 0);
        this.myUpcomingStyle = new PProgressStyle(this.myResourceBundle.getImageIcon("ProgressTask.upcoming"), this.myResourceBundle.getImageIcon("ProgressTask.upcoming"), this.myResourceBundle.getImageIcon("ProgressTask.upcoming"), NetLookAndFeel.getCurrentTheme().getControlInfo(), 0);
        this.mySkippedStyle = new PProgressStyle(this.myResourceBundle.getImageIcon("ProgressTask.cancelled"), this.myResourceBundle.getImageIcon("ProgressTask.cancelled"), this.myResourceBundle.getImageIcon("ProgressTask.cancelled"), NetLookAndFeel.getCurrentTheme().getControlDisabled(), 0);
        this.myCurrentStyle = new PProgressStyle(CommonIcons.getWizardProgressOngoing(), CommonIcons.getWizardProgressOngoing(), CommonIcons.getWizardProgressOngoing(), NetLookAndFeel.getCurrentTheme().getControlInfo(), 1);
        this.myButtonBar = new PPanel();
        this.myButtonBar.setPanelType(ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        this.myButtonBar.setVisibleUpperEdge(true);
        this.myButtonBar.setLayout(new WizardButtonBarLayout());
        this.myNextButton = this.createButton("PWizardConcept.NextButton");
        this.myNextButton.setDefaultButton(true);
        this.myNextButton.setHorizontalTextPosition(2);
        this.myBackButton = this.createButton("PWizardConcept.BackButton");
        this.myCancelButton = this.createButton("CancelAction");
        this.myFinishButton = this.createButton("PWizardConcept.FinishButton");
        this.myButtonBar.add((Component)this.myBackButton, WizardButtonBarLayout.BACK_BUTTON);
        this.myButtonBar.add((Component)this.myNextButton, WizardButtonBarLayout.NEXT_BUTTON);
        this.myButtonBar.add((Component)this.myFinishButton, WizardButtonBarLayout.FINISH_BUTTON);
        this.myButtonBar.add((Component)this.myCancelButton, WizardButtonBarLayout.CANCEL_BUTTON);
        this.add((Component)this.myButtonBar, "South");
        this.myWizardBar = new PWizardBar(iconName, wizardName, null);
        this.add((Component)this.myWizardBar, "North");
        this.myCenterPanel = this.createCenterPanel();
        this.add((Component)((Object)this.myCenterPanel), "Center");
        this.bindShortcutKeys();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PWizardView.this.myWizardBar.scrollToVisible(PWizardView.this.myWizardController.getCurrentPageIndex());
            }
        });
        Localizer myLocaliser = LocalizerRegistry.lookup("swing");
        myLocaliser.setResourceBundle(this.myResourceBundle);
        myLocaliser.localizeObjectHierarchy(new SwingHierarchyIterator(this));
        this.repaint();
    }

    protected PageArea createCenterPanel() {
        return new PagePanel();
    }

    protected String getContextSensitiveHelpMenuItemName() {
        return this.myResourceBundle.getString("PWizardConcept.ContextSensitiveHelpMenuItem_Text");
    }

    private void bindShortcutKeys() {
        AbstractAction helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PWizardView.this.myWizardController.pageSpecificHelpRequest();
            }
        };
        helpAction.putValue("Name", this.getContextSensitiveHelpMenuItemName());
        PHelp help = PoseidonRuntime.getRuntime().getService(PHelp.class);
        help.addContextSensitiveHelpAction(this, helpAction);
        AbstractAction cancelAction = new AbstractAction(CANCEL_ACTION){

            @Override
            public void actionPerformed(ActionEvent event) {
                PWizardView.this.myWizardController.cancelRequest();
            }
        };
        this.getActionMap().put(cancelAction.getValue("Name"), cancelAction);
        KeyStroke keystroke = KeyStroke.getKeyStroke(27, 0, false);
        this.registerKeyboardAction(cancelAction, keystroke, 1);
    }

    private PButton createButton(String name) {
        PButton btn = new PButton();
        btn.setName(name);
        btn.addActionListener(this);
        return btn;
    }

    protected void updateProgressBar(PWizardPage page, PWizardPage previousPage) {
        this.myWizardBar.setCurrentPage(page);
        if (page == previousPage) {
            return;
        }
        this.myWizardBar.setProgressStyle(page, this.myCurrentStyle, true);
        PProgressStyle prevStyle = this.getProgressStyle(previousPage);
        this.myWizardBar.setProgressStyle(previousPage, prevStyle, true);
    }

    private int calculatePageTitleWidth(PWizardPage page) {
        return this.getFontMetrics(this.myWizardBar.getStepNameLabel().getFont()).stringWidth(page.getName());
    }

    protected static interface PageArea {
        public void setPage(Component var1);

        public void setHeader(String var1);
    }

    protected static class PagePanel
    extends JPanel
    implements PageArea {
        private final JTextComponent myDescriptionLabel = this.createDescriptionLabel();

        public PagePanel() {
            super(new BorderLayout());
            this.add((Component)this.myDescriptionLabel, "North");
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public void setHeader(String text) {
            if (text == null || "".equals(text)) {
                this.myDescriptionLabel.setText("");
                this.myDescriptionLabel.setVisible(false);
            } else {
                this.myDescriptionLabel.setText(text);
                this.myDescriptionLabel.setCaretPosition(0);
                this.myDescriptionLabel.setVisible(true);
            }
        }

        @Override
        public void setPage(Component view) {
            Dimension size = this.myDescriptionLabel.getSize();
            size.width = (int)view.getPreferredSize().getWidth();
            this.myDescriptionLabel.setMaximumSize(size);
            this.myDescriptionLabel.setPreferredSize(size);
            this.myDescriptionLabel.setMinimumSize(size);
            this.removeAll();
            if (this.myDescriptionLabel.getText() != null && !"".equals(this.myDescriptionLabel.getText())) {
                this.add((Component)this.myDescriptionLabel, "North");
            }
            this.add(view, "Center");
        }

        protected JTextComponent createDescriptionLabel() {
            PMultiLineLabel label = new PMultiLineLabel();
            label.setBorder(BorderFactory.createEmptyBorder(18, 18, 0, 0));
            label.setRows(2);
            label.setWrapStyleWord(true);
            label.setOpaque(true);
            return label;
        }
    }

    protected static class WizardHeaderBorder
    extends AbstractBorder {
        protected WizardHeaderBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            return new Insets(0, 0, 2, 0);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(NetTheme.COLOR_BLUE_5);
            g.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
            g.setColor(NetTheme.COLOR_WHITE_20);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        }
    }
}

