/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.plugin.application;

import com.nokia.em.poseidon.plugin.application.AppDescription;
import com.nokia.em.poseidon.plugin.application.Application;
import com.nokia.em.poseidon.plugin.application.ApplicationGrade;
import com.nokia.em.poseidon.plugin.application.ApplicationStatus;
import com.nokia.em.poseidon.plugin.registry.PluginRegistry;
import com.nokia.em.poseidon.util.probe.Probe;
import com.nokia.em.poseidon.util.probe.ProbeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplicationRegistry
extends PluginRegistry<Application> {
    private Map<Application, ApplicationGrade> myApplicationToGrade = new HashMap<Application, ApplicationGrade>();

    public ApplicationRegistry() {
        ProbeManager.addProbe(Probe.Type.MULTIPLE_EXECUTION, "Application Startup", "Application Startup Times");
    }

    @Override
    public void close() {
        super.close();
        this.myApplicationToGrade.clear();
    }

    public void add(String name, Application application, ApplicationGrade grade) {
        this.myItemNameToStatus.put(name, ApplicationStatus.IDLE);
        this.myApplicationToGrade.put(application, grade);
        super.add(name, application);
    }

    @Override
    public void add(String name, Application application) {
        ApplicationGrade grade = this.size() == 0 ? ApplicationGrade.MASTER : ApplicationGrade.SECONDARY;
        this.add(name, application, grade);
    }

    public ApplicationGrade getApplicationGrade(Application application) {
        return this.myApplicationToGrade.get(application);
    }

    public <T> List<T> getApplications(ApplicationGrade grade) {
        ArrayList apps = new ArrayList();
        for (Object application : this.getAll()) {
            if (!grade.equals((Object)this.myApplicationToGrade.get(application))) continue;
            apps.add(application);
        }
        return apps;
    }

    public ApplicationStatus getApplicationStatus(String appName) {
        return (ApplicationStatus)((Object)this.myItemNameToStatus.get(appName));
    }

    public ApplicationStatus getApplicationStatus(Application application) {
        String name = this.getItemName(application);
        if (name != null) {
            return this.getApplicationStatus(name);
        }
        return null;
    }

    public void setApplicationStatus(ApplicationStatus status, Application application) {
        String name = this.getItemName(application);
        if (name != null) {
            this.setApplicationStatus(status, name);
        }
    }

    public void setApplicationStatus(ApplicationStatus status, String appName) {
        Application app = (Application)this.get(appName);
        if (!this.getApplicationStatus(appName).equals((Object)status)) {
            this.myItemNameToStatus.put(appName, status);
            this.myLogger.debug("Setting application status: " + (Object)((Object)status) + " to application:  " + appName);
            switch (status) {
                case INITIALIZE: {
                    ProbeManager.startProbe("Application Startup");
                    app.initialize();
                    break;
                }
                case STARTUP: {
                    app.startUp();
                    break;
                }
                case READY: {
                    app.ready();
                    ProbeManager.stopProbe("Application Startup", appName);
                    break;
                }
                case EXIT: {
                    app.exit();
                    break;
                }
                case SHUTDOWN: {
                    app.shutDown();
                    break;
                }
            }
        }
    }

    public Collection<AppDescription> getAppDescriptions() {
        ArrayList<AppDescription> toReturn = new ArrayList<AppDescription>();
        List apps = this.getAll();
        for (Application app : apps) {
            toReturn.add(app.getDescription());
        }
        return toReturn;
    }
}

