/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.plugin.conf;

import com.nokia.em.poseidon.plugin.conf.ConfUtils;
import com.nokia.em.poseidon.plugin.conf.Plugin;
import com.nokia.em.poseidon.plugin.conf.Property;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.ArrayList;
import java.util.List;

public class Configuration {
    protected List<Property> myProperties;
    protected List<Plugin> myPlugins = new ArrayList<Plugin>();
    protected String myNotation;

    public void mergeConfiguration(Configuration configuration) {
        if (configuration.getPlugins() != null) {
            for (Plugin plugin : configuration.getPlugins()) {
                this.addPlugin(plugin);
            }
        }
        if (configuration.getProperties() != null) {
            for (Property property : configuration.getProperties()) {
                this.addProperty(property);
            }
        }
    }

    public String getNotation() {
        return this.myNotation;
    }

    public void setNotation(String notation) {
        this.myNotation = notation;
    }

    public List<Property> getProperties() {
        return this.myProperties;
    }

    public void setProperties(List<Property> properties) {
        if (properties != null) {
            if (this.myProperties == null) {
                this.myProperties = properties;
            } else {
                this.myProperties.addAll(properties);
            }
        }
    }

    public void addProperty(Property property) {
        if (property != null) {
            if (this.myProperties == null) {
                this.myProperties = new ArrayList<Property>();
            }
            this.myProperties.add(property);
        }
    }

    public List<Plugin> getPlugins() {
        return this.myPlugins;
    }

    public void addPlugin(Plugin plugin) {
        Plugin duplicate = this.getPluginByName(plugin.getName());
        if (duplicate != null) {
            int index = this.myPlugins.indexOf(duplicate);
            this.myPlugins.set(index, plugin);
        } else {
            this.myPlugins.add(plugin);
        }
    }

    public <T extends Plugin> void setPlugins(List<T> plugins) {
        this.myPlugins.addAll(plugins);
    }

    public Plugin getPluginByName(String name) {
        for (Plugin plugin : this.getPlugins()) {
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    public List<Plugin> getPluginsByGrade(String grade) {
        ArrayList<Plugin> list = new ArrayList<Plugin>();
        for (Plugin plugin : this.getPlugins()) {
            if (!plugin.getGrade().equals(grade)) continue;
            list.add(plugin);
        }
        return list;
    }

    public List<Plugin> getPluginsByType(String type) {
        ArrayList<Plugin> list = new ArrayList<Plugin>();
        for (Plugin plugin : this.getPlugins()) {
            if (!plugin.getType().equals(type)) continue;
            list.add(plugin);
        }
        return list;
    }

    public PCmdLineParams parseFromProperties() {
        return ConfUtils.parseFromArgs(this.myProperties);
    }

    public String toString() {
        return "Configuration [myPlugins: " + this.myPlugins + "]";
    }
}

