/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.plugin.conf;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.plugin.application.Application;
import com.nokia.em.poseidon.plugin.application.ApplicationGrade;
import com.nokia.em.poseidon.plugin.application.ApplicationRegistry;
import com.nokia.em.poseidon.plugin.conf.Configuration;
import com.nokia.em.poseidon.plugin.conf.ConfigurationEvent;
import com.nokia.em.poseidon.plugin.conf.ConfigurationException;
import com.nokia.em.poseidon.plugin.conf.ConfigurationListener;
import com.nokia.em.poseidon.plugin.conf.Plugin;
import com.nokia.em.poseidon.plugin.conf.Property;
import com.nokia.em.poseidon.plugin.object.ObjectRegistry;
import com.nokia.em.poseidon.plugin.operation.OperationRegistry;
import com.nokia.em.poseidon.plugin.properties.PropertyManager;
import com.nokia.em.poseidon.plugin.registry.ParameterInjector;
import com.nokia.em.poseidon.plugin.registry.PluginRegistry;
import com.nokia.em.poseidon.plugin.service.ServiceRegistry;
import com.nokia.em.poseidon.util.PCmdLineParams;
import com.nokia.em.poseidon.util.file.IOUtils;
import com.nokia.em.poseidon.util.file.PFileUtils;
import com.nokia.em.poseidon.util.probe.Probe;
import com.nokia.em.poseidon.util.probe.ProbeManager;
import com.nokia.em.poseidon.util.xml.ObjectLoadException;
import com.nokia.em.poseidon.util.xml.ObjectLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class ConfigurationManager {
    protected static final String ADD_URL_METHOD = "addURL";
    protected static ConfigurationManager theInstance;
    protected List<ConfigurationListener> myConfListeners;
    protected Configuration myCurrentConfiguration;
    protected Map<String, Class> myPluginTypeToRegistry;
    protected Logger myLogger = Logger.getLogger(this.getClass());

    protected ConfigurationManager() {
        this.myConfListeners = new CopyOnWriteArrayList<ConfigurationListener>();
        this.myPluginTypeToRegistry = new HashMap<String, Class>();
        this.myPluginTypeToRegistry.put("application", ApplicationRegistry.class);
        this.myPluginTypeToRegistry.put("object", ObjectRegistry.class);
        this.myPluginTypeToRegistry.put("operation", OperationRegistry.class);
        this.myPluginTypeToRegistry.put("service", ServiceRegistry.class);
        ProbeManager.addProbe(Probe.Type.MULTIPLE_EXECUTION, "Create plugin", "Plugin creation times");
    }

    public static synchronized ConfigurationManager getInstance() {
        if (theInstance == null) {
            theInstance = new ConfigurationManager();
        }
        return theInstance;
    }

    public void insertConfiguration(Configuration configuration) throws ConfigurationException {
        this.checkConfValidity(configuration);
        this.flattenConfiguration(configuration);
        if (this.myCurrentConfiguration == null) {
            this.myCurrentConfiguration = configuration;
        } else {
            this.myCurrentConfiguration.mergeConfiguration(configuration);
        }
        this.fireConfigurationInserted(configuration);
    }

    protected void flattenConfiguration(Configuration configuration) throws ConfigurationException {
        if (configuration.getProperties() != null) {
            Iterator<Property> iter = configuration.getProperties().iterator();
            while (iter.hasNext()) {
                Property property = iter.next();
                if (!property.getName().equals("conffile")) continue;
                Configuration toBeFlattened = this.parseConfiguration(property.getValue());
                this.flattenConfiguration(toBeFlattened);
                configuration.mergeConfiguration(toBeFlattened);
                iter.remove();
            }
        }
    }

    public void insertConfiguration(String configurationLocation) throws ConfigurationException {
        this.insertConfiguration(this.parseConfiguration(configurationLocation));
    }

    public void insertConfiguration(URL configurationURL) throws ConfigurationException {
        this.insertConfiguration(this.parseConfiguration(configurationURL));
    }

    public void executeCurrentConfiguration() throws ConfigurationException {
        this.doExecuteConfiguration(this.myCurrentConfiguration);
    }

    public void insertAndExecuteConfiguration(Configuration conf) throws ConfigurationException {
        this.insertConfiguration(conf);
        this.doExecuteConfiguration(conf);
    }

    public void insertAndExecuteConfiguration(String configurationLocation) throws ConfigurationException {
        this.insertAndExecuteConfiguration(this.parseConfiguration(configurationLocation));
    }

    public void insertAndExecuteConfiguration(URL configurationURL) throws ConfigurationException {
        this.insertAndExecuteConfiguration(this.parseConfiguration(configurationURL));
    }

    public boolean loadModule(String moduleFileName) throws ConfigurationException {
        URL module = PFileUtils.parseToURL(moduleFileName);
        if (module == null) {
            this.myLogger.error("Cannot find a module: " + moduleFileName + ". Please check that the path is correcly spelled.");
            throw new ConfigurationException("Cannot find a module: " + moduleFileName + ". Please check that the path is correcly spelled.");
        }
        return this.loadModule(module);
    }

    public boolean loadModule(URL moduleURL) throws ConfigurationException {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{moduleURL}, null);
            URL resource = loader.getResource("poseidon.xml");
            loader.close();
            if (resource != null && this.isModuleSupported(moduleURL)) {
                this.myLogger.debug("Loading extension configuration file: " + resource);
                this.insertConfiguration(resource);
                Method method = URLClassLoader.class.getDeclaredMethod(ADD_URL_METHOD, URL.class);
                method.setAccessible(true);
                method.invoke((Object)ClassLoader.getSystemClassLoader(), moduleURL);
                return true;
            }
            return false;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            this.myLogger.error("Can't load a extension configuration file: " + moduleURL, e);
            throw new ConfigurationException("Cannot load a extension configuration file: " + moduleURL + ". For more information see log file.");
        }
    }

    public Configuration getCurrentConfiguration() {
        return this.myCurrentConfiguration;
    }

    public void addConfigurationListener(ConfigurationListener listener) {
        this.myLogger.trace("New configuration listener: " + listener);
        this.myConfListeners.add(listener);
    }

    public void removeConfigurationListener(ConfigurationListener listener) {
        this.myLogger.trace("Remove configuration listener: " + listener);
        this.myConfListeners.remove(listener);
    }

    protected void checkConfValidity(Configuration configuration) throws ConfigurationException {
        for (Plugin plugin : configuration.getPlugins()) {
            String field = null;
            String id = null;
            if (plugin.getType() == null || plugin.getType().length() == 0) {
                field = "type";
                id = plugin.getName();
            } else if (plugin.getClassname() == null || plugin.getClassname().length() == 0) {
                field = "className";
                id = plugin.getName();
            } else if (plugin.getName() == null || plugin.getName().length() == 0) {
                field = "name";
                id = plugin.getClassname();
            }
            if (field == null) continue;
            String message = "The " + field + " is missing for the plugin: " + id + ". This information is vital, please define it.";
            this.myLogger.error(message);
            throw new ConfigurationException(message);
        }
    }

    protected Configuration parseConfiguration(String configurationFile) throws ConfigurationException {
        URL configFileURL = PFileUtils.parseToURL(configurationFile);
        if (configFileURL == null) {
            this.myLogger.error("Cannot find a configuration file: " + configurationFile + ". Please check that the path is correcly spelled.");
            throw new ConfigurationException("Cannot find the file: " + configurationFile + ". Please check that the path is correcly spelled.");
        }
        return this.parseConfiguration(configFileURL);
    }

    protected Configuration parseConfiguration(URL configuration) throws ConfigurationException {
        try {
            ObjectLoader loader = new ObjectLoader(Configuration.class.getPackage().getName());
            return (Configuration)loader.loadObject(configuration);
        }
        catch (ObjectLoadException ex) {
            this.myLogger.error("Failed to load the configuration from url: " + configuration, ex);
            throw new ConfigurationException("Failed to load the configuration from url: " + configuration + " for more detailed information, see log file");
        }
    }

    protected synchronized void doExecuteConfiguration(Configuration conf) throws ConfigurationException {
        if (conf == null) {
            throw new IllegalStateException("The confuration must be inserted before it can be executed. Use one of the insertConfiguration methods before calling this method.");
        }
        this.myLogger.trace("Executing the configuration = " + conf);
        PropertyManager.getInstance().checkParams(conf.parseFromProperties());
        for (Plugin plugin : conf.getPlugins()) {
            this.createPlugin(plugin);
        }
        this.fireConfigurationExecuted(conf);
        this.myLogger.trace("Configuration executed");
    }

    private Object createPlugin(Plugin plugin) throws ConfigurationException {
        Object pluginInstance;
        ProbeManager.startProbe("Create plugin");
        this.myLogger.trace("Starting to create plugin: " + plugin);
        PCmdLineParams plugInCmd = plugin.parseFromArgs();
        this.myLogger.trace("Invoking plugin " + plugin.getName() + " from class " + plugin.getClassname() + ", arguments: " + plugInCmd);
        Class registryClass = this.myPluginTypeToRegistry.get(plugin.getType());
        Object bundle = plugin.getBundle();
        Object registry = PoseidonRuntime.getRuntime().getRegistry(registryClass, bundle);
        if (registry == null) {
            this.myLogger.error("Could not find a registry for the plugin type: " + plugin.getType());
            throw new ConfigurationException("Could not find a invoker for the plugin type \"" + plugin.getType() + "\" Please check that the configuration file does not contain errors " + "for the plugins that type.");
        }
        if (((PluginRegistry)registry).contains(plugin.getName())) {
            this.myLogger.error(registry + " already contains plugin with name: " + plugin.getName());
            throw new ConfigurationException("Trying to create a plugin '" + plugin.getName() + "' which already exists. Once a configuration is executed, it is not possible to create plugins " + "with same name. Please give an additional configuration in Poseidon initialization via command " + "line, nested in existing configuration file or using initalization method in PoseidonStarter " + "that takes a configuration as a parameter.");
        }
        try {
            Class<?> clazz = Class.forName(plugin.getClassname());
            pluginInstance = clazz.newInstance();
            ParameterInjector.injectSetParameters(pluginInstance, plugInCmd);
        }
        catch (Exception e) {
            this.myLogger.error("Unable to instantiate the plugin class: " + plugin.getClassname(), e);
            throw new ConfigurationException("Unable to instantiate the plugin class: " + plugin.getClassname() + " Please check that the class name is correctly spelled." + " For more detailed information, see log file.");
        }
        if ("application".equals(plugin.getType())) {
            this.handleAppAddition((ApplicationRegistry)registry, plugin, (Application)pluginInstance);
        } else {
            ((PluginRegistry)registry).add(plugin.getName(), pluginInstance);
        }
        ProbeManager.stopProbe("Create plugin", plugin.getName());
        this.myLogger.trace("Plugin " + plugin.getName() + " created");
        return pluginInstance;
    }

    protected void handleAppAddition(ApplicationRegistry registry, Plugin plugin, Application application) {
        if ("master".equals(plugin.getGrade())) {
            registry.add(plugin.getName(), application, ApplicationGrade.MASTER);
        } else {
            registry.add(plugin.getName(), application, ApplicationGrade.SECONDARY);
        }
    }

    protected void fireConfigurationInserted(Configuration conf) throws ConfigurationException {
        this.myLogger.trace("Configuration inserted: " + conf);
        ConfigurationEvent event = new ConfigurationEvent(this, conf, this.myCurrentConfiguration);
        for (ConfigurationListener listener : this.myConfListeners) {
            listener.configurationInserted(event);
        }
    }

    protected void fireConfigurationExecuted(Configuration conf) throws ConfigurationException {
        this.myLogger.trace("Configuration executed: " + conf);
        ConfigurationEvent event = new ConfigurationEvent(this, conf, this.myCurrentConfiguration);
        for (ConfigurationListener listener : this.myConfListeners) {
            listener.configurationExecuted(event);
        }
    }

    protected boolean isModuleSupported(URL extensionURL) throws ConfigurationException {
        int[] reqVersion;
        int[] posVersion;
        String requiredVersion = null;
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(new File(extensionURL.toURI()));
                requiredVersion = jarFile.getManifest().getMainAttributes().getValue("Required-Poseidon-Version");
            }
            catch (Exception e) {
                this.closeJarFile(jarFile);
                this.closeJarFile(jarFile);
                return true;
            }
        }
        catch (Throwable throwable) {
            this.closeJarFile(jarFile);
            throw throwable;
        }
        this.closeJarFile(jarFile);
        if (requiredVersion == null) {
            return true;
        }
        String poseidonVersion = this.getClass().getPackage().getImplementationVersion();
        if (poseidonVersion == null || poseidonVersion.length() < 1) {
            try {
                InputStream stream = this.getClass().getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
                Manifest mf = new Manifest(stream);
                poseidonVersion = mf.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                IOUtils.closeQuietly(stream);
            }
            catch (Exception e) {
                String msg = "The manifest file containing Poseidon implementation version cannot be read.";
                this.myLogger.error(msg, e);
                throw new ConfigurationException(String.valueOf(msg) + " For more information see log file.");
            }
        }
        if (poseidonVersion == null || poseidonVersion.length() < 1) {
            String msg = "The Poseidon manifest file does not contain implementation version.";
            this.myLogger.error(msg);
            throw new ConfigurationException(msg);
        }
        try {
            posVersion = this.parseVersion(poseidonVersion);
            reqVersion = this.parseVersion(requiredVersion);
        }
        catch (NumberFormatException e) {
            String msg = "The version parsing failed for Poseidon implementation version: " + poseidonVersion + " or extension required Poseidon version: " + requiredVersion + ". Each digit must be integer" + " and have non-negative value.";
            this.myLogger.error(msg, e);
            throw new ConfigurationException(String.valueOf(msg) + " For more detailed description see log file.");
        }
        int len = Math.min(reqVersion.length, posVersion.length);
        int i = 0;
        while (i < len) {
            if (posVersion[i] < reqVersion[i]) {
                String msg = "The extension located in: " + extensionURL + " is not supported by" + " this Poseidon implementation version. The Poseidon version is: " + poseidonVersion + " and the" + " required Poseidon version needed for the extension is: " + requiredVersion;
                this.myLogger.error(msg);
                throw new ConfigurationException(msg);
            }
            if (posVersion[i] > reqVersion[i]) {
                return true;
            }
            ++i;
        }
        return true;
    }

    private void closeJarFile(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                this.myLogger.error("Can't Close JarFile: ", e);
            }
        }
    }

    protected int[] parseVersion(String version) throws NumberFormatException {
        String[] split = version.split("\\.", -1);
        int[] ints = new int[split.length];
        int i = 0;
        while (i < split.length) {
            ints[i] = Integer.parseInt(split[i]);
            if (ints[i] < 0) {
                throw new NumberFormatException("The version cannot be negative");
            }
            ++i;
        }
        return ints;
    }

    protected void resetSingleton() {
        this.myConfListeners.clear();
        this.myCurrentConfiguration = null;
        this.myLogger.trace("ConfigurationManager reset");
    }
}

