/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.plugin.conf;

import com.nokia.em.poseidon.plugin.conf.ConfigurationException;

public class Version
implements Comparable<Version> {
    private String myValue;
    private int[] myValueArray;

    public Version() {
        this.myValue = "";
        this.myValueArray = new int[0];
    }

    public Version(String value) throws ConfigurationException {
        this.setValue(value);
    }

    public void setValue(String value) throws ConfigurationException {
        this.myValue = value;
        try {
            this.myValueArray = this.parseValue(value);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("The value parsing failed for value: " + this.myValue + ". Each digit must be integer and be separated with period (.)");
        }
    }

    public String getValue() {
        return this.myValue;
    }

    public int[] getValueArray() {
        return this.myValueArray;
    }

    protected int[] parseValue(String value) throws NumberFormatException {
        String[] split = value.split("\\.", -1);
        int[] ints = new int[split.length];
        int i = 0;
        while (i < split.length) {
            ints[i] = Integer.parseInt(split[i]);
            ++i;
        }
        return ints;
    }

    public String toString() {
        return "Value: " + this.myValue;
    }

    public int compatibilityWith(Version another) {
        if (another == null) {
            return 0;
        }
        int[] otherValues = another.getValueArray();
        int len = Math.min(otherValues.length, this.myValueArray.length);
        int index = 0;
        while (index < len) {
            int value = this.myValueArray[index] - otherValues[index];
            if (value != 0) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int compareTo(Version another) {
        if (another == null) {
            return 1;
        }
        int[] otherValues = another.getValueArray();
        int len = Math.min(otherValues.length, this.myValueArray.length);
        int i = 0;
        while (i < len) {
            int value = this.myValueArray[i] - otherValues[i];
            if (value != 0) {
                return value;
            }
            ++i;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }
}

