/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.plugin.lifecycle;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.plugin.application.Application;
import com.nokia.em.poseidon.plugin.application.ApplicationRegistry;
import com.nokia.em.poseidon.plugin.application.ApplicationStatus;
import com.nokia.em.poseidon.plugin.conf.Configuration;
import com.nokia.em.poseidon.plugin.conf.ConfigurationEvent;
import com.nokia.em.poseidon.plugin.conf.ConfigurationException;
import com.nokia.em.poseidon.plugin.conf.ConfigurationListener;
import com.nokia.em.poseidon.plugin.conf.Plugin;
import com.nokia.em.poseidon.plugin.lifecycle.CloseListener;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleListener;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleStatus;
import com.nokia.em.poseidon.plugin.operation.Operation;
import com.nokia.em.poseidon.plugin.operation.OperationRegistry;
import com.nokia.em.poseidon.plugin.service.ServiceRegistry;
import com.nokia.em.poseidon.util.debugging.DebugUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LifecycleManager
implements ConfigurationListener {
    private static final int FORCED_SHUTDOWN_TIMEOUT = 60000;
    private static final int THREAD_DUMP_INTERVAL = 5000;
    protected LifecycleStatus myCurrentStatus;
    protected Logger myLogger = Logger.getLogger(this.getClass());
    protected Set<CloseListener> myCloseListeners = new CopyOnWriteArraySet<CloseListener>();
    protected Set<LifecycleListener> myLifeCycleListeners = new CopyOnWriteArraySet<LifecycleListener>();
    protected CloseOperation myCloseOperation;
    protected static LifecycleManager theInstance;

    protected LifecycleManager() {
        this.setLifecycleStatus(LifecycleStatus.NOT_STARTED);
        this.myCloseOperation = CloseOperation.EXIT_AFTER_CLOSE;
        this.myLogger.trace("LifecycleManager initialized.");
    }

    public static synchronized LifecycleManager getInstance() {
        if (theInstance == null) {
            theInstance = new LifecycleManager();
        }
        return theInstance;
    }

    public void setCloseOperation(CloseOperation operation) {
        this.myCloseOperation = operation;
    }

    public void addCloseListener(CloseListener listener) {
        this.myLogger.trace("New Poseidon close listener registered: " + listener.getClass());
        this.myCloseListeners.add(listener);
    }

    public void removeCloseListener(CloseListener listener) {
        this.myLogger.trace("Removing Poseidon close listener: " + listener.getClass());
        this.myCloseListeners.remove(listener);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.myLogger.trace("New Poseidon lifecycle listener registered: " + listener.getClass());
        this.myLifeCycleListeners.add(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.myLogger.trace("Removing Poseidon lifecycle listener: " + listener.getClass());
        this.myLifeCycleListeners.remove(listener);
    }

    public synchronized boolean closeRequest() {
        return this.closeRequest(0);
    }

    public synchronized boolean closeRequest(final int exitValue) {
        this.myLogger.debug("Poseidon close request");
        for (CloseListener listener : this.myCloseListeners) {
            if (listener.isClosePossible()) continue;
            this.myLogger.warn("Close listener: " + listener + " refused to exit");
            return false;
        }
        this.setLifecycleStatus(LifecycleStatus.CLOSING);
        this.closeAllApplications();
        this.closeAllServices();
        this.setLifecycleStatus(LifecycleStatus.CLOSED);
        this.reset();
        if (CloseOperation.EXIT_AFTER_CLOSE.equals((Object)this.myCloseOperation)) {
            TimerTask forcedShutdownTask = new TimerTask(){

                @Override
                public void run() {
                    LifecycleManager.this.myLogger.debug("Execute force shutdown because EDT is hanging somewhere. ExitValue: " + exitValue);
                    Runtime.getRuntime().halt(exitValue);
                }
            };
            Timer shutDownTimer = new Timer();
            shutDownTimer.schedule(forcedShutdownTask, 60000L);
            TimerTask logThreadDumpTask = new TimerTask(){

                @Override
                public void run() {
                    LifecycleManager.this.myLogger.debug(DebugUtils.generateThreadDump());
                }
            };
            shutDownTimer.schedule(logThreadDumpTask, 5000L, 5000L);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LifecycleManager.this.myLogger.debug("Calling system.exit with exit value: " + exitValue);
                    System.exit(exitValue);
                }
            });
        }
        return true;
    }

    public void reset() {
        this.myCloseListeners.clear();
        this.myLifeCycleListeners.clear();
        this.setLifecycleStatus(LifecycleStatus.NOT_STARTED);
        this.myLogger.trace("LifecycleManager reset");
    }

    public void startApplication(String appName) {
        this.updateAppStates(Collections.singletonList(appName), true);
    }

    public void closeApplication(String appName) {
        this.updateAppStates(Collections.singletonList(appName), false);
    }

    public void startApplication(Application app) {
        ApplicationRegistry reg = PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class);
        this.updateAppStates(Collections.singletonList(reg.getItemName(app)), true);
    }

    public void closeApplication(Application app) {
        ApplicationRegistry reg = PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class);
        this.updateAppStates(Collections.singletonList(reg.getItemName(app)), false);
    }

    public void startApplications(List<Application> apps) {
        this.updateAppStates(this.getAppNames(apps), true);
    }

    public void closeApplications(List<Application> apps) {
        this.updateAppStates(this.getAppNames(apps), false);
    }

    public void startAllApplications() {
        ApplicationRegistry reg = PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class);
        this.updateAppStates(reg.getAllItemNames(), true);
    }

    public void closeAllApplications() {
        ApplicationRegistry reg = PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class);
        this.updateAppStates(reg.getAllItemNames(), false);
    }

    public void startAllServices() {
        ServiceRegistry reg = PoseidonRuntime.getRuntime().getRegistry(ServiceRegistry.class);
        this.updateServiceStates(reg.getAllItemNames(), true);
    }

    public void closeAllServices() {
        ServiceRegistry reg = PoseidonRuntime.getRuntime().getRegistry(ServiceRegistry.class);
        this.updateServiceStates(reg.getAllItemNames(), false);
    }

    public LifecycleStatus getCurrentStatus() {
        return this.myCurrentStatus;
    }

    protected synchronized void updateServiceStates(List<String> serviceNames, boolean start) {
        ServiceRegistry reg = PoseidonRuntime.getRuntime().getRegistry(ServiceRegistry.class);
        for (String serviceName : serviceNames) {
            if (start) {
                reg.startService(serviceName);
                continue;
            }
            reg.stopService(serviceName);
        }
    }

    protected synchronized void updateAppStates(List<String> appNames, boolean start) {
        ApplicationRegistry reg = PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class);
        ApplicationStatus[] applicationStatusArray = ApplicationStatus.values();
        int n = applicationStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ApplicationStatus desiredStatus = applicationStatusArray[n2];
            for (String appName : appNames) {
                ApplicationStatus currentStatus = reg.getApplicationStatus(appName);
                if (currentStatus == null) continue;
                if (start) {
                    if (currentStatus.ordinal() >= desiredStatus.ordinal() || desiredStatus.ordinal() > ApplicationStatus.READY.ordinal()) continue;
                    reg.setApplicationStatus(desiredStatus, appName);
                    continue;
                }
                if (currentStatus.ordinal() >= ApplicationStatus.READY.ordinal() && currentStatus.ordinal() < desiredStatus.ordinal()) {
                    reg.setApplicationStatus(desiredStatus, appName);
                }
                if (!ApplicationStatus.SHUTDOWN.equals((Object)desiredStatus)) continue;
                reg.setApplicationStatus(ApplicationStatus.IDLE, appName);
            }
            ++n2;
        }
    }

    protected void setLifecycleStatus(LifecycleStatus status) {
        this.myLogger.debug("Current Poseidon Lifecycle status set: " + (Object)((Object)status));
        this.myCurrentStatus = status;
        for (LifecycleListener listener : this.myLifeCycleListeners) {
            listener.lifecycleUpdated(status);
        }
    }

    protected List<String> getPluginNames(Configuration conf, boolean start, String pluginType) {
        ArrayList<String> returnValues = new ArrayList<String>();
        List<Plugin> plugins = conf.getPlugins();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                if (!pluginType.equals(plugin.getType()) || start != plugin.getStart()) continue;
                returnValues.add(plugin.getName());
            }
        }
        return returnValues;
    }

    protected List<String> getAppNames(List<Application> apps) {
        ApplicationRegistry reg = PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class);
        ArrayList<String> appNames = new ArrayList<String>();
        for (Application app : apps) {
            appNames.add(reg.getItemName(app));
        }
        return appNames;
    }

    @Override
    public void configurationExecuted(ConfigurationEvent event) throws ConfigurationException {
        this.updateServiceStates(this.getPluginNames(event.getConfiguration(), false, "service"), false);
        this.updateServiceStates(this.getPluginNames(event.getConfiguration(), true, "service"), true);
        this.updateAppStates(this.getPluginNames(event.getConfiguration(), false, "application"), false);
        this.updateAppStates(this.getPluginNames(event.getConfiguration(), true, "application"), true);
        for (Plugin operation : event.getConfiguration().getPluginsByType("operation")) {
            if (!operation.getStart()) continue;
            try {
                OperationRegistry reg = PoseidonRuntime.getRuntime().getRegistry(OperationRegistry.class);
                Operation op = (Operation)reg.get(operation.getName());
                if (op == null) continue;
                op.invoke();
            }
            catch (Exception ex) {
                this.myLogger.error("Operation invocation failed because of an exception: ", ex);
                throw new ConfigurationException("Operation invocation failed, please check that Operation: " + operation.getClassname() + " is defined correctly. For more information see log file.");
            }
        }
        if (!LifecycleStatus.RUNNING.equals((Object)this.myCurrentStatus)) {
            this.setLifecycleStatus(LifecycleStatus.RUNNING);
        }
    }

    @Override
    public void configurationInserted(ConfigurationEvent event) {
    }

    public static enum CloseOperation {
        EXIT_AFTER_CLOSE,
        DO_NOTHING_AFTER_CLOSE;

    }
}

