/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.plugin.properties;

import com.nokia.em.poseidon.plugin.conf.ConfigurationException;
import com.nokia.em.poseidon.plugin.properties.ApplicationPropertyHandler;
import com.nokia.em.poseidon.plugin.properties.ConfFilePropertyHandler;
import com.nokia.em.poseidon.plugin.properties.I18nPropertyHandler;
import com.nokia.em.poseidon.plugin.properties.LookAndFeelPropertyHandler;
import com.nokia.em.poseidon.plugin.properties.ModulePropertyHandler;
import com.nokia.em.poseidon.plugin.properties.PropertyHandler;
import com.nokia.em.poseidon.plugin.properties.UIConfPropertyHandler;
import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.PCmdLineParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyManager {
    public static PropertyManager theInstance;
    private Map<String, PropertyHandler> myPropertyHandlers = new HashMap<String, PropertyHandler>();
    private Map<String, List<String>> myHandledProperties = new HashMap<String, List<String>>();

    protected PropertyManager() {
        this.myPropertyHandlers.put("conffile", new ConfFilePropertyHandler());
        if (!GeneralUtils.isHeadlessMode()) {
            this.myPropertyHandlers.put("lookandfeel", new LookAndFeelPropertyHandler());
        }
        this.myPropertyHandlers.put("i18n", new I18nPropertyHandler());
        this.myPropertyHandlers.put("application", new ApplicationPropertyHandler());
        this.myPropertyHandlers.put("module", new ModulePropertyHandler());
        this.myPropertyHandlers.put("uiconf", new UIConfPropertyHandler());
    }

    public static synchronized PropertyManager getInstance() {
        if (theInstance == null) {
            theInstance = new PropertyManager();
        }
        return theInstance;
    }

    public void checkParams(PCmdLineParams params) throws ConfigurationException {
        for (String paramName : params.getAllNames()) {
            if (!this.myPropertyHandlers.containsKey(paramName)) continue;
            List<String> values = params.getValues(paramName);
            if (this.myHandledProperties.containsKey(paramName) && (values == null || values.equals(this.myHandledProperties.get(paramName)))) continue;
            ArrayList<String> onlyNewOnes = new ArrayList<String>(values);
            List<String> handledValues = this.myHandledProperties.get(paramName);
            if (handledValues != null) {
                onlyNewOnes.removeAll(handledValues);
            }
            if (onlyNewOnes.isEmpty()) continue;
            this.myPropertyHandlers.get(paramName).invoke(onlyNewOnes);
            this.myHandledProperties.put(paramName, values);
        }
    }

    protected void resetSingleton() {
        this.myHandledProperties.clear();
    }
}

