/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.plugin.properties;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.plugin.conf.ConfigurationException;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleListener;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleManager;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleStatus;
import com.nokia.em.poseidon.plugin.properties.PropertyHandler;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class UIConfPropertyHandler
implements PropertyHandler,
LifecycleListener {
    private List<String> myUIConfs = new ArrayList<String>();

    protected void handleConfs() {
        Logger logger = Logger.getLogger(this.getClass());
        for (String conf : this.myUIConfs) {
            logger.trace("Loading UI Configuration file: " + conf);
            final URL url = PFileUtils.parseToURL(conf);
            if (url != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PoseidonRuntime.getRuntime().getService(UserInterface.class).loadUIConfiguration(url);
                    }
                });
                continue;
            }
            throw new IllegalArgumentException("The UI Configuration: " + conf + " cannot be resolved to URL.");
        }
        this.myUIConfs.clear();
    }

    @Override
    public void invoke(List<String> values) throws ConfigurationException {
        this.myUIConfs.addAll(values);
        if (LifecycleStatus.RUNNING.equals((Object)LifecycleManager.getInstance().getCurrentStatus())) {
            this.handleConfs();
        } else if (LifecycleStatus.NOT_STARTED.equals((Object)LifecycleManager.getInstance().getCurrentStatus())) {
            LifecycleManager.getInstance().addLifecycleListener(this);
        }
    }

    @Override
    public void lifecycleUpdated(LifecycleStatus status) {
        if (LifecycleStatus.RUNNING.equals((Object)status)) {
            this.handleConfs();
            LifecycleManager.getInstance().removeLifecycleListener(this);
        }
    }
}

