/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.plugin.properties;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.plugin.conf.ConfigurationException;
import com.nokia.em.poseidon.plugin.properties.PropertyHandler;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;

public class UserHomePropertyHandler
implements PropertyHandler {
    @Override
    public void invoke(List<String> values) throws ConfigurationException {
        try {
            PoseidonRuntime obj = PoseidonRuntime.getRuntime();
            String userHomePath = this.createUserHomePath(values.get(values.size() - 1));
            Method method = obj.getClass().getDeclaredMethod("setUserHome", userHomePath.getClass());
            method.setAccessible(true);
            method.invoke((Object)obj, userHomePath);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error("Can not set User Home parameter \"" + values.get(values.size() - 1) + "\"", e);
            throw new ConfigurationException("Can not set User Home parameter \"" + values.get(values.size() - 1) + "\"" + " For more detailed information, see log file.");
        }
    }

    private String createUserHomePath(String path) {
        if (path == null || path.length() < 1) {
            return null;
        }
        String defaultHome = null;
        try {
            defaultHome = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        }
        catch (Exception exc) {
            Logger.getLogger(this.getClass()).error("Failed to set myUserHomeDirectory, using backup value", exc);
            defaultHome = System.getProperty("user.home");
        }
        String userHomePath = null;
        File file = new File(path);
        if (!file.exists()) {
            userHomePath = String.valueOf(defaultHome) + File.separator + path;
            file = new File(userHomePath);
            if (!file.exists() && !file.mkdir()) {
                userHomePath = defaultHome;
            }
        } else {
            userHomePath = path;
        }
        return userHomePath;
    }
}

