/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.plugin.registry;

import com.nokia.em.poseidon.util.PCmdLineParams;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class ParameterInjector {
    protected static final String SETTER_PREFIX = "set";

    public static void injectSetParameters(Object object, PCmdLineParams params) {
        if (params != null && object != null) {
            for (String param : params.getAllNames()) {
                String setMethodName = SETTER_PREFIX + param;
                Method[] methodArray = object.getClass().getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    Class<?>[] paramTypes = method.getParameterTypes();
                    if (method.getName().equalsIgnoreCase(setMethodName) && paramTypes.length == 1 && method.getReturnType() == Void.TYPE) {
                        for (String value : params.getValues(param)) {
                            try {
                                method.invoke(object, ParameterInjector.convertStringToObject(paramTypes[0], value));
                            }
                            catch (Exception e) {
                                Logger.getLogger(ParameterInjector.class).error("Failed to inject parameter, name: " + param + " value: " + params.getFirstValue(param) + " to " + object, e);
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private static Object convertStringToObject(Class<?> classType, String value) {
        Object retVal = null;
        if (classType.isAssignableFrom(Integer.TYPE)) {
            retVal = Integer.valueOf(value);
        } else if (classType.isAssignableFrom(Float.TYPE)) {
            retVal = Float.valueOf(value);
        } else if (classType.isAssignableFrom(Boolean.TYPE)) {
            retVal = Boolean.valueOf(value);
        } else if (classType.isAssignableFrom(String.class)) {
            retVal = value;
        }
        return retVal;
    }
}

