/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.plugin.registry;

import com.nokia.em.poseidon.plugin.registry.PluginRegistryEvent;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public class PluginRegistry<E> {
    private static Object DEFAULT_BUNDLE_ID = new Object();
    protected Map<String, E> myInvokedItems;
    protected Set<PluginRegistryListener> myRegistryListeners;
    protected Logger myLogger;
    protected Map<String, Object> myItemNameToStatus;
    protected Object myBundleId = DEFAULT_BUNDLE_ID;

    protected PluginRegistry() {
        this(DEFAULT_BUNDLE_ID);
    }

    protected PluginRegistry(Object bundleId) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myInvokedItems = new LinkedHashMap<String, E>();
        this.myRegistryListeners = new CopyOnWriteArraySet<PluginRegistryListener>();
        this.myItemNameToStatus = new HashMap<String, Object>();
        this.myBundleId = bundleId;
    }

    public void close() {
        this.removeAll();
        this.myInvokedItems.clear();
        this.myRegistryListeners.clear();
        this.myItemNameToStatus.clear();
    }

    public synchronized void add(String name, E item) {
        this.myLogger.trace("Adding " + name + " (" + item.getClass() + ") to registry");
        this.myInvokedItems.put(name, item);
        this.fireItemAdded(item);
    }

    public String add(E item) {
        String keyCandidate;
        while (this.myInvokedItems.containsKey(keyCandidate = String.valueOf(System.currentTimeMillis()))) {
        }
        this.add(keyCandidate, item);
        return keyCandidate;
    }

    public <T> List<T> getAll() {
        return new ArrayList<E>(this.myInvokedItems.values());
    }

    public synchronized <T> List<T> getAll(Class<T> clazz) {
        ArrayList<E> returnItems = new ArrayList<E>();
        Collection<E> items = this.myInvokedItems.values();
        for (E item : items) {
            if (!clazz.isInstance(item)) continue;
            returnItems.add(item);
        }
        return returnItems;
    }

    public synchronized void removeAll() {
        this.myLogger.debug("Removing all items from the registry");
        for (E item : new ArrayList<E>(this.myInvokedItems.values())) {
            this.remove(item);
        }
    }

    public <T> T get(String name) {
        return (T)this.myInvokedItems.get(name);
    }

    public synchronized <T> T get(Class<T> clazz) {
        for (E item : this.myInvokedItems.values()) {
            if (!clazz.isInstance(item)) continue;
            return (T)item;
        }
        this.myLogger.warn("Item for class" + clazz.getName() + " requested but not found");
        return null;
    }

    public synchronized void remove(E item) {
        this.myLogger.trace("Removing " + item + " from registry...");
        for (Map.Entry<String, E> entry : this.myInvokedItems.entrySet()) {
            if (!entry.getValue().equals(item)) continue;
            this.myLogger.trace(String.valueOf(entry.getKey()) + " removed from registry");
            this.myInvokedItems.remove(entry.getKey());
            this.myItemNameToStatus.remove(entry.getKey());
            this.fireItemRemoved(entry.getValue());
            return;
        }
    }

    public void remove(String name) {
        Object item = this.get(name);
        if (item != null) {
            this.remove(item);
        }
    }

    public boolean contains(String name) {
        return this.myInvokedItems.containsKey(name);
    }

    public synchronized boolean contains(Class<E> clazz) {
        for (E item : this.myInvokedItems.values()) {
            if (!clazz.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.myInvokedItems.size();
    }

    public synchronized String getItemName(E item) {
        for (Map.Entry<String, E> entry : this.myInvokedItems.entrySet()) {
            if (!entry.getValue().equals(item)) continue;
            return entry.getKey();
        }
        return null;
    }

    public synchronized List<String> getAllItemNames() {
        return new ArrayList<String>(this.myInvokedItems.keySet());
    }

    public Object getBundleId() {
        return this.myBundleId;
    }

    public boolean isDefault() {
        return this.myBundleId == DEFAULT_BUNDLE_ID;
    }

    public synchronized void addRegistryListener(PluginRegistryListener listener) {
        this.myRegistryListeners.add(listener);
    }

    public synchronized void removeRegistryListener(PluginRegistryListener listener) {
        this.myRegistryListeners.remove(listener);
    }

    protected synchronized void fireItemAdded(Object item) {
        PluginRegistryEvent event = new PluginRegistryEvent(this, item);
        for (PluginRegistryListener listener : this.myRegistryListeners) {
            listener.itemAdded(event);
        }
    }

    protected synchronized void fireItemRemoved(Object item) {
        PluginRegistryEvent event = new PluginRegistryEvent(this, item);
        for (PluginRegistryListener listener : this.myRegistryListeners) {
            listener.itemRemoved(event);
        }
    }
}

