/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.plugin.service;

import com.nokia.em.poseidon.plugin.registry.PluginRegistry;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.util.probe.Probe;
import com.nokia.em.poseidon.util.probe.ProbeManager;
import java.util.List;

public class ServiceRegistry
extends PluginRegistry<Service> {
    public ServiceRegistry() {
        ProbeManager.addProbe(Probe.Type.MULTIPLE_EXECUTION, "Service Startup", "Service Startup Times");
    }

    public ServiceRegistry(Object bundleId) {
        super(bundleId);
        ProbeManager.addProbe(Probe.Type.MULTIPLE_EXECUTION, "Service Startup", "Service Startup Times");
    }

    @Override
    public synchronized void add(String name, Service service) {
        this.myItemNameToStatus.put(name, STATUS.IDLE);
        super.add(name, service);
    }

    @Override
    public <T> T get(String name) {
        Object service = super.get(name);
        this.startService((Service)service);
        return service;
    }

    @Override
    public <T> T get(Class<T> clazz) {
        T service = super.get(clazz);
        this.startService((Service)service);
        return service;
    }

    @Override
    public <T> List<T> getAll() {
        List services = super.getAll();
        for (Object service : services) {
            this.startService((Service)service);
        }
        return services;
    }

    @Override
    public <T> List<T> getAll(Class<T> clazz) {
        List<T> services = super.getAll(clazz);
        for (T service : services) {
            this.startService((Service)service);
        }
        return services;
    }

    public <T> List<T> listAll() {
        return super.getAll();
    }

    public <T> List<T> listAll(Class<T> clazz) {
        return super.getAll(clazz);
    }

    @Override
    public synchronized void remove(Service item) {
        this.stopService(item);
        super.remove(item);
    }

    public boolean isStarted(Service service) {
        String name = this.getItemName(service);
        if (name != null) {
            return this.isStarted(name);
        }
        return false;
    }

    public boolean isStarted(String servicename) {
        return STATUS.STARTED.equals(this.myItemNameToStatus.get(servicename));
    }

    public void startService(String serviceName) {
        this.startService((Service)super.get(serviceName));
    }

    public void startService(Service service) {
        this.setServiceStatus(service, STATUS.STARTED);
    }

    public void stopService(String serviceName) {
        this.stopService((Service)super.get(serviceName));
    }

    public void stopService(Service service) {
        this.setServiceStatus(service, STATUS.IDLE);
    }

    private void setServiceStatus(Service service, STATUS desiredStatus) {
        String serviceName;
        Object serviceStatus;
        if (service != null && !desiredStatus.equals(serviceStatus = this.myItemNameToStatus.get(serviceName = this.getItemName(service)))) {
            this.myLogger.debug("Setting service status: " + (Object)((Object)desiredStatus) + " Service: " + service);
            switch (desiredStatus) {
                case IDLE: {
                    service.stop();
                    break;
                }
                case STARTED: {
                    if (STATUS.STARTING.equals(serviceStatus)) {
                        throw new RuntimeException("Cyclic reference. The service: " + service.getClass().getName() + " is starting, it has a reference to another" + " object in its start() -method, this object in turn has a reference to " + service.getClass().getName() + " Please remove this illegal cyclic reference.");
                    }
                    this.myItemNameToStatus.put(serviceName, STATUS.STARTING);
                    service.start();
                    break;
                }
            }
            this.myItemNameToStatus.put(serviceName, desiredStatus);
        }
    }

    private static enum STATUS {
        STARTING,
        STARTED,
        IDLE;

    }
}

