/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.alarms;

import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import com.nokia.em.poseidon.frameworks.alarm.PAlarmModel;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.alarms.PAlarmBroadcastListener;
import com.nokia.em.poseidon.services.alarms.PAlarmChangeListener;
import com.nokia.em.poseidon.services.alarms.PAlarmService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class PAlarmServiceImpl
implements PAlarmService,
Service {
    private static int TRANSIENT_INTERVAL = 15000;
    private Logger myLogger;
    private PAlarmModel myModel;
    private Set<PAlarmBroadcastListener> myAlarmBroadcastListeners;
    private Set<PAlarmChangeListener> myAlarmChangeListeners;

    @Override
    public synchronized void raiseAlarm(PAlarmEntry alarm) {
        this.myModel.raiseAlarm(alarm);
        for (PAlarmChangeListener listener : this.myAlarmChangeListeners) {
            listener.alarmReceived(alarm);
        }
        if (alarm.isAlarmTransient()) {
            this.handleTransient(alarm);
        }
    }

    @Override
    public synchronized void raiseAlarms(List<PAlarmEntry> alarms) {
        this.myModel.raiseAlarms(alarms);
        for (PAlarmEntry alarm : alarms) {
            if (!alarm.isAlarmTransient()) continue;
            this.handleTransient(alarm);
        }
        for (PAlarmChangeListener listener : this.myAlarmChangeListeners) {
            listener.alarmsReceived(alarms);
        }
    }

    @Override
    public synchronized void clearAlarm(PAlarmEntry alarm) {
        this.myModel.clearAlarm(alarm);
        for (PAlarmChangeListener listener : this.myAlarmChangeListeners) {
            listener.alarmCleared(alarm);
        }
    }

    @Override
    public synchronized void clearAlarms(List<PAlarmEntry> alarms) {
        this.myModel.clearAlarms(alarms);
        for (PAlarmChangeListener listener : this.myAlarmChangeListeners) {
            listener.alarmsCleared(alarms);
        }
    }

    @Override
    public void clearAlarms(Object application) {
        List<PAlarmEntry> clearedAlarms = this.myModel.clearAlarms(application, null);
        if (clearedAlarms != null) {
            for (PAlarmChangeListener listener : this.myAlarmChangeListeners) {
                listener.alarmsCleared(clearedAlarms);
            }
        }
    }

    @Override
    public void clearAlarms(Object application, String source) {
        List<PAlarmEntry> clearedAlarms = this.myModel.clearAlarms(application, source);
        if (clearedAlarms != null) {
            for (PAlarmChangeListener listener : this.myAlarmChangeListeners) {
                listener.alarmsCleared(clearedAlarms);
            }
        }
    }

    @Override
    public void removeAlarm(PAlarmEntry alarm) {
        this.myModel.removeAlarm(alarm);
        if (alarm != null) {
            for (PAlarmChangeListener listener : this.myAlarmChangeListeners) {
                listener.alarmRemoved(alarm);
            }
        }
    }

    @Override
    public void removeAlarms(Object application) {
        List<PAlarmEntry> removedAlarms = this.myModel.removeAlarms(application, null);
        if (removedAlarms != null) {
            for (PAlarmChangeListener listener : this.myAlarmChangeListeners) {
                listener.alarmsRemoved(removedAlarms);
            }
        }
    }

    @Override
    public void removeAlarms(Object application, String source) {
        List<PAlarmEntry> removedAlarms = this.myModel.removeAlarms(application, source);
        if (removedAlarms != null) {
            for (PAlarmChangeListener listener : this.myAlarmChangeListeners) {
                listener.alarmsRemoved(removedAlarms);
            }
        }
    }

    @Override
    public void addAlarmBroadcastListener(PAlarmBroadcastListener listener) {
        if (listener != null) {
            this.myAlarmBroadcastListeners.add(listener);
        }
    }

    @Override
    public void removeAlarmBroadcastListener(PAlarmBroadcastListener listener) {
        if (listener != null) {
            this.myAlarmBroadcastListeners.remove(listener);
        }
    }

    @Override
    public void broadcastAlarm(Object alarm) {
        for (PAlarmBroadcastListener listener : this.myAlarmBroadcastListeners) {
            listener.alarmReceived(alarm);
        }
    }

    @Override
    public void broadcastAlarms(List<PAlarmEntry> alarms) {
        for (PAlarmBroadcastListener listener : this.myAlarmBroadcastListeners) {
            listener.alarmsReceived(alarms);
        }
    }

    @Override
    public List<PAlarmEntry> getAllActiveAlarms() {
        return this.myModel.getAllActiveAlarms();
    }

    @Override
    public void addAlarmChangeListener(PAlarmChangeListener listener) {
        if (listener != null) {
            this.myAlarmChangeListeners.add(listener);
        }
    }

    @Override
    public void removeAlarmChangeListener(PAlarmChangeListener listener) {
        if (listener != null) {
            this.myAlarmChangeListeners.remove(listener);
        }
    }

    @Override
    public List<PAlarmEntry> getAllAlarms() {
        return this.myModel.getUnfilteredAlarms();
    }

    @Override
    public PAlarmEntry getAlarmInstance(PAlarmEntry alarm) {
        return this.myModel.getAlarmInstance(alarm);
    }

    @Override
    public void start() {
        this.myAlarmBroadcastListeners = Collections.synchronizedSet(new HashSet());
        this.myAlarmChangeListeners = Collections.synchronizedSet(new HashSet());
        this.myModel = new PAlarmModel();
        this.myLogger = Logger.getLogger(this.getClass());
        this.myLogger.debug("Alarm Service up and running");
    }

    @Override
    public void stop() {
        this.myAlarmBroadcastListeners.clear();
        this.myAlarmChangeListeners.clear();
    }

    private void handleTransient(PAlarmEntry alarm) {
        Timer timer = new Timer(TRANSIENT_INTERVAL, new TransientClearer(alarm));
        timer.setRepeats(false);
        timer.start();
        if (alarm.getClearTime() == null) {
            alarm.setClearTime(alarm.getTime());
            alarm.setClearTimingSource(alarm.getTimingSource());
        }
    }

    private class TransientClearer
    implements ActionListener {
        PAlarmEntry myAlarm;

        public TransientClearer(PAlarmEntry alarm) {
            this.myAlarm = alarm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PAlarmServiceImpl.this.clearAlarm(this.myAlarm);
        }
    }
}

