/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.alarmsview;

import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import com.nokia.em.poseidon.frameworks.alarm.PAlarmUtils;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.widgets.text.TimeZoneFormatter;
import java.util.ArrayList;
import java.util.List;

public final class AlarmTextFormatter {
    private static ResourceBundle myResourceBundle = I18n.getI18n().getBundle(AlarmTextFormatter.class);

    private AlarmTextFormatter() {
    }

    public static void setResourceBundle(ResourceBundle bundle) {
        myResourceBundle = bundle;
    }

    public static String formatAlarmState(PAlarmEntry alarm) {
        String status = alarm.isAlarmTransient() ? myResourceBundle.getString("PAlarmView.Transient_Text") : (alarm.isActive() ? myResourceBundle.getString("Common.Active_Text") : myResourceBundle.getString("PDefaultAlarmFileWriter.Cleared_Text"));
        return status;
    }

    public static String formatAlarmTimeStamp(PAlarmEntry alarm) {
        String alarmTimeStamp = PAlarmUtils.getTimeStamp(alarm.getTime());
        if (!"".equals(alarmTimeStamp)) {
            alarmTimeStamp = String.valueOf(alarmTimeStamp) + " " + TimeZoneFormatter.formatGMTText(alarm.getTime());
            if (alarm.getTimingSource() == 1) {
                alarmTimeStamp = String.valueOf(alarmTimeStamp) + " " + myResourceBundle.getString("PAlarmView.TimeStamp_PcTime_Text");
            }
        }
        return alarmTimeStamp;
    }

    public static String formatAlarmClearTime(PAlarmEntry alarm) {
        String alarmClearTime = PAlarmUtils.getTimeStamp(alarm.getClearTime());
        if (!"".equals(alarmClearTime)) {
            alarmClearTime = String.valueOf(alarmClearTime) + PAlarmUtils.getTimezoneText(alarm.getClearTime().getTimeZone());
            if (alarm.getClearTimingSource() == 1) {
                alarmClearTime = String.valueOf(alarmClearTime) + " " + myResourceBundle.getString("PAlarmView.TimeStamp_PcTime_Text");
            }
        }
        return alarmClearTime;
    }

    public static String formatAlarmReportSubHeader(List<PAlarmEntry> alarms) {
        ArrayList<String> severityList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (PAlarmEntry alarm : alarms) {
            String severity = alarm.serverityToString();
            if (severityList.contains(severity)) continue;
            severityList.add(severity);
            sb.append(separator);
            separator = "/";
            sb.append(severity);
        }
        return sb.toString();
    }
}

