/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.alarmsview;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import com.nokia.em.poseidon.frameworks.alarm.PAlarmUtils;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.mvc.ControllerBase;
import com.nokia.em.poseidon.gui.print.PrintDialogFactory;
import com.nokia.em.poseidon.plugin.application.ApplicationGrade;
import com.nokia.em.poseidon.plugin.application.ApplicationRegistry;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryEvent;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryListener;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.alarms.PAlarmService;
import com.nokia.em.poseidon.services.alarmsview.PAlarmDetailsController;
import com.nokia.em.poseidon.services.alarmsview.PAlarmDetailsView;
import com.nokia.em.poseidon.services.alarmsview.PAlarmFilter;
import com.nokia.em.poseidon.services.alarmsview.PAlarmGuiListener;
import com.nokia.em.poseidon.services.alarmsview.PAlarmView;
import com.nokia.em.poseidon.services.alarmsview.PAlarmViewService;
import com.nokia.em.poseidon.services.alarmsview.PDefaultAlarmFileWriter;
import com.nokia.em.poseidon.services.alarmsview.PDefaultAlarmPrinter;
import com.nokia.em.poseidon.services.alarmsview.PFilteringCriteria;
import com.nokia.em.poseidon.services.conninfo.BasicConnectionFilter;
import com.nokia.em.poseidon.services.conninfo.ConnectionEvent;
import com.nokia.em.poseidon.services.conninfo.ConnectionInfo;
import com.nokia.em.poseidon.services.conninfo.ConnectionStatus;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.widgets.text.TimestampFormatter;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class PAlarmController
extends ControllerBase
implements PAlarmViewService,
Service,
PluginRegistryListener {
    private static final String ALARM_COMPONENT = "ALARM_COMPONENT";
    private ResourceBundle myResourceBundle;
    private Logger myLogger;
    private PSettings mySettings;
    private PAlarmService myAlarmService;
    private ConnectionInfo myConnectionInfo;
    private PAlarmFilter myAlarmFilter;
    private PAlarmView myAlarmView;
    private PAlarmDetailsController myDetailsControl;
    private Set<PAlarmGuiListener> myGuiListeners;
    private String myAppSetSavingPath;
    private String mySiteName;

    public PSettings getSettings() {
        return this.mySettings;
    }

    protected void filteringChangedNotify(PFilteringCriteria criteria) {
        PFilteringCriteria originalCriteria = this.myAlarmFilter.getFilteringCriteria();
        this.myAlarmView.refreshView(this.myAlarmFilter.getAlarms(criteria));
        if (originalCriteria.myFilterClearedAlarms != criteria.myFilterClearedAlarms) {
            this.showAlarmHistory(!criteria.myFilterClearedAlarms);
        }
        this.filteringCriteriaChanged(criteria);
    }

    protected String getDefaultSavingPath() {
        return this.myAppSetSavingPath;
    }

    protected void showAlarmHistory(boolean show) {
        for (PAlarmGuiListener listener : this.myGuiListeners) {
            listener.showAlarmHistory(show);
        }
    }

    protected void filteringCriteriaChanged(PFilteringCriteria criteria) {
        for (PAlarmGuiListener listener : this.myGuiListeners) {
            listener.filteringCriteriaChangedNofity(criteria);
        }
    }

    protected void saveAlarms(File file) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
        }
        catch (Exception ex) {
            this.myLogger.error(ex);
            return;
        }
        String siteName = this.getDefaultSiteName();
        List<PAlarmEntry> alarms = this.myAlarmView.getSortedDisplayedAlarms();
        PDefaultAlarmFileWriter alarmWriter = PDefaultAlarmFileWriter.getInstance();
        alarmWriter.saveAlarmsRequest(outputStream, alarms, siteName, this.myAlarmView.getFilteringCriteria(), alarms.isEmpty());
    }

    protected void focusLostNotify(PAlarmEntry alarm) {
        for (PAlarmGuiListener listener : this.myGuiListeners) {
            if (listener instanceof PAlarmDetailsController) continue;
            listener.alarmDeselectedNotify(alarm);
        }
    }

    protected void alarmSourceRequest(PAlarmEntry alarm) {
        if (alarm != null) {
            for (PAlarmGuiListener listener : this.myGuiListeners) {
                listener.switchAndHighlightSource(alarm);
            }
        }
        this.myAlarmView.requestFocusIntoAlarmTable();
    }

    protected void alarmSelectionNotify(PAlarmEntry alarm) {
        for (PAlarmGuiListener listener : this.myGuiListeners) {
            listener.alarmSelectedNotify(alarm);
        }
        alarm.put("Selected", true);
        PAlarmDetailsView detailsView = this.myDetailsControl.getDetailsView();
        this.myAlarmView.setDetailsView(detailsView);
    }

    protected void alarmDeselectionNotify(PAlarmEntry alarm) {
        for (PAlarmGuiListener listener : this.myGuiListeners) {
            listener.alarmDeselectedNotify(alarm);
        }
        alarm.put("Selected", false);
        PAlarmDetailsView detailsView = this.myDetailsControl.getDetailsView();
        this.myAlarmView.setDetailsView(detailsView);
    }

    protected void alarmHelpRequested(PAlarmEntry alarm) {
        if (alarm != null && alarm.getHelpId() != null) {
            PoseidonRuntime.getRuntime().getService(PHelp.class).showHelp(alarm.getHelpId());
        } else {
            PoseidonRuntime.getRuntime().getService(PHelp.class).showHelp(this.myResourceBundle.getString("PAlarmView.ViewContextSensitiveHelp_Text"));
        }
    }

    protected PAlarmDetailsController getDetailsViewController() {
        return this.myDetailsControl;
    }

    protected void initFilteringCriteria(PFilteringCriteria criteria) {
        this.myAlarmFilter.setFilteringCriteria(criteria);
    }

    protected String getDefaultSiteName() {
        if (this.mySiteName != null) {
            return this.mySiteName;
        }
        if (this.myConnectionInfo == null) {
            return "";
        }
        ConnectionEvent connEvent = this.myConnectionInfo.getLatestConnectionEvent(new BasicConnectionFilter(ConnectionStatus.CONNECTED));
        if (connEvent != null) {
            return connEvent.getNetworkElementName();
        }
        return "";
    }

    protected List<PAlarmEntry> getAllActiveAlarms() {
        return this.myAlarmService.getAllActiveAlarms();
    }

    protected List<PAlarmEntry> getAllAlarms() {
        return this.myAlarmService.getAllAlarms();
    }

    @Override
    public void setDateFormat(DateFormat dateFormat) {
        PAlarmUtils.setDateFormat(dateFormat);
        this.myAlarmView.updateDateFormat();
    }

    @Override
    public void addComponentToHeader(JComponent component) {
        this.myAlarmView.addCustomComponentToHeader(component);
    }

    @Override
    public void removeComponentFromHeader(JComponent component) {
        this.myAlarmView.removeCustomComponentFromHeader(component);
    }

    @Override
    public void removeComponentsFromHeader() {
        this.myAlarmView.removeAllCustomComponentFromHeader();
    }

    @Override
    public void setShowSourceEnabled(boolean enable) {
        this.myDetailsControl.enableShowSourceButton(enable);
    }

    @Override
    public void setShowSourceVisible(boolean show) {
        this.myDetailsControl.showSourceButton(show);
    }

    @Override
    public void setDefaultSavingPath(String path) {
        this.myAppSetSavingPath = path;
    }

    @Override
    public void enableAlarmView(boolean enable) {
        this.myAlarmView.enableActions(enable);
    }

    @Override
    public PAlarmView getAlarmView() {
        return this.myAlarmView;
    }

    @Override
    public void setDetailsView(Object application, PAlarmDetailsView detailsView) {
        this.myDetailsControl.setDetailsView(application, detailsView);
        this.myAlarmView.setDetailsView(this.myDetailsControl.getDetailsView());
    }

    @Override
    public PAlarmDetailsView getDetailsView() {
        return this.myDetailsControl.getDetailsView();
    }

    @Override
    public void addAlarmListener(PAlarmGuiListener listener) {
        if (listener != null) {
            this.myGuiListeners.add(listener);
        }
    }

    @Override
    public void removeAlarmListener(PAlarmGuiListener listener) {
        if (listener != null) {
            this.myGuiListeners.remove(listener);
        }
    }

    @Override
    public DateFormat getAlarmDateFormat() {
        return PAlarmUtils.getDateFormat();
    }

    @Override
    public void showCriticalAlarms(boolean show) {
        this.myAlarmView.showCriticalAlarms(show);
    }

    @Override
    public void showMajorAlarms(boolean show) {
        this.myAlarmView.showMajorAlarms(show);
    }

    @Override
    public void showMinorAlarms(boolean show) {
        this.myAlarmView.showMinorAlarms(show);
    }

    @Override
    public void showWarnings(boolean show) {
        this.myAlarmView.showWarnings(show);
    }

    @Override
    public void showHistory(boolean show) {
        this.myAlarmView.showClearedAlarms(show);
    }

    @Override
    public void saveAlarms() {
        this.myAlarmView.saveAlarms();
    }

    @Override
    public void printAlarms() {
        List<PAlarmEntry> alarms = this.myAlarmView.getSortedDisplayedAlarms();
        String siteName = this.getDefaultSiteName();
        PDefaultAlarmPrinter myPrinter = new PDefaultAlarmPrinter(alarms, siteName, this.myAlarmView.getFilteringCriteria(), alarms.isEmpty());
        myPrinter.doPrinting();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("orientation", "landscape");
        PrintDialogFactory.showPrintdialog(myPrinter, this.myResourceBundle.getString("PAlarmView.PrintDialogTitle_Text"), ALARM_COMPONENT, properties);
    }

    @Override
    public PFilteringCriteria getFilteringCriteria() {
        return this.myAlarmView.getFilteringCriteria();
    }

    @Override
    public void clearAlarmSelection() {
        this.myAlarmView.clearAlarmSelection();
    }

    @Override
    public void setSiteName(String siteName) {
        this.mySiteName = siteName;
    }

    @Override
    public void setViewIcon(Icon icon) {
        this.myAlarmView.setAlarmViewIcon(icon);
    }

    @Override
    public void alarmReceived(PAlarmEntry alarm) {
        this.myAlarmFilter.addAlarm(alarm);
        if (!this.myAlarmFilter.checkEntryFiltering(alarm)) {
            this.myAlarmView.refreshView(this.myAlarmFilter.getAlarms());
        } else {
            this.myAlarmView.updateActiveAlarmsText();
            this.myAlarmView.updateHiddenAlarmsText(this.myAlarmFilter.getAlarms().size());
        }
        this.myAlarmView.showNewAlarmNotification();
    }

    @Override
    public void alarmCleared(PAlarmEntry alarm) {
        this.myAlarmFilter.setAlarms(this.myAlarmService.getAllAlarms());
        this.myAlarmView.refreshView(this.myAlarmFilter.getAlarms());
    }

    @Override
    public void alarmRemoved(PAlarmEntry alarm) {
        this.myAlarmFilter.setAlarms(this.myAlarmService.getAllAlarms());
        this.myAlarmView.refreshView(this.myAlarmFilter.getAlarms());
    }

    @Override
    public void alarmsReceived(List<PAlarmEntry> alarms) {
        this.myAlarmFilter.addAlarms(alarms);
        if (this.myAlarmFilter.checkAlarmsShowing(alarms)) {
            this.myAlarmView.refreshView(this.myAlarmFilter.getAlarms());
        } else {
            this.myAlarmView.updateActiveAlarmsText();
            this.myAlarmView.updateHiddenAlarmsText(this.myAlarmFilter.getAlarms().size());
        }
        if (alarms != null && alarms.size() > 0) {
            this.myAlarmView.showNewAlarmNotification();
        }
    }

    @Override
    public void alarmsCleared(List<PAlarmEntry> alarms) {
        this.myAlarmFilter.setAlarms(this.myAlarmService.getAllAlarms());
        this.myAlarmView.refreshView(this.myAlarmFilter.getAlarms());
    }

    @Override
    public void alarmsRemoved(List<PAlarmEntry> alarms) {
        this.myAlarmFilter.setAlarms(this.myAlarmService.getAllAlarms());
        this.myAlarmView.refreshView(this.myAlarmFilter.getAlarms());
    }

    @Override
    public void start() {
        if (GeneralUtils.isHeadlessMode()) {
            return;
        }
        this.myGuiListeners = Collections.synchronizedSet(new HashSet());
        this.myAlarmFilter = new PAlarmFilter();
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.mySettings = PSettings.getInstance();
        this.myLogger = Logger.getLogger(this.getClass());
        PAlarmUtils.setDateFormat(TimestampFormatter.getLongFormatter());
        this.myDetailsControl = new PAlarmDetailsController(this);
        this.myAlarmView = new PAlarmView(this);
        PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class).addRegistryListener(this);
        this.myLogger.debug("Alarm Service up and running");
        this.myAlarmService = PoseidonRuntime.getRuntime().getService(PAlarmService.class);
        this.myConnectionInfo = PoseidonRuntime.getRuntime().getService(ConnectionInfo.class);
    }

    @Override
    public void stop() {
        if (GeneralUtils.isHeadlessMode()) {
            return;
        }
        PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class).removeRegistryListener(this);
        this.myGuiListeners.clear();
    }

    @Override
    public void itemAdded(PluginRegistryEvent event) {
    }

    @Override
    public void itemRemoved(PluginRegistryEvent event) {
        if (PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class).getApplications(ApplicationGrade.MASTER).size() != 0) {
            this.myDetailsControl.removeDetailsView(event.getPlugin());
        }
    }

    @Override
    public void setAlarmsTableInlineFiltering(boolean isInlineFilteringShown) {
        if (isInlineFilteringShown) {
            this.myAlarmView.setAlarmsTableFiltering();
        }
    }
}

