/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.alarmsview;

import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import com.nokia.em.poseidon.frameworks.mvc.ControllerBase;
import com.nokia.em.poseidon.services.alarmsview.PAlarmController;
import com.nokia.em.poseidon.services.alarmsview.PAlarmDetailsView;
import com.nokia.em.poseidon.services.alarmsview.PAlarmGuiListener;
import com.nokia.em.poseidon.services.alarmsview.PFilteringCriteria;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;

public class PAlarmDetailsController
extends ControllerBase
implements PAlarmGuiListener {
    private PAlarmController myMainControl;
    private PAlarmDetailsView myDetailsView;
    private PAlarmDetailsView myDefaultDetailsView;
    private Map<Object, PAlarmDetailsView> myApplicationDetailViews = new HashMap<Object, PAlarmDetailsView>();

    public PAlarmDetailsController(PAlarmController control) {
        this.myMainControl = control;
        this.myDefaultDetailsView = this.myDetailsView = new PAlarmDetailsView(this);
        this.myApplicationDetailViews.put(null, this.myDetailsView);
        this.myDetailsView.setParentController(this);
        this.myMainControl.addAlarmListener(this);
    }

    @Override
    public void destroy() {
        this.myMainControl.removeAlarmListener(this);
        this.myApplicationDetailViews.clear();
        this.myApplicationDetailViews = null;
        this.myDetailsView = null;
        super.destroy();
    }

    public PAlarmDetailsView changeAlarmDetailsView(PAlarmEntry alarm) {
        PAlarmDetailsView detailsView = null;
        Object application = null;
        if (alarm != null) {
            application = alarm.getApplication();
        }
        if (application != null) {
            detailsView = this.myApplicationDetailViews.get(application);
        }
        this.setDetailsView(detailsView != null ? detailsView : this.myDefaultDetailsView);
        return detailsView;
    }

    public void setDetailsView(Object application, PAlarmDetailsView detailsView) {
        if (application != null && detailsView != null) {
            this.myApplicationDetailViews.put(application, detailsView);
            this.setDetailsView(detailsView);
            this.myDefaultDetailsView = detailsView;
        } else if (application == null) {
            this.myDefaultDetailsView = detailsView;
            this.myDetailsView = detailsView;
        }
    }

    public void removeDetailsView(Object app) {
        this.myApplicationDetailViews.remove(app);
    }

    protected void setAlarmEntry(PAlarmEntry alarm) {
        this.myDetailsView.refreshView(alarm);
    }

    protected void helpRequested(PAlarmEntry alarm) {
        this.myMainControl.alarmHelpRequested(alarm);
    }

    protected void setDetailsView(PAlarmDetailsView detailsView) {
        this.myDetailsView = detailsView;
        this.myDetailsView.setParentController(this);
    }

    protected PAlarmDetailsView getDetailsView() {
        return this.myDetailsView;
    }

    protected DateFormat getAlarmDateFormat() {
        return this.myMainControl.getAlarmDateFormat();
    }

    protected void alarmSourceRequest(PAlarmEntry alarm) {
        this.myMainControl.alarmSourceRequest(alarm);
    }

    protected void showSourceButton(boolean show) {
        this.myDetailsView.setShowSourceVisible(show);
    }

    protected void enableShowSourceButton(boolean enable) {
        this.myDetailsView.setShowSourceEnabled(enable);
    }

    protected void refreshView(PAlarmEntry alarm) {
        this.myDetailsView.refreshView(alarm);
    }

    protected boolean isShowSourceVisible() {
        return this.myDetailsView.isShowSourceVisible();
    }

    protected boolean isShowSourceEnabled() {
        return this.myDetailsView.isShowSourceEnabled();
    }

    protected void resetViewToDefault() {
        this.myDetailsView.resetViewToDefault();
    }

    @Override
    public void alarmSelectedNotify(PAlarmEntry alarm) {
        this.changeAlarmDetailsView(alarm);
        this.setAlarmEntry(alarm);
    }

    @Override
    public void alarmDeselectedNotify(PAlarmEntry alarm) {
        this.changeAlarmDetailsView(null);
        this.setAlarmEntry(null);
    }

    @Override
    public void showAlarmHistory(boolean show) {
    }

    public String getSiteName() {
        return null;
    }

    public Object getApplicationRef() {
        return null;
    }

    @Override
    public void switchAndHighlightSource(PAlarmEntry alarm) {
    }

    @Override
    public void filteringCriteriaChangedNofity(PFilteringCriteria criteria) {
    }
}

