/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.alarmsview;

import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import com.nokia.em.poseidon.frameworks.alarm.PAlarmUtils;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.services.alarmsview.PAlarmDetailsController;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.labels.PStaticLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.layout.RowAlignLayout;
import com.nokia.widgets.text.TimeZoneFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class PAlarmDetailsView
extends JPanel {
    private ResourceBundle myResourceBundle;
    protected PStaticLabel myCodeValue;
    protected PStaticLabel myStatusValue;
    protected PLabel myStartedLabel;
    protected PStaticLabel myStartedValue;
    protected PLabel myClearedLabel;
    protected PStaticLabel myClearedValue;
    protected PHelpButton myHelpButton;
    protected JButton mySourceButton;
    private PAlarmDetailsController myController;
    private PAlarmEntry myAlarmEntry;
    private JPanel myDetailsPanel;
    private JScrollPane myScrollPane;
    private boolean myShowSourceVisible;
    protected PLabel myAddtionalInfoTitleLabel;
    protected PStaticLabel myAdditionalInfoText;

    public PAlarmDetailsView(PAlarmDetailsController controller) {
        this.myController = controller;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myStatusValue = new PStaticLabel();
        this.myStartedLabel = new PLabel();
        this.myStartedValue = new PStaticLabel();
        this.myClearedLabel = new PLabel();
        this.myClearedValue = new PStaticLabel();
        this.myCodeValue = new PStaticLabel();
        this.myAddtionalInfoTitleLabel = new PLabel();
        this.myAdditionalInfoText = new PStaticLabel();
        this.myHelpButton = new PHelpButton();
        this.mySourceButton = new JButton();
        this.buildUI();
    }

    public void refreshView(PAlarmEntry alarm) {
        this.myAlarmEntry = alarm;
        if (alarm != null) {
            this.myController.changeAlarmDetailsView(alarm);
            this.myCodeValue.setText(String.valueOf(alarm.getAlarmCode()) + " " + alarm.getAlarmScope());
            if (alarm.isAlarmTransient()) {
                this.myStatusValue.setText(this.myResourceBundle.getString("PAlarmView.Transient_Text"));
            } else {
                this.myStatusValue.setText(alarm.isActive() ? this.myResourceBundle.getString("Common.Active_Text") : this.myResourceBundle.getString("PAlarmDetailsView.Cleared_Text"));
            }
            this.myStartedValue.setText(this.getFormattedTime(alarm.getTime()));
            if (!alarm.isActive()) {
                this.myClearedValue.setText(this.getFormattedTime(alarm.getClearTime()));
            } else {
                this.myClearedValue.setText("");
            }
            this.myHelpButton.setEnabled(true);
            this.repaint();
        } else {
            this.resetViewToDefault();
        }
        this.mySourceButton.setVisible(this.myShowSourceVisible);
        this.myDetailsPanel.revalidate();
        int weight = this.myDetailsPanel.getPreferredSize().width;
        JScrollBar verticalScrollBar = this.myScrollPane.getVerticalScrollBar();
        if (verticalScrollBar.isVisible()) {
            weight += verticalScrollBar.getWidth();
        }
        this.myScrollPane.setPreferredSize(new Dimension(weight, 25));
        this.repaint();
    }

    public void resetViewToDefault() {
        this.myStatusValue.setText("");
        this.myCodeValue.setText("");
        this.myStartedValue.setText("");
        this.myClearedValue.setText("");
        this.setShowSourceEnabled(false);
        this.myHelpButton.setEnabled(false);
        this.repaint();
    }

    public void disposeWindow() {
        this.myController = null;
    }

    public void setShowSourceVisible(boolean show) {
        this.myShowSourceVisible = show;
        this.mySourceButton.setVisible(show);
    }

    public void setShowSourceEnabled(boolean enable) {
        this.mySourceButton.setEnabled(enable);
        this.mySourceButton.setToolTipText(this.myResourceBundle.getString(enable ? "PAlarmDetailsView.SourceEnabled_ToolTipText" : "PAlarmDetailsView.SourceDisabled_ToolTipText"));
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        JPanel detailsPanel = new JPanel();
        detailsPanel.setLayout(new BorderLayout());
        this.myDetailsPanel = this.createDetailsArea();
        this.addGhostPanel(this.myDetailsPanel);
        this.myScrollPane = new JScrollPane(this.myDetailsPanel);
        this.myScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myScrollPane.setPreferredSize(new Dimension(150, 25));
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setVerticalScrollBarPolicy(20);
        detailsPanel.add((Component)this.myScrollPane, "Center");
        detailsPanel.add((Component)this.createButtonPanel(), "South");
        this.add(detailsPanel);
    }

    protected void setParentController(PAlarmDetailsController parent) {
        this.myController = parent;
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new RowAlignLayout());
        this.myHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PAlarmDetailsView.this.myController != null) {
                    PAlarmDetailsView.this.myController.helpRequested(PAlarmDetailsView.this.myAlarmEntry);
                }
            }
        });
        this.myHelpButton.putClientProperty("helpListenerSet", false);
        this.myHelpButton.updateUI();
        this.myHelpButton.setToolTipText(this.myResourceBundle.getString("PAlarmDetailsView.Help_ToolTipText"));
        this.myHelpButton.setEnabled(false);
        buttonPanel.add(this.myHelpButton);
        this.mySourceButton.setName("PAlarmDetailsView.SourceButton");
        this.mySourceButton.setText(this.myResourceBundle.getString("PAlarmDetailsView.Source_Text"));
        this.mySourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (PAlarmDetailsView.this.myAlarmEntry != null && PAlarmDetailsView.this.myController != null) {
                    PAlarmDetailsView.this.myController.alarmSourceRequest(PAlarmDetailsView.this.myAlarmEntry);
                }
            }
        });
        this.setShowSourceEnabled(false);
        this.setShowSourceVisible(false);
        buttonPanel.add((Component)this.mySourceButton, "West");
        buttonPanel.putClientProperty("panelType", ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        buttonPanel.setBorder(PBorderFactory.getButtonBarBorder());
        return buttonPanel;
    }

    protected JPanel createDetailsArea() {
        JPanel details = new JPanel();
        details.setLayout(new GridBagLayout());
        ExtendedGridBagConstraints constraints = new ExtendedGridBagConstraints();
        details.putClientProperty("visibleLowerEdge", false);
        PLabel detailsViewTitle = PLabel.createHeader();
        detailsViewTitle.setText(this.myResourceBundle.getString("PAlarmDetailsView.Details_Text"));
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.fill = 0;
        constraints.insets = new Insets(20, 22, 12, 0);
        details.add((Component)detailsViewTitle, constraints);
        PLabel statusLabel = new PLabel();
        statusLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        statusLabel.setText(this.myResourceBundle.getString("PAlarmDetailsView.AlarmStatus_Text"));
        constraints.nextRow();
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 22, 0, 0);
        details.add((Component)statusLabel, constraints);
        this.myStatusValue.setAutoTooltipEnabled(true);
        constraints.nextColumn();
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 5, 0, 12);
        details.add((Component)this.myStatusValue, constraints);
        this.myStartedLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.myStartedLabel.setText(this.myResourceBundle.getString("PAlarmDetailsView.AlarmStarted_Text"));
        constraints.nextRow();
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 22, 0, 0);
        details.add((Component)this.myStartedLabel, constraints);
        this.myStartedValue.setAutoTooltipEnabled(true);
        constraints.nextColumn();
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 5, 0, 12);
        details.add((Component)this.myStartedValue, constraints);
        this.myClearedLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.myClearedLabel.setText(this.myResourceBundle.getString("PAlarmDetailsView.AlarmCleared_Text"));
        constraints.nextRow();
        constraints.weightx = 0.0;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 22, 0, 0);
        details.add((Component)this.myClearedLabel, constraints);
        this.myClearedValue.setAutoTooltipEnabled(true);
        constraints.nextColumn();
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 5, 0, 12);
        details.add((Component)this.myClearedValue, constraints);
        PLabel reportedAlarm = PLabel.createSubHeader();
        constraints.insets = new Insets(12, 22, 0, 0);
        constraints.gridwidth = 2;
        reportedAlarm.setText(this.myResourceBundle.getString("PAlarmDetailsView.ReportedAlarm_Text"));
        constraints.nextRow();
        details.add((Component)reportedAlarm, constraints);
        this.myCodeValue.setAutoTooltipEnabled(true);
        constraints.nextRow();
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 22, 0, 12);
        details.add((Component)this.myCodeValue, constraints);
        this.myAdditionalInfoText.setAutoTooltipEnabled(true);
        constraints.nextRow();
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 9, 0, 12);
        details.add((Component)this.myAdditionalInfoText, constraints);
        return details;
    }

    protected void addGhostPanel(JPanel panel) {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel ghostPanel = new JPanel();
        ghostPanel.setOpaque(false);
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)ghostPanel, constraints);
    }

    protected boolean isShowSourceVisible() {
        return this.mySourceButton.isVisible();
    }

    protected boolean isShowSourceEnabled() {
        return this.mySourceButton.isEnabled();
    }

    private String getFormattedTime(Calendar cal) {
        return String.valueOf(PAlarmUtils.getTimeStamp(cal)) + " " + TimeZoneFormatter.formatGMTText(cal);
    }
}

