/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.alarmsview;

import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import com.nokia.em.poseidon.services.alarmsview.PFilteringCriteria;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PAlarmFilter {
    private List<PAlarmEntry> myCurrentAlarms = new CopyOnWriteArrayList<PAlarmEntry>();
    private PFilteringCriteria myFilteringCriteria = new PFilteringCriteria();

    protected void addAlarm(PAlarmEntry alarm) {
        if (alarm != null && !this.myCurrentAlarms.contains(alarm)) {
            this.myCurrentAlarms.add(alarm);
        }
    }

    protected void setAlarms(List<PAlarmEntry> alarms) {
        if (alarms != null) {
            this.myCurrentAlarms = new ArrayList<PAlarmEntry>(alarms);
        }
    }

    protected void addAlarms(List<PAlarmEntry> alarms) {
        if (alarms != null) {
            ArrayList<PAlarmEntry> copyList = new ArrayList<PAlarmEntry>(alarms);
            for (PAlarmEntry alarm : copyList) {
                this.addAlarm(alarm);
            }
        }
    }

    protected void clearModel() {
        this.myCurrentAlarms.clear();
    }

    protected List<PAlarmEntry> getAlarms(PFilteringCriteria criteria) {
        this.setFilteringCriteria(criteria);
        return this.getAlarms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PAlarmEntry> getAlarms() {
        ArrayList<PAlarmEntry> alarmsAfterFiltering = new ArrayList<PAlarmEntry>(this.myCurrentAlarms);
        PFilteringCriteria pFilteringCriteria = this.myFilteringCriteria;
        synchronized (pFilteringCriteria) {
            if (this.myFilteringCriteria.isSomethingFiltered() && this.myCurrentAlarms.size() != 0) {
                Iterator iter = alarmsAfterFiltering.iterator();
                while (iter.hasNext()) {
                    PAlarmEntry entry = (PAlarmEntry)iter.next();
                    if (!this.checkEntryFiltering(entry)) continue;
                    iter.remove();
                }
            }
        }
        return alarmsAfterFiltering;
    }

    protected boolean checkEntryFiltering(PAlarmEntry entry) {
        boolean filteringCriteriaMatch = false;
        int severity = entry.getSeverity();
        if (this.myFilteringCriteria.myFilterClearedAlarms && !entry.isActive()) {
            filteringCriteriaMatch = true;
        }
        if (this.myFilteringCriteria.myInlineFilterActive && entry.isHiddenByFilter()) {
            filteringCriteriaMatch = true;
        }
        switch (severity) {
            case 0: {
                if (!this.myFilteringCriteria.myFilterWarningAlarms) break;
                filteringCriteriaMatch = true;
                break;
            }
            case 1: {
                if (!this.myFilteringCriteria.myFilterMinorAlarms) break;
                filteringCriteriaMatch = true;
                break;
            }
            case 2: {
                if (!this.myFilteringCriteria.myFilterMajorAlarms) break;
                filteringCriteriaMatch = true;
                break;
            }
            case 3: {
                if (!this.myFilteringCriteria.myFilterCriticalAlarms) break;
                filteringCriteriaMatch = true;
                break;
            }
        }
        return filteringCriteriaMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkAlarmsShowing(List<PAlarmEntry> alarmsList) {
        boolean showAtLeastOneAlarm = false;
        PFilteringCriteria pFilteringCriteria = this.myFilteringCriteria;
        synchronized (pFilteringCriteria) {
            if (alarmsList != null) {
                if (!this.myFilteringCriteria.isSomethingFiltered()) {
                    showAtLeastOneAlarm = true;
                } else {
                    for (PAlarmEntry entry : alarmsList) {
                        if (this.checkEntryFiltering(entry)) continue;
                        showAtLeastOneAlarm = true;
                        break;
                    }
                }
            }
        }
        return showAtLeastOneAlarm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFilteringCriteria(PFilteringCriteria criteria) {
        PFilteringCriteria pFilteringCriteria = this.myFilteringCriteria;
        synchronized (pFilteringCriteria) {
            this.myFilteringCriteria.setFrom(criteria);
        }
    }

    protected PFilteringCriteria getFilteringCriteria() {
        return this.myFilteringCriteria.getCopy();
    }
}

