/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.alarmsview;

import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class PAlarmTableModel
extends AbstractTableModel {
    protected List<PAlarmEntry> myEntries = new ArrayList<PAlarmEntry>();
    protected String[] myColumnTitles = new String[]{"", "", "", ""};
    protected int myColumnsCount = this.myColumnTitles.length;

    public PAlarmTableModel(String[] columnTitles) {
        this.myColumnTitles = columnTitles;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Object.class;
            }
            case 1: {
                return Calendar.class;
            }
            case 2: {
                return Object.class;
            }
            case 3: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return this.myColumnsCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.myColumnTitles.length) {
            return "";
        }
        return this.myColumnTitles[columnIndex];
    }

    public void setColumnName(int columnIndex, String columnName) {
        if (columnIndex < 0 || columnIndex >= this.myColumnTitles.length) {
            return;
        }
        this.myColumnTitles[columnIndex] = columnName;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public PAlarmEntry getEntry(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        return this.myEntries.get(row);
    }

    @Override
    public int getRowCount() {
        return this.myEntries.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return "";
        }
        PAlarmEntry pAlarmEntryInRow = this.myEntries.get(row);
        switch (column) {
            case 0: {
                return pAlarmEntryInRow.getSeverity();
            }
            case 1: {
                return pAlarmEntryInRow.getTime();
            }
            case 2: {
                return pAlarmEntryInRow.getDescription();
            }
            case 3: {
                return pAlarmEntryInRow.getSource();
            }
        }
        return "";
    }

    protected void setContents(List<PAlarmEntry> filteredEntries) {
        this.myEntries.clear();
        if (filteredEntries != null) {
            this.myEntries.addAll(filteredEntries);
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected int getRowIndex(PAlarmEntry entry) {
        return this.myEntries.indexOf(entry);
    }

    protected List<PAlarmEntry> getCurrentVisibleAlarms() {
        return this.myEntries;
    }

    protected void clear() {
        int iSize = this.myEntries.size();
        if (iSize > 0) {
            this.myEntries.clear();
            this.fireTableRowsDeleted(0, iSize - 1);
        }
    }
}

