/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.alarmsview;

import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import com.nokia.em.poseidon.services.alarmsview.PAlarmTableModel;
import com.nokia.widgets.table.PTableModelSorter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class PAlarmTableSorterModel
extends PTableModelSorter {
    public static final int COLUMN_NOT_SORTED = 0;
    public static final int COLUMN_SORTED_ASCENDING = 1;
    public static final int COLUMN_SORTED_DESCENDING = 2;
    private JTableHeader myTableHeader;
    protected int myLastSortColumn = 1;
    protected boolean myAscending = false;
    protected int[] myIndexes;

    public PAlarmTableSorterModel(TableModel inModel) {
        super(inModel);
        this.reallocateIndexes();
    }

    public void setTableHeader(JTableHeader inHeader) {
        this.myTableHeader = inHeader;
    }

    public int getColumnSortingState(int column) {
        int sortState = 0;
        sortState = column != this.myLastSortColumn ? 0 : (this.myAscending ? 1 : 2);
        return sortState;
    }

    public void sortByColumn(int column, boolean inAscending) {
        this.sort(inAscending, column);
        this.myTableHeader.repaint();
    }

    @Override
    public int sort(boolean switchDirection, int columnIndex) {
        int nextSortCriteria = this.getNextSortingCriteria(columnIndex);
        int sortDirection = super.sort(switchDirection, columnIndex);
        super.subsort(sortDirection, nextSortCriteria);
        return sortDirection;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
    }

    public int getActualIndex(int selRow) {
        if (selRow >= 0 && selRow < this.myIndexes.length) {
            return this.myIndexes[selRow];
        }
        return -1;
    }

    public int getActualRow(int selIndex) {
        int i = 0;
        while (i < this.myIndexes.length) {
            if (this.myIndexes[i] == selIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<PAlarmEntry> getSortedAlarms() {
        ArrayList<PAlarmEntry> sortedAlarmsList = new ArrayList<PAlarmEntry>();
        TableModel tableModel = this.getWrappedModel();
        if (tableModel instanceof PAlarmTableModel) {
            PAlarmTableModel alarmTableModel = (PAlarmTableModel)tableModel;
            List<PAlarmEntry> unsortedDisplayedAlarms = alarmTableModel.getCurrentVisibleAlarms();
            int i = 0;
            int size = unsortedDisplayedAlarms.size();
            while (i < size) {
                sortedAlarmsList.add(alarmTableModel.getEntry(this.getOriginalIndex(i)));
                ++i;
            }
        }
        return sortedAlarmsList;
    }

    protected Vector getInternalSortingCriteria(int column, Vector sortingColumn) {
        int nextCriteria = this.getNextSortingCriteria(column);
        if (-1 != nextCriteria) {
            sortingColumn.add(nextCriteria);
        }
        return sortingColumn;
    }

    private void reallocateIndexes() {
        int rowCount = this.getRowCount();
        this.myIndexes = new int[rowCount];
        int row = 0;
        while (row < rowCount) {
            this.myIndexes[row] = row;
            ++row;
        }
    }

    private int getNextSortingCriteria(int column) {
        int nextCriteria = -1;
        switch (column) {
            case 0: {
                nextCriteria = 3;
                break;
            }
            case 1: {
                nextCriteria = 0;
                break;
            }
            case 2: {
                break;
            }
            default: {
                nextCriteria = 0;
            }
        }
        return nextCriteria;
    }
}

