/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.alarmsview;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import com.nokia.em.poseidon.frameworks.alarm.PAlarmUtils;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.frameworks.mvc.swing.JPanelViewBase;
import com.nokia.em.poseidon.gui.common.edittable.PEditTable;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserController;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserDefaultValidator;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserFactory;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserModel;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserView;
import com.nokia.em.poseidon.services.alarmsview.PAlarmController;
import com.nokia.em.poseidon.services.alarmsview.PAlarmDetailsView;
import com.nokia.em.poseidon.services.alarmsview.PAlarmTableModel;
import com.nokia.em.poseidon.services.alarmsview.PAlarmTableSorterModel;
import com.nokia.em.poseidon.services.alarmsview.PFilteringCriteria;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.file.PFileFilter;
import com.nokia.em.poseidon.util.file.PFileUtils;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.laf.borders.BaseBorder;
import com.nokia.laf.util.GradientUtils;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.buttons.MenuButton;
import com.nokia.widgets.buttons.PToggleToolButton;
import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.icons.CompoundIcon;
import com.nokia.widgets.labels.ItemCountLabel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.tabbutton.TabButtonPanel;
import com.nokia.widgets.table.PTable;
import com.nokia.widgets.table.PTableCellRenderer;
import com.nokia.widgets.table.StringConverter;
import com.nokia.widgets.table.TableRowFilter;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class PAlarmView
extends JPanelViewBase {
    private Logger myLogger = Logger.getLogger(this.getClass());
    protected static final int SEVERITY_COLUMN_INDEX = 0;
    protected static final int TIME_COLUMN_INDEX = 1;
    protected static final int DESCRIPTION_COLUMN_INDEX = 2;
    protected static final int SOURCE_COLUMN_INDEX = 3;
    private static final String SETTINGS_KEY_SPLITTER_LOCATION = "poseidon.alarmsview.splitterloc";
    private static final String SETTINGS_KEY_COLUMN_WIDTHS = "poseidon.alarmsview.columnwidth";
    private static final String SETTINGS_KEY_SAVING_FILE = "poseidon.alarmsview.savingfile";
    private static final int DEFAULT_DETAILS_VIEW_WIDTH = 450;
    private static final int NO_SELECTED_ENTRY = -1;
    private static int TIME_COLUMN_WIDTH = 140;
    private static int DESCRIPTION_COLUMN_WIDTH = 250;
    private static int SOURCE_COLUMN_WIDTH = 150;
    private static int TIME_COLUMN_MINWIDTH = 145;
    private static int DESCRIPTION_COLUMN_MINWIDTH = 250;
    private static int SOURCE_COLUMN_MINWIDTH = 90;
    private static int NEW_ALARM_NOTIFICATION_TIME = 5000;
    private static int ACTIVE_ALARMS_LABEL_WIDTH = 95;
    private static int HIDDEN_ALARMS_LABEL_WIDTH = 95;
    private static int ACTIVE_ALARMS_LABEL_HEIGHT = 20;
    private final ResourceBundle myResourceBundle;
    private JSplitPane myLeftRightSplit;
    private PAlarmTableModel myAlarmTableModel;
    private PTable myAlarmsTable;
    private PAlarmTableSorterModel mySortedAlarmModel;
    private final PAlarmController myControl;
    private final PFilteringCriteria myFilteringCriteria = new PFilteringCriteria();
    private PAlarmEntry myCurrentSelectedEntry;
    private boolean myIsColumnRendererSet;
    private PToolButton mySaveButton;
    private PToggleToolButton myHistoryButton;
    private JToggleButton myWarningButton;
    private JToggleButton myMinorButton;
    private JToggleButton myMajorButton;
    private JToggleButton myCriticalButton;
    private PSettings mySettings;
    private JPopupMenu myPopupMenu;
    private JMenuItem myShowSourcePopupItem;
    private JMenuItem myCopyPopupItem;
    private JMenuItem myHelpPopupItem;
    private boolean myHasFocus;
    private ItemCountLabel myActiveAlarmsLabel;
    private PLabel myNewAlarmLabel;
    private JPanel myNewAlarmPlaceHolder;
    private PLabel myAllHiddenLabel;
    private JPanel myAllHiddenPlaceHolder;
    private final NewAlarmTimer myAlarmReceivedTimer;
    private final Collection<JComponent> myCustomComponents = new ArrayList<JComponent>();
    private JPanel myCustomComponentPanel;
    private PLabel myAlarmTitle;
    private PLabel myFilteringTitle;
    private JLabel myViewIconLabel;
    private JPanel myAlarmTitleBar;
    private JScrollPane myTableScrollPane;
    private boolean myIsFirstime;
    private JMenuItem myCustomHelpPopupItem;
    private static Color[] CRITICAL_STRIPE = new Color[]{NetUtils.decodeColor("#FF1A1A"), NetUtils.decodeColor("#E81515")};
    private static Color[] MAJOR_STRIPE = new Color[]{NetUtils.decodeColor("#FD8B18"), NetUtils.decodeColor("#E67401")};
    private static Color[] MINOR_STRIPE = new Color[]{NetUtils.decodeColor("#FED11A"), NetUtils.decodeColor("#E6B802")};
    private static Color[] WARNING_STRIPE = new Color[]{NetUtils.decodeColor("#5959EC"), NetUtils.decodeColor("#4040D3")};
    private static Color[] CLEARED_STRIPE = new Color[]{NetUtils.decodeColor("#76D11A"), NetUtils.decodeColor("#57B801")};

    public PAlarmView(PAlarmController controller) {
        super(controller);
        this.myControl = controller;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.buildUI();
        this.setMinimumSize(new Dimension(0, 0));
        Localizer localizer = LocalizerRegistry.lookup("swing");
        localizer.setResourceBundle(this.myResourceBundle);
        localizer.localizeObjectHierarchy(new SwingHierarchyIterator(this));
        this.myAlarmReceivedTimer = new NewAlarmTimer();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.myIsColumnRendererSet) {
            return;
        }
        ColumnRenderer columnRenderer = null;
        TableColumn column = null;
        int columnCount = this.mySortedAlarmModel.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            columnRenderer = new ColumnRenderer(this.myAlarmsTable);
            column = this.myAlarmsTable.getColumnModel().getColumn(i);
            column.setCellRenderer(columnRenderer);
            switch (i) {
                case 0: {
                    Insets insets = columnRenderer.getInsets();
                    int gap = columnRenderer.getIconTextGap();
                    int columnMargin = this.myAlarmsTable.getColumnModel().getColumnMargin();
                    int spacing = insets.left + insets.right + gap + columnMargin;
                    column.setPreferredWidth(spacing + columnRenderer.countSeverityColumnMaxWidth());
                    column.setMinWidth(spacing + columnRenderer.countSeverityColumnMaxWidth());
                    column.setMaxWidth(spacing + columnRenderer.countSeverityColumnMaxWidth());
                    column.setResizable(false);
                    break;
                }
                case 1: {
                    column.setPreferredWidth(TIME_COLUMN_WIDTH);
                    column.setMinWidth(TIME_COLUMN_MINWIDTH);
                    break;
                }
                case 2: {
                    column.setPreferredWidth(DESCRIPTION_COLUMN_WIDTH);
                    column.setMinWidth(DESCRIPTION_COLUMN_MINWIDTH);
                    break;
                }
                case 3: {
                    column.setPreferredWidth(SOURCE_COLUMN_WIDTH);
                    column.setMinWidth(SOURCE_COLUMN_MINWIDTH);
                    break;
                }
            }
            ++i;
        }
        this.mySortedAlarmModel.sort(false, 1);
        this.mySortedAlarmModel.secondarySort(2, 0);
        this.myIsColumnRendererSet = true;
        this.restoreSettings();
        this.restoreTitleBar();
        this.myAlarmsTable.getTableHeader().repaint();
    }

    public void setAlarmsTableFiltering() {
        this.myAlarmsTable.setSimpleFilteringEnabled(true);
        this.myAlarmsTable.setFilteringEnabled(0, false);
        this.mySortedAlarmModel.setStringConverter(new CalendarDateStringConverter());
        this.layoutMenuButton();
    }

    private MenuButton createMenuButton() {
        MenuButton naviSettingsButton = new MenuButton(CommonIcons.getNaviSettingsIcon());
        naviSettingsButton.setBorder(BorderFactory.createEmptyBorder(4, 8, 8, 18));
        naviSettingsButton.setToolButton(true);
        naviSettingsButton.add(this.initializePopupMenuForMenuButton());
        naviSettingsButton.setFocusable(false);
        return naviSettingsButton;
    }

    private JPopupMenu initializePopupMenuForMenuButton() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(this.createShowInlineFilterMenuItem());
        popupMenu.add(this.createClearInlineFilterMenuItem());
        return popupMenu;
    }

    private void layoutMenuButton() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(4, 0, 1, 0);
        constraints.gridx = 9;
        constraints.weightx = 0.0;
        constraints.anchor = 13;
        this.myAlarmTitleBar.add((Component)this.createMenuButton(), constraints);
    }

    private JCheckBoxMenuItem createShowInlineFilterMenuItem() {
        final JCheckBoxMenuItem showInlineFilterItem = new JCheckBoxMenuItem(this.myResourceBundle.getString("PAlarmView.ShowInlineFilter_Text"));
        showInlineFilterItem.setSelected(true);
        showInlineFilterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                PAlarmView.this.myAlarmsTable.setSimpleFilteringEnabled(showInlineFilterItem.isSelected());
                PAlarmView.this.myAlarmsTable.repaint();
            }
        });
        return showInlineFilterItem;
    }

    private JMenuItem createClearInlineFilterMenuItem() {
        JMenuItem clearInlineFilterMenu = new JMenuItem(this.myResourceBundle.getString("PAlarmView.ClearInlineFilter_Text"));
        clearInlineFilterMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PAlarmView.this.myAlarmsTable.clearInlineFilter();
            }
        });
        return clearInlineFilterMenu;
    }

    public List<PAlarmEntry> getDisplayedAlarms() {
        return this.myAlarmTableModel.getCurrentVisibleAlarms();
    }

    public List<PAlarmEntry> getSortedDisplayedAlarms() {
        return this.mySortedAlarmModel.getSortedAlarms();
    }

    protected JPanel createCustomComponentPanel() {
        this.myCustomComponentPanel = new JPanel();
        this.myCustomComponentPanel.setLayout(new FlowLayout(1, 5, 0));
        for (JComponent customComponent : this.myCustomComponents) {
            this.myCustomComponentPanel.add(customComponent);
        }
        return this.myCustomComponentPanel;
    }

    protected void storeSettings() {
        if (this.getSettings() != null) {
            this.getSettings().set(SETTINGS_KEY_SPLITTER_LOCATION, this.myLeftRightSplit.getDividerLocation());
        }
        this.storeColumnWidths();
    }

    protected void restoreSettings() {
        JFrame mainFrame = PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame();
        PSettings settings = this.myControl.getSettings();
        if (mainFrame == null) {
            return;
        }
        if (settings != null) {
            int defaultDividerLocation = mainFrame.getWidth() - 450;
            this.myLeftRightSplit.setDividerLocation(settings.get(SETTINGS_KEY_SPLITTER_LOCATION, defaultDividerLocation));
        } else {
            this.myLeftRightSplit.setDividerLocation(mainFrame.getWidth() - 450);
        }
    }

    protected void setDetailsView(PAlarmDetailsView detailsView) {
        int dividerLocation = this.myLeftRightSplit.getDividerLocation();
        this.myLeftRightSplit.setRightComponent(detailsView);
        this.myLeftRightSplit.setDividerLocation(dividerLocation);
    }

    protected void refreshView(List<PAlarmEntry> alarms) {
        if (SwingUtilities.isEventDispatchThread()) {
            new ViewRefresher(alarms).run();
        } else {
            SwingUtilities.invokeLater(new ViewRefresher(alarms));
        }
    }

    protected void saveAlarms() {
        this.applyInlineFilteringOnAlarms(this.isInlineFilterActive());
        SaveChooserModel initialSaveModel = new SaveChooserModel();
        initialSaveModel.setSettings(this.mySettings);
        initialSaveModel.setSettingsKey(SETTINGS_KEY_SAVING_FILE);
        initialSaveModel.setDialogTitle(this.myResourceBundle.getString("PAlarmView.SaveDialogTitle_Text"));
        initialSaveModel.setDefaultFileName(this.restoreFileName());
        initialSaveModel.setDefaultPath(this.restorePathName());
        initialSaveModel.setFileFilter(new PFileFilter(new String[]{"txt"}, this.myResourceBundle.getString("PDefaultAlarmFileWriter.FileFilter_Text")));
        SaveChooserController saveController = SaveChooserFactory.createFileChooserController(initialSaveModel);
        final SaveChooserModel saveModel = saveController.getModel();
        final SaveChooserView saveView = (SaveChooserView)saveController.getView();
        this.myIsFirstime = true;
        saveModel.setFileValidator(new SaveChooserDefaultValidator(){

            @Override
            public boolean validateSelection(File selectedFile) {
                if (PAlarmView.this.myIsFirstime) {
                    PAlarmView.this.myIsFirstime = false;
                    String originalFilename = PAlarmView.this.restoreFileName();
                    String defaultFilename = PFileUtils.removeInvalidCharacters(originalFilename);
                    String currentDirectory = saveView.getCurrentDirectory() + System.getProperty("file.separator");
                    File defaultFile = new File(String.valueOf(currentDirectory) + defaultFilename);
                    defaultFile = defaultFile.exists() ? saveView.createAlternativeDefaultFile(defaultFile) : defaultFile;
                    saveModel.setDefaultFileName(defaultFilename);
                    saveView.setSelectedFile(defaultFile);
                    if (!defaultFilename.equals(originalFilename)) {
                        this.myMessageMap.put("Save.InvalidFileHeader", this.myResourceBundle.getString("PSaveSnapshotView_invalidSiteName_header"));
                        this.myMessageMap.put("Save.InvalidFileBody", this.myResourceBundle.getString("PSaveSnapshotView_invalidSiteName_text"));
                        return false;
                    }
                    return super.validateSelection(selectedFile);
                }
                return super.validateSelection(selectedFile);
            }
        });
        saveController.setVisible(true);
        File selectedFile = saveController.selectFile();
        if (selectedFile != null) {
            this.storePathName(selectedFile.getParent());
            this.myControl.saveAlarms(selectedFile);
        }
        for (PAlarmEntry entry : this.myControl.getAllAlarms()) {
            entry.setIsHiddenByFilter(false);
        }
        this.myFilteringCriteria.myInlineFilterActive = false;
        this.myControl.filteringChangedNotify(this.myFilteringCriteria);
    }

    protected void showCriticalAlarms(boolean show) {
        this.myCriticalButton.setSelected(!show);
        this.myFilteringCriteria.myFilterCriticalAlarms = show;
        this.myControl.filteringChangedNotify(this.myFilteringCriteria);
    }

    protected void showMajorAlarms(boolean show) {
        this.myMajorButton.setSelected(!show);
        this.myFilteringCriteria.myFilterMajorAlarms = show;
        this.myControl.filteringChangedNotify(this.myFilteringCriteria);
    }

    protected void showMinorAlarms(boolean show) {
        this.myMinorButton.setSelected(!show);
        this.myFilteringCriteria.myFilterMinorAlarms = show;
        this.myControl.filteringChangedNotify(this.myFilteringCriteria);
    }

    protected void showWarnings(boolean show) {
        this.myWarningButton.setSelected(!show);
        this.myFilteringCriteria.myFilterWarningAlarms = show;
        this.myControl.filteringChangedNotify(this.myFilteringCriteria);
    }

    protected void showClearedAlarms(boolean show) {
        this.myHistoryButton.setSelected(show);
        this.myFilteringCriteria.myFilterClearedAlarms = !show;
        this.myControl.filteringChangedNotify(this.myFilteringCriteria);
    }

    protected void applyInlineFilteringOnAlarms(boolean isActive) {
        if (isActive) {
            for (PAlarmEntry entry : this.myControl.getAllAlarms()) {
                entry.setIsHiddenByFilter(true);
            }
            int rowIndex = 0;
            while (rowIndex < this.myControl.getAllAlarms().size()) {
                this.updateAlarmFilter(rowIndex);
                ++rowIndex;
            }
        } else {
            for (PAlarmEntry entry : this.myControl.getAllAlarms()) {
                entry.setIsHiddenByFilter(false);
            }
        }
        this.myFilteringCriteria.myInlineFilterActive = isActive;
        this.myControl.filteringChangedNotify(this.myFilteringCriteria);
    }

    private void updateAlarmFilter(int rowIndex) {
        PAlarmEntry alarmEntry;
        if (this.mySortedAlarmModel.getRowFilter().isIncluded(rowIndex, this.mySortedAlarmModel) && (alarmEntry = this.myAlarmTableModel.getEntry(rowIndex)) != null) {
            alarmEntry.setIsHiddenByFilter(false);
        }
    }

    private boolean isInlineFilterActive() {
        TableRowFilter filter = this.mySortedAlarmModel.getRowFilter();
        return filter == null ? false : filter.isActive();
    }

    protected PFilteringCriteria getFilteringCriteria() {
        return this.myFilteringCriteria;
    }

    protected void updateDateFormat() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.myAlarmTableModel.setColumnName(1, String.valueOf(this.myResourceBundle.getString("PAlarmView.Column.Time_Text")) + PAlarmUtils.getTimezoneText(this.myControl.getAlarmDateFormat().getTimeZone()));
            this.myAlarmsTable.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(this.myAlarmTableModel.getColumnName(1));
            this.myAlarmsTable.getTableHeader().repaint();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PAlarmView.this.updateDateFormat();
            }
        });
    }

    protected void showNewAlarmNotification() {
        this.myAlarmReceivedTimer.newAlarmReceived();
    }

    protected void addCustomComponentToHeader(JComponent component) {
        this.myCustomComponents.add(component);
        if (this.myCustomComponentPanel != null) {
            this.myCustomComponentPanel.add(component);
            this.myCustomComponentPanel.revalidate();
        }
    }

    protected void removeCustomComponentFromHeader(JComponent component) {
        this.myCustomComponents.remove(component);
        if (this.myCustomComponentPanel != null) {
            this.myCustomComponentPanel.remove(component);
            this.myCustomComponentPanel.revalidate();
        }
    }

    protected void removeAllCustomComponentFromHeader() {
        this.myCustomComponents.clear();
        if (this.myCustomComponentPanel != null) {
            this.myCustomComponentPanel.removeAll();
            this.myCustomComponentPanel.revalidate();
        }
    }

    protected void setAlarmViewIcon(Icon icon) {
        if (icon != null) {
            this.myViewIconLabel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        } else {
            this.myViewIconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        this.myViewIconLabel.setIcon(icon);
        this.myViewIconLabel.revalidate();
    }

    protected void storeColumnWidths() {
        int[] columnWidths = new int[3];
        if (this.myAlarmsTable != null) {
            columnWidths[0] = this.myAlarmsTable.getColumnModel().getColumn(1).getWidth();
            columnWidths[1] = this.myAlarmsTable.getColumnModel().getColumn(2).getWidth();
            columnWidths[2] = this.myAlarmsTable.getColumnModel().getColumn(3).getWidth();
        } else {
            columnWidths[0] = TIME_COLUMN_WIDTH;
            columnWidths[1] = DESCRIPTION_COLUMN_WIDTH;
            columnWidths[2] = SOURCE_COLUMN_WIDTH;
        }
        this.getSettings().setSequence(SETTINGS_KEY_COLUMN_WIDTHS, columnWidths);
    }

    protected void enableActions(boolean enable) {
        this.myCriticalButton.setEnabled(enable);
        this.myMajorButton.setEnabled(enable);
        this.myMinorButton.setEnabled(enable);
        this.myWarningButton.setEnabled(enable);
        this.myHistoryButton.setEnabled(enable);
        this.mySaveButton.setEnabled(enable);
        this.myAlarmsTable.setEnabled(enable);
        this.myAlarmsTable.getTableHeader().setEnabled(enable);
        this.myControl.getDetailsViewController().enableShowSourceButton(enable);
    }

    public void setSaveButtonEnabled(boolean enable) {
        this.mySaveButton.setEnabled(enable);
    }

    protected void updateActiveAlarmsText() {
        int alarmCount = this.myControl.getAllActiveAlarms().size();
        this.myActiveAlarmsLabel.setItemCount(alarmCount);
        this.myActiveAlarmsLabel.setVisible(alarmCount > 0);
        this.myActiveAlarmsLabel.repaint();
    }

    protected void clearAlarmSelection() {
        if (this.myCurrentSelectedEntry == null) {
            return;
        }
        this.myControl.alarmDeselectionNotify(this.myCurrentSelectedEntry);
        this.myAlarmsTable.clearSelection();
        this.myCurrentSelectedEntry = null;
        this.myControl.getDetailsViewController().changeAlarmDetailsView(null);
        this.myControl.getDetailsViewController().refreshView(null);
    }

    protected void requestFocusIntoAlarmTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                PAlarmView.this.myAlarmsTable.requestFocus();
            }
        });
    }

    public void add(View view, Object object) {
    }

    protected void updateHiddenAlarmsText(int shown) {
        int hidden = 0;
        hidden = this.myFilteringCriteria.isAlarmHistoryFiltered() ? this.myControl.getAllActiveAlarms().size() - shown : this.myControl.getAllAlarms().size() - shown;
        if (!this.myFilteringCriteria.isCriticalAlarmsFiltered() && !this.myFilteringCriteria.isMajorAlarmsFiltered() && !this.myFilteringCriteria.isMinorAlarmsFiltered() && !this.myFilteringCriteria.isWarningsFiltered() || hidden == 0) {
            this.myAllHiddenLabel.setVisible(false);
            this.myAllHiddenPlaceHolder.setVisible(true);
            return;
        }
        Object[] num = new Object[]{hidden};
        this.myAllHiddenLabel.setVisible(true);
        this.myAllHiddenPlaceHolder.setVisible(false);
        if (this.myFilteringCriteria.isCriticalAlarmsFiltered() && this.myFilteringCriteria.isMajorAlarmsFiltered() && this.myFilteringCriteria.isMinorAlarmsFiltered() && this.myFilteringCriteria.isWarningsFiltered() || shown == 0) {
            this.myAllHiddenLabel.setText(this.myResourceBundle.getString("PAlarmView.AllHidden_Text"));
        } else {
            this.myAllHiddenLabel.setText(MessageFormat.format(this.myResourceBundle.getString("PAlarmView.HiddenAlarms_Text"), num));
        }
    }

    private void restoreTitleBar() {
        this.myAllHiddenPlaceHolder.setMaximumSize(this.myAllHiddenLabel.getPreferredSize());
        this.myAllHiddenPlaceHolder.setMinimumSize(this.myAllHiddenLabel.getPreferredSize());
        this.myAllHiddenPlaceHolder.setPreferredSize(this.myAllHiddenLabel.getPreferredSize());
        this.myNewAlarmPlaceHolder.setMinimumSize(this.myNewAlarmLabel.getPreferredSize());
        this.myNewAlarmPlaceHolder.setMaximumSize(this.myNewAlarmLabel.getPreferredSize());
        this.myNewAlarmPlaceHolder.setPreferredSize(this.myNewAlarmLabel.getPreferredSize());
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createAlarmsView(), (Object)"Center");
        this.myControl.initFilteringCriteria(this.myFilteringCriteria);
    }

    private String restoreFileName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        StringBuilder fileName = new StringBuilder();
        fileName.append(String.valueOf(this.myResourceBundle.getString("PAlarmView.AlarmReport")) + "_");
        if (this.myControl.getDefaultSiteName() != null && !"".equals(this.myControl.getDefaultSiteName())) {
            fileName.append(String.valueOf(this.myControl.getDefaultSiteName().replaceAll("\\s", "")) + "_");
        }
        fileName.append(String.valueOf(dateFormat.format(new Date())) + ".txt");
        return fileName.toString();
    }

    private String restorePathName() {
        String keySettingLocation;
        String directoryName = this.myControl.getDefaultSavingPath();
        if (directoryName == null) {
            directoryName = "";
        }
        if ((keySettingLocation = this.getSettings().get(SETTINGS_KEY_SAVING_FILE, directoryName)).length() == 0) {
            return PoseidonRuntime.getRuntime().getUserHome();
        }
        return String.valueOf(keySettingLocation) + System.getProperty("file.separator");
    }

    private void storePathName(String pathName) {
        this.getSettings().set(SETTINGS_KEY_SAVING_FILE, pathName);
    }

    private PSettings getSettings() {
        if (this.mySettings == null) {
            this.mySettings = this.myControl.getSettings();
        }
        return this.mySettings;
    }

    private JPanel createAlarmsView() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel titleBar = this.createAlarmsTitleBar();
        String dateFormat = PAlarmUtils.getTimezoneText(this.myControl.getAlarmDateFormat().getTimeZone());
        String[] columnTitles = new String[]{this.myResourceBundle.getString("PAlarmView.Column.Severity_Text"), String.valueOf(this.myResourceBundle.getString("PAlarmView.Column.Time_Text")) + dateFormat, this.myResourceBundle.getString("PAlarmView.Column.Description_Text"), this.myResourceBundle.getString("PAlarmView.Column.Source_Text")};
        this.myAlarmTableModel = new PAlarmTableModel(columnTitles);
        this.mySortedAlarmModel = new PAlarmTableSorterModel(this.myAlarmTableModel);
        this.myAlarmsTable = new PEditTable(this.mySortedAlarmModel){

            @Override
            public Point getPopupLocation(MouseEvent event) {
                if (event == null) {
                    Rectangle selectedRect = this.getCellRect(this.getSelectedRow(), this.getSelectedColumn(), false);
                    int x = (int)(selectedRect.getX() + (double)(selectedRect.width / 4));
                    int y = (int)(selectedRect.getY() + (double)(selectedRect.height / 2));
                    return new Point(x, y);
                }
                return super.getPopupLocation(event);
            }

            @Override
            public JPopupMenu getComponentPopupMenu() {
                if (this.getSelectedRow() == -1) {
                    return null;
                }
                PAlarmView.this.createPopupMenu();
                return PAlarmView.this.myPopupMenu;
            }
        };
        this.myAlarmsTable.setStandalone(false);
        this.myAlarmsTable.setAlternate(false);
        Object emptyText = new Object(){

            public String toString() {
                return PAlarmView.this.myResourceBundle.getString(PAlarmView.this.myControl.getAllActiveAlarms().size() > 0 ? "PAlarmView.FaultsHidden_Text" : "PAlarmView.EmptyTable_Text");
            }
        };
        this.myAlarmsTable.setEmptyText(emptyText);
        this.myAlarmsTable.putClientProperty("shall_handle_view_focus", Boolean.FALSE);
        this.myAlarmsTable.setName("AlarmTable");
        this.myAlarmsTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PAlarmView.this.myControl.focusLostNotify(PAlarmView.this.myCurrentSelectedEntry);
                PAlarmView.this.myHasFocus = false;
            }

            @Override
            public void focusGained(FocusEvent e) {
                int currentSelectedEntry;
                if (!PAlarmView.this.getDisplayedAlarms().isEmpty() && -1 != (currentSelectedEntry = PAlarmView.this.myAlarmsTable.getSelectedRow())) {
                    int currentSelectedEntryIndex = PAlarmView.this.mySortedAlarmModel.getOriginalIndex(currentSelectedEntry);
                    PAlarmView.this.myCurrentSelectedEntry = PAlarmView.this.myAlarmTableModel.getEntry(currentSelectedEntryIndex);
                    PAlarmView.this.myControl.getDetailsViewController().alarmSelectedNotify(PAlarmView.this.myCurrentSelectedEntry);
                    PAlarmView.this.setDetailsView(PAlarmView.this.myControl.getDetailsViewController().getDetailsView());
                    if (!PAlarmView.this.myHasFocus) {
                        PAlarmView.this.myControl.alarmSelectionNotify(PAlarmView.this.myCurrentSelectedEntry);
                        PAlarmView.this.myHasFocus = true;
                    }
                }
            }
        });
        this.myAlarmsTable.setSelectionMode(0);
        this.myAlarmsTable.setRowSelectionAllowed(true);
        this.myAlarmsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int currentSelectedEntry = PAlarmView.this.myAlarmsTable.getSelectedRow();
                if (-1 != currentSelectedEntry) {
                    int currentSelectedEntryIndex = PAlarmView.this.mySortedAlarmModel.getOriginalIndex(currentSelectedEntry);
                    PAlarmEntry entry = PAlarmView.this.myAlarmTableModel.getEntry(currentSelectedEntryIndex);
                    if (PAlarmView.this.myCurrentSelectedEntry != null) {
                        PAlarmView.this.myControl.alarmDeselectionNotify(PAlarmView.this.myCurrentSelectedEntry);
                    }
                    PAlarmView.this.myCurrentSelectedEntry = entry;
                    PAlarmView.this.myControl.alarmSelectionNotify(entry);
                }
            }
        });
        this.createAlarmTablePopupMenu();
        JTableHeader tableHeader = this.myAlarmsTable.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        this.myAlarmsTable.setBackground(NetTheme.COLOR_GRAY_15);
        this.myTableScrollPane = new JScrollPane(this.myAlarmsTable);
        this.myTableScrollPane.setHorizontalScrollBarPolicy(31);
        this.myTableScrollPane.setVerticalScrollBarPolicy(20);
        this.myTableScrollPane.setColumnHeaderView(tableHeader);
        this.myTableScrollPane.setPreferredSize(new Dimension(578, 10));
        JPanel alarmLeftPanel = new JPanel(new BorderLayout());
        alarmLeftPanel.add((Component)titleBar, "North");
        alarmLeftPanel.add((Component)this.myTableScrollPane, "Center");
        JScrollPane leftScrollPane = new JScrollPane(alarmLeftPanel);
        leftScrollPane.setHorizontalScrollBarPolicy(30);
        leftScrollPane.setVerticalScrollBarPolicy(21);
        leftScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        leftScrollPane.setMinimumSize(new Dimension(250, 0));
        this.myLeftRightSplit = new JSplitPane(1, leftScrollPane, this.myControl.getDetailsViewController().getDetailsView());
        this.myLeftRightSplit.setResizeWeight(0.5);
        mainPanel.add((Component)this.myLeftRightSplit, "Center");
        this.myLeftRightSplit.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("dividerLocation") && PAlarmView.this.myIsColumnRendererSet) {
                    PAlarmView.this.storeSettings();
                }
            }
        });
        return mainPanel;
    }

    public void setCustomHelpPopupItem(JMenuItem customHelpPopupItem) {
        this.myCustomHelpPopupItem = customHelpPopupItem;
    }

    private void createPopupMenu() {
        this.myPopupMenu = new JPopupMenu();
        this.myCopyPopupItem = new JMenuItem(this.myResourceBundle.getString("PAlarmDetailsView.Copy_Text"));
        this.myCopyPopupItem.setToolTipText(this.myResourceBundle.getString("PAlarmDetailsView.Copy_ToolTipText"));
        this.myShowSourcePopupItem = new JMenuItem(this.myResourceBundle.getString("PAlarmDetailsView.Source_Text"));
        this.myHelpPopupItem = this.createHelpPopupItem();
        this.addSpecificActionsToPopup();
        this.myPopupMenu.add(this.myCopyPopupItem);
        if (this.myControl.getDetailsViewController().isShowSourceVisible()) {
            this.myPopupMenu.addSeparator();
            this.myPopupMenu.add(this.myShowSourcePopupItem);
            this.myShowSourcePopupItem.setEnabled(this.myControl.getDetailsViewController().isShowSourceEnabled());
            this.myShowSourcePopupItem.setToolTipText(this.myResourceBundle.getString(this.myShowSourcePopupItem.isEnabled() ? "PAlarmDetailsView.SourceEnabled_ToolTipText" : "PAlarmDetailsView.SourceDisabled_ToolTipText"));
        }
        this.myPopupMenu.addSeparator();
        this.myPopupMenu.add(this.myHelpPopupItem);
        this.myShowSourcePopupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ActionListener[] listeners = ((PAlarmView)PAlarmView.this).myControl.getDetailsViewController().getDetailsView().mySourceButton.getActionListeners();
                int i = 0;
                while (i < listeners.length) {
                    listeners[i].actionPerformed(null);
                    ++i;
                }
                PAlarmView.this.requestFocusIntoAlarmTable();
            }
        });
        this.myHelpPopupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PAlarmView.this.myControl.alarmHelpRequested(PAlarmView.this.myCurrentSelectedEntry);
            }
        });
        this.myCopyPopupItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    cb.setContents(new StringSelection(PAlarmView.this.myCurrentSelectedEntry.toString()), null);
                }
                catch (Exception e) {
                    PAlarmView.this.myLogger.debug("PAlarmView : the system clipboard is ocupied by other application.");
                }
            }
        });
        this.myPopupMenu.pack();
    }

    private JMenuItem createHelpPopupItem() {
        JMenuItem helpPopupItem;
        if (this.myCustomHelpPopupItem == null) {
            helpPopupItem = new JMenuItem(this.myResourceBundle.getString("HelpAction_Text"), CommonIcons.getHelpIcon());
            helpPopupItem.setToolTipText(this.myResourceBundle.getString("PAlarmDetailsView.Help_ToolTipText"));
        } else {
            helpPopupItem = new JMenuItem(this.myCustomHelpPopupItem.getText(), this.myCustomHelpPopupItem.getIcon());
            helpPopupItem.setToolTipText(this.myCustomHelpPopupItem.getToolTipText());
        }
        return helpPopupItem;
    }

    private void addSpecificActionsToPopup() {
        if (this.myCurrentSelectedEntry != null) {
            for (Action action : this.myCurrentSelectedEntry.getSpecificActions()) {
                JMenuItem specificItem = new JMenuItem(action);
                this.myPopupMenu.add(specificItem);
            }
        }
    }

    private void createAlarmTablePopupMenu() {
        this.myAlarmsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2 && PAlarmView.this.myControl.getDetailsViewController().isShowSourceVisible() && PAlarmView.this.myControl.getDetailsViewController().isShowSourceEnabled()) {
                    PAlarmView.this.myControl.alarmSourceRequest(PAlarmView.this.myCurrentSelectedEntry);
                }
                if (SwingUtilities.isRightMouseButton(event)) {
                    int row = PAlarmView.this.myAlarmsTable.rowAtPoint(event.getPoint());
                    int column = PAlarmView.this.myAlarmsTable.columnAtPoint(event.getPoint());
                    PAlarmView.this.myAlarmsTable.changeSelection(row, column, event.isControlDown(), event.isShiftDown());
                    int selectedRow = PAlarmView.this.myAlarmsTable.getSelectedRow();
                    if (selectedRow != -1) {
                        int currentSelectedEntryIndex = PAlarmView.this.mySortedAlarmModel.getOriginalIndex(selectedRow);
                        PAlarmView.this.myCurrentSelectedEntry = PAlarmView.this.myAlarmTableModel.getEntry(currentSelectedEntryIndex);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (PAlarmView.this.myCurrentSelectedEntry == null || PAlarmView.this.myAlarmsTable.rowAtPoint(event.getPoint()) == -1) {
                    return;
                }
            }
        });
    }

    private JPanel createAlarmsTitleBar() {
        this.myAlarmTitleBar = new JPanel(new GridBagLayout());
        this.myViewIconLabel = new JLabel();
        this.myViewIconLabel.setHorizontalAlignment(0);
        this.myAlarmTitle = PLabel.createHeader();
        this.myAlarmTitle.setName("PAlarmView.Title");
        this.myActiveAlarmsLabel = new ItemCountLabel();
        this.myActiveAlarmsLabel.setText(this.myResourceBundle.getString("Common.Active_Text"));
        this.myActiveAlarmsLabel.setPreferredSize(new Dimension(ACTIVE_ALARMS_LABEL_WIDTH, ScaleUtils.scale(ACTIVE_ALARMS_LABEL_HEIGHT)));
        this.myActiveAlarmsLabel.setItemCount(0);
        this.myActiveAlarmsLabel.setVisible(false);
        this.myNewAlarmLabel = new PLabel(this.myResourceBundle.getString("PAlarmView.NewAlarm_Text"), CommonIcons.getWarningIcon(), 2);
        this.myNewAlarmLabel.setVisible(false);
        this.myNewAlarmPlaceHolder = new JPanel();
        this.myAllHiddenLabel = new PLabel(this.myResourceBundle.getString("PAlarmView.AllHidden_Text"));
        this.myAllHiddenLabel.setVisible(false);
        this.myAllHiddenLabel.setPreferredSize(new Dimension(HIDDEN_ALARMS_LABEL_WIDTH, ACTIVE_ALARMS_LABEL_HEIGHT));
        this.myAllHiddenPlaceHolder = new JPanel();
        JPanel filteringToolbar = this.createFilteringToolbar();
        this.myHistoryButton = new PToggleToolButton();
        this.myHistoryButton.setName("PAlarmView.History");
        this.myHistoryButton.setFocusable(false);
        this.myHistoryButton.setToolTipText(this.myResourceBundle.getString("PAlarmView.HistoryUnFiltered_ToolTipText"));
        this.myHistoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PAlarmView.this.showClearedAlarms(PAlarmView.this.myHistoryButton.isSelected());
            }
        });
        this.mySaveButton = new PToolButton(CommonIcons.getSaveAsIcon());
        this.mySaveButton.setName("PAlarmView.SaveButton");
        this.mySaveButton.setFocusable(false);
        this.mySaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PAlarmView.this.saveAlarms();
            }
        });
        this.myFilteringCriteria.myFilterClearedAlarms = true;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.myAlarmTitleBar.add((Component)this.myViewIconLabel, constraints);
        constraints.gridx = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 12, 2, 0);
        this.myAlarmTitleBar.add((Component)this.myAlarmTitle, constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 2;
        constraints.insets = new Insets(5, 10, 2, 0);
        this.myAlarmTitleBar.add((Component)this.myActiveAlarmsLabel, constraints);
        constraints.weightx = 0.0;
        constraints.gridx = 3;
        constraints.insets = new Insets(5, 12, 2, 0);
        this.myAlarmTitleBar.add((Component)this.myNewAlarmLabel, constraints);
        this.myAlarmTitleBar.add((Component)this.myNewAlarmPlaceHolder, constraints);
        constraints.insets = new Insets(1, 18, 1, 0);
        constraints.gridx = 4;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        this.myAlarmTitleBar.add((Component)filteringToolbar, constraints);
        constraints.insets = new Insets(1, 1, 1, 0);
        constraints.gridx = 5;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        this.myAlarmTitleBar.add((Component)this.myAllHiddenLabel, constraints);
        this.myAlarmTitleBar.add((Component)this.myAllHiddenPlaceHolder, constraints);
        constraints.insets = new Insets(4, 20, 1, 17);
        constraints.gridx = 6;
        constraints.weightx = 0.0;
        this.myAlarmTitleBar.add((Component)this.myHistoryButton, constraints);
        this.myHistoryButton.setBackground(this.myHistoryButton.getParent().getBackground());
        constraints.insets = new Insets(4, 0, 1, 0);
        constraints.gridx = 7;
        constraints.weightx = 0.0;
        this.myAlarmTitleBar.add((Component)this.createCustomComponentPanel(), constraints);
        constraints.gridx = 8;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(4, 0, 1, 0);
        constraints.anchor = 13;
        this.myAlarmTitleBar.add((Component)this.mySaveButton, constraints);
        return this.myAlarmTitleBar;
    }

    private JPanel createFilteringToolbar() {
        ArrayList<JToggleButton> filteringToolButtons = new ArrayList<JToggleButton>();
        JPanel filteringToolPanel = new JPanel(new FlowLayout(1, 5, 0));
        filteringToolPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.myFilteringTitle = new PLabel();
        this.myFilteringTitle.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.myFilteringTitle.setName("PAlarmView.Filtering");
        filteringToolPanel.add(this.myFilteringTitle);
        this.myWarningButton = new JToggleButton(CommonIcons.getWarningAlarmIcon());
        this.myWarningButton.setRolloverIcon(this.myWarningButton.getIcon());
        this.myWarningButton.setName("PAlarmView.FilterWarning");
        this.myWarningButton.setFocusable(false);
        this.myWarningButton.setSelected(true);
        this.myWarningButton.setToolTipText(this.myResourceBundle.getString("PAlarmView.Warning_ToolTipText"));
        this.myFilteringCriteria.myFilterWarningAlarms = false;
        this.myWarningButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PAlarmView.this.showWarnings(!PAlarmView.this.myWarningButton.isSelected());
            }
        });
        filteringToolButtons.add(this.myWarningButton);
        this.myMinorButton = new JToggleButton(CommonIcons.getMinorAlarmIcon());
        this.myMinorButton.setRolloverIcon(this.myMinorButton.getIcon());
        this.myMinorButton.setName("PAlarmView.FilterMinor");
        this.myMinorButton.setSelected(true);
        this.myFilteringCriteria.myFilterMinorAlarms = false;
        this.myMinorButton.setFocusable(false);
        this.myMinorButton.setToolTipText(this.myResourceBundle.getString("PAlarmView.MinorAlarm_ToolTipText"));
        this.myMinorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PAlarmView.this.showMinorAlarms(!PAlarmView.this.myMinorButton.isSelected());
            }
        });
        filteringToolButtons.add(this.myMinorButton);
        this.myMajorButton = new JToggleButton(CommonIcons.getMajorAlarmIcon());
        this.myMajorButton.setRolloverIcon(this.myMajorButton.getIcon());
        this.myMajorButton.setName("PAlarmView.FilterMajor");
        this.myMajorButton.setFocusable(false);
        this.myMajorButton.setSelected(true);
        this.myMajorButton.setToolTipText(this.myResourceBundle.getString("PAlarmView.MajorAlarm_ToolTipText"));
        this.myFilteringCriteria.myFilterMajorAlarms = false;
        this.myMajorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PAlarmView.this.showMajorAlarms(!PAlarmView.this.myMajorButton.isSelected());
            }
        });
        filteringToolButtons.add(this.myMajorButton);
        this.myCriticalButton = new JToggleButton(CommonIcons.getCriticalAlarmIcon());
        this.myCriticalButton.setRolloverIcon(this.myCriticalButton.getIcon());
        this.myCriticalButton.setName("PAlarmView.FilterCritical");
        this.myCriticalButton.setFocusable(false);
        this.myCriticalButton.setSelected(true);
        this.myCriticalButton.setToolTipText(this.myResourceBundle.getString("PAlarmView.CriticalAlarm_ToolTipText"));
        this.myFilteringCriteria.myFilterCriticalAlarms = false;
        this.myCriticalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PAlarmView.this.showCriticalAlarms(!PAlarmView.this.myCriticalButton.isSelected());
            }
        });
        filteringToolButtons.add(this.myCriticalButton);
        filteringToolPanel.add(new TabButtonPanel(filteringToolButtons, false));
        return filteringToolPanel;
    }

    private class AdjustedBorder
    extends BaseBorder {
        private int xCoord;

        public AdjustedBorder(int x) {
            super(1, 4, 1, 4);
            this.xCoord = x;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JComponent jComp = (JComponent)c;
            boolean focused = Boolean.TRUE.equals(jComp.getClientProperty("Table.hasFocus"));
            if (focused) {
                Object oldAa = NetUtils.antiAliasingOn(g);
                Color outline = UIManager.getColor("Table.editorBorder");
                Rectangle rect = new Rectangle(this.xCoord, 0, c.getWidth() - 2, c.getHeight() - 1);
                outline = NetLookAndFeel.getFocusColor();
                g.setColor(outline);
                ((Graphics2D)g).draw(rect);
                NetUtils.setAntialiasing(g, oldAa);
            }
        }
    }

    private class CalendarDateStringConverter
    extends StringConverter {
        private CalendarDateStringConverter() {
        }

        @Override
        public String toString(Object value, int rowIndex, int columnIndex, TableModel model) {
            if (columnIndex == 1) {
                Calendar cal = (Calendar)value;
                return String.valueOf(PAlarmUtils.getTimeStamp(cal)) + " " + PAlarmView.this.myResourceBundle.getString("PAlarmView.TimeStamp_PcTime_Text");
            }
            return value != null ? value.toString() : "";
        }
    }

    private final class ColumnRenderer
    extends PTableCellRenderer {
        private final JTable myTable;
        private final String myCriticalText;
        private final String myMajorText;
        private final String myMinorText;
        private final String myWarningText;
        private final String myTransientText;
        private final Icon myCriticalIcon;
        private final Icon myClearedAlarmIcon;
        private final Icon myMajorIcon;
        private final Icon myMinorIcon;
        private final Icon myWarningIcon;
        private final Icon myTransientIcon;
        private final Color myGreyColor;
        private Icon myCriticalTogglingIcon;
        private Icon myMajorTogglingIcon;
        private Icon myMinorTogglingIcon;
        private Icon myWarningTogglingIcon;
        private int mySeverity = -1;
        private boolean myActive = false;
        private int myColumn = -1;

        private ColumnRenderer(JTable table) {
            this.myTable = table;
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.myCriticalText = PAlarmView.this.myResourceBundle.getString("Common.CriticalError_Text");
            this.myMajorText = PAlarmView.this.myResourceBundle.getString("Common.MajorError_Text");
            this.myMinorText = PAlarmView.this.myResourceBundle.getString("Common.MinorError_Text");
            this.myWarningText = PAlarmView.this.myResourceBundle.getString("Common.WarningError_Text");
            this.myTransientText = PAlarmView.this.myResourceBundle.getString("PAlarmView.Transient_Text");
            this.myCriticalIcon = this.getPaddedIcon(CommonIcons.getCriticalAlarmIcon());
            this.myMajorIcon = this.getPaddedIcon(CommonIcons.getMajorAlarmIcon());
            this.myMinorIcon = this.getPaddedIcon(CommonIcons.getMinorAlarmIcon());
            this.myWarningIcon = this.getPaddedIcon(CommonIcons.getWarningAlarmIcon());
            this.myClearedAlarmIcon = this.getPaddedIcon(CommonIcons.getOkayAlarmIcon());
            this.myCriticalTogglingIcon = this.getPaddedIcon(PAlarmView.this.myResourceBundle.getImageIcon("TogglingCriticalAlarm_Icon"));
            this.myMajorTogglingIcon = this.getPaddedIcon(PAlarmView.this.myResourceBundle.getImageIcon("TogglingMajorAlarm_Icon"));
            this.myMinorTogglingIcon = this.getPaddedIcon(PAlarmView.this.myResourceBundle.getImageIcon("TogglingMinorAlarm_Icon"));
            this.myWarningTogglingIcon = this.getPaddedIcon(PAlarmView.this.myResourceBundle.getImageIcon("TogglingWarningAlarm_Icon"));
            this.myTransientIcon = this.getPaddedIcon(PAlarmView.this.myResourceBundle.getImageIcon("PAlarmView.Transient_Icon"));
            this.myGreyColor = new Color(153, 153, 153);
        }

        private Icon getPaddedIcon(Icon icon) {
            return new CompoundIcon(25, 20, icon, 4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            this.mySeverity = -1;
            this.myColumn = column;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            PAlarmEntry entry = null;
            int actualRow = PAlarmView.this.mySortedAlarmModel.getOriginalIndex(row);
            entry = PAlarmView.this.myAlarmTableModel.getEntry(actualRow);
            this.myActive = entry.isActive();
            boolean isTransient = entry.isAlarmTransient();
            boolean isToggling = entry.isAlarmToggling();
            switch (column) {
                case 0: {
                    this.mySeverity = (Integer)value;
                    this.setSuitableIcon(this.mySeverity, this.myActive, isTransient, isToggling);
                    this.setIconTextGap(2);
                    this.setHorizontalAlignment(2);
                    this.setBorder(new AdjustedBorder(1));
                    break;
                }
                case 1: {
                    Calendar cal = (Calendar)value;
                    if (entry.getTimingSource() == 0) {
                        this.setText(PAlarmUtils.getTimeStamp(cal));
                    } else if (entry.getTimingSource() == 1) {
                        this.setText(String.valueOf(PAlarmUtils.getTimeStamp(cal)) + " " + PAlarmView.this.myResourceBundle.getString("PAlarmView.TimeStamp_PcTime_Text"));
                    }
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 2: {
                    this.setText((String)value);
                    this.setHorizontalAlignment(2);
                    break;
                }
                case 3: {
                    this.setBorder(new AdjustedBorder(0));
                    this.setText((String)value);
                    this.setHorizontalAlignment(2);
                    break;
                }
                default: {
                    this.setText((String)value);
                    this.setHorizontalAlignment(2);
                }
            }
            if (PAlarmView.this.myCurrentSelectedEntry != null && PAlarmView.this.myCurrentSelectedEntry.equals(PAlarmView.this.myAlarmTableModel.getEntry(PAlarmView.this.mySortedAlarmModel.getOriginalIndex(row))) && !PAlarmView.this.myAlarmsTable.isRowSelected(row)) {
                PAlarmView.this.myAlarmsTable.addRowSelectionInterval(row, row);
                PAlarmView.this.myControl.getDetailsViewController().refreshView(PAlarmView.this.myCurrentSelectedEntry);
                if (PAlarmView.this.myHasFocus) {
                    PAlarmView.this.myControl.alarmSelectionNotify(PAlarmView.this.myCurrentSelectedEntry);
                }
            }
            if (isSelected) {
                this.setForeground(NetLookAndFeel.getWhite());
            } else if (!this.myActive) {
                this.setForeground(this.myGreyColor);
            } else {
                this.setForeground(NetLookAndFeel.getControlInfo());
            }
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Color[] stripe = this.getStripeColors();
            if (stripe != null) {
                GradientUtils.drawVerticalGradient((JComponent)this, g, stripe, 0, 0, 10, this.getHeight() - 1);
            }
        }

        private Color[] getStripeColors() {
            if (!this.myActive && this.myColumn == 0) {
                return CLEARED_STRIPE;
            }
            switch (this.mySeverity) {
                case 3: {
                    return CRITICAL_STRIPE;
                }
                case 2: {
                    return MAJOR_STRIPE;
                }
                case 1: {
                    return MINOR_STRIPE;
                }
                case 0: {
                    return WARNING_STRIPE;
                }
            }
            return null;
        }

        private void setSuitableIcon(int severity, boolean isActive, boolean isTransient, boolean isToggling) {
            switch (severity) {
                case 3: {
                    if (isActive) {
                        this.setIcon(isToggling ? this.myCriticalTogglingIcon : this.myCriticalIcon);
                    } else {
                        this.setIcon(this.myClearedAlarmIcon);
                    }
                    this.setText(this.myCriticalText);
                    break;
                }
                case 2: {
                    if (isActive) {
                        this.setIcon(isToggling ? this.myMajorTogglingIcon : this.myMajorIcon);
                    } else {
                        this.setIcon(this.myClearedAlarmIcon);
                    }
                    this.setText(this.myMajorText);
                    break;
                }
                case 1: {
                    if (isActive) {
                        this.setIcon(isToggling ? this.myMinorTogglingIcon : this.myMinorIcon);
                    } else {
                        this.setIcon(this.myClearedAlarmIcon);
                    }
                    this.setText(this.myMinorText);
                    break;
                }
                case 0: {
                    if (isTransient) {
                        this.setIcon(this.myTransientIcon);
                        this.setText(this.myTransientText);
                        break;
                    }
                    if (isActive) {
                        this.setIcon(isToggling ? this.myWarningTogglingIcon : this.myWarningIcon);
                    } else {
                        this.setIcon(this.myClearedAlarmIcon);
                    }
                    this.setText(this.myWarningText);
                    break;
                }
            }
        }

        protected int countSeverityColumnMaxWidth() {
            int width = Math.max(this.myTable.getGraphics().getFontMetrics().stringWidth(PAlarmView.this.myResourceBundle.getString("Common.MajorError_Text")), this.myTable.getGraphics().getFontMetrics().stringWidth(PAlarmView.this.myResourceBundle.getString("Common.MinorError_Text")));
            width = Math.max(width, this.myTable.getGraphics().getFontMetrics().stringWidth(PAlarmView.this.myResourceBundle.getString("Common.CriticalError_Text")));
            width = Math.max(width, this.myTable.getGraphics().getFontMetrics().stringWidth(PAlarmView.this.myResourceBundle.getString("Common.WarningError_Text")));
            width = Math.max(width, this.myTable.getGraphics().getFontMetrics().stringWidth(PAlarmView.this.myResourceBundle.getString("PAlarmView.Transient_Text")));
            width += PAlarmView.this.myResourceBundle.getImageIcon("WarningAlarm_Icon").getIconWidth();
            width = Math.max(width, this.myTable.getGraphics().getFontMetrics().stringWidth(PAlarmView.this.myResourceBundle.getString("PAlarmView.Column.Severity_Text")) + PAlarmView.this.myResourceBundle.getImageIcon("PAlarmView.SortAscending_Icon").getIconWidth() + 4 + 4);
            return width + 13;
        }
    }

    private class NewAlarmTimer
    extends Timer {
        public NewAlarmTimer() {
            super(NEW_ALARM_NOTIFICATION_TIME, new NewAlarmTimerTask());
            this.setCoalesce(true);
            this.setRepeats(false);
        }

        protected void newAlarmReceived() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PAlarmView.this.myNewAlarmLabel.setVisible(true);
                }
            });
            try {
                this.restart();
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PAlarmView.this.myNewAlarmLabel.setVisible(false);
                    }
                });
            }
        }
    }

    private class NewAlarmTimerTask
    implements ActionListener {
        private NewAlarmTimerTask() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PAlarmView.this.myNewAlarmLabel.setVisible(false);
        }
    }

    private final class ViewRefresher
    implements Runnable {
        private final List<PAlarmEntry> myAlarms;

        private ViewRefresher(List<PAlarmEntry> alarms) {
            this.myAlarms = alarms;
        }

        @Override
        public void run() {
            PAlarmView.this.myAlarmTableModel.setContents(this.myAlarms);
            PAlarmView.this.updateActiveAlarmsText();
            if (this.myAlarms == null) {
                return;
            }
            if (PAlarmView.this.myCurrentSelectedEntry != null) {
                int index = this.myAlarms.indexOf(PAlarmView.this.myCurrentSelectedEntry);
                if (-1 != index) {
                    int selectedIndex = PAlarmView.this.myAlarmsTable.getSelectedRow();
                    if (-1 != selectedIndex) {
                        PAlarmView.this.myAlarmsTable.setRowSelectionInterval(selectedIndex, selectedIndex);
                        PAlarmView.this.myControl.alarmSelectionNotify(PAlarmView.this.myCurrentSelectedEntry);
                    }
                } else {
                    PAlarmView.this.myControl.getDetailsViewController().resetViewToDefault();
                    PAlarmView.this.myControl.alarmDeselectionNotify(PAlarmView.this.myCurrentSelectedEntry);
                }
            }
            PAlarmView.this.updateHiddenAlarmsText(this.myAlarms.size());
            if (this.myAlarms.isEmpty()) {
                PAlarmView.this.myNewAlarmLabel.setVisible(false);
                PAlarmView.this.myControl.getDetailsViewController().getDetailsView().setShowSourceEnabled(false);
            }
        }
    }
}

