/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.alarmsview;

import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.services.alarmsview.AlarmTextFormatter;
import com.nokia.em.poseidon.services.alarmsview.PAlarmFileWriter;
import com.nokia.em.poseidon.services.alarmsview.PFilteringCriteria;
import com.nokia.em.poseidon.util.helper.FileWriterHelper;
import com.nokia.em.poseidon.util.helper.WriterInterFace;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class PDefaultAlarmFileWriter
implements PAlarmFileWriter,
WriterInterFace {
    private static final String PATH_NODE = "Path";
    private static PDefaultAlarmFileWriter theInstance = new PDefaultAlarmFileWriter();
    private int myMaxLineLength;
    private FileWriterHelper myFileWriterHelper;
    private String myTitle;
    private PrintWriter myWriter;
    private int[] myColumnLength;
    private ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());
    private Map<String, List<String>> myCustomizedPrintableColumns;

    private PDefaultAlarmFileWriter() {
    }

    public static PDefaultAlarmFileWriter getInstance() {
        return theInstance;
    }

    @Override
    public void saveAlarmsRequest(OutputStream outputStream, List<PAlarmEntry> alarms, String siteName, PFilteringCriteria criteria, boolean noAlarms) {
        this.initColumnLengths(alarms);
        this.myMaxLineLength = this.defineTableWidth();
        this.initializeFields(outputStream, this.myResourceBundle.getString("PDefaultAlarmFileWriter.ReportHeader_Text"));
        this.myFileWriterHelper = new FileWriterHelper(this);
        this.writeHeader(alarms);
        if (noAlarms) {
            this.myWriter.println(this.myResourceBundle.getString("PDefaultAlarmFileWriter.NoAlarms_Text"));
            this.myWriter.println();
        } else {
            this.writeAlarmHeaders(this.myMaxLineLength);
        }
        for (PAlarmEntry alarm : alarms) {
            this.writeAlarm(alarm);
        }
        this.myWriter.println();
        this.writeFooter();
        this.myWriter.flush();
        this.myWriter.close();
    }

    private void writeAlarm(PAlarmEntry alarm) {
        this.myWriter.print(this.addIndention(0, alarm.serverityToString()));
        this.myWriter.print(this.addIndention(1, AlarmTextFormatter.formatAlarmTimeStamp(alarm)));
        this.myWriter.print(this.addIndention(2, alarm.getDescription()));
        this.myWriter.print(this.addIndention(3, alarm.getSource()));
        this.myWriter.print(this.addIndention(4, AlarmTextFormatter.formatAlarmState(alarm)));
        this.myWriter.print(this.addIndention(5, AlarmTextFormatter.formatAlarmClearTime(alarm)));
        this.myWriter.print(this.addIndention(6, String.valueOf(alarm.getAlarmCode()) + " " + (alarm.getAlarmScope() != null ? alarm.getAlarmScope() : "")));
        this.writeAdditionalInformation(alarm.getAdditionalInformationPrintValue() == null ? "" : alarm.getAdditionalInformationPrintValue());
        int i = 8;
        for (String key : this.myCustomizedPrintableColumns.keySet()) {
            if (alarm.getPrintableValues().containsKey(key)) {
                if (key.equals(PATH_NODE)) {
                    this.writeAdditionalAttributes(this.addIndention(i, alarm.getPrintableValues().get(key)), i);
                } else {
                    this.myWriter.print(this.addIndention(i, alarm.getPrintableValues().get(key)));
                }
            } else {
                this.myWriter.print(this.addIndention(i, ""));
            }
            ++i;
        }
        this.myWriter.println();
    }

    private void writeAdditionalInformation(String additionalInfo) {
        if (additionalInfo == null) {
            return;
        }
        int columnPosition = this.getColumnPosition(7);
        String[] subInfo = additionalInfo.split(System.getProperty("line.separator"));
        int infoIndex = 0;
        while (infoIndex < subInfo.length) {
            if (infoIndex > 0) {
                this.myWriter.println();
                int position = 0;
                while (position < columnPosition) {
                    this.myWriter.print(" ");
                    ++position;
                }
            }
            this.myWriter.print(this.addIndention(7, subInfo[infoIndex]));
            ++infoIndex;
        }
    }

    private void writeAdditionalAttributes(String additionalAttributes, int column) {
        if (additionalAttributes == null) {
            return;
        }
        int columnPosition = this.getColumnPosition(column);
        String[] subInfo = additionalAttributes.split(System.getProperty("line.separator"));
        int infoIndex = 0;
        while (infoIndex < subInfo.length) {
            if (infoIndex > 0) {
                this.myWriter.println();
                int position = 0;
                while (position < columnPosition) {
                    this.myWriter.print(" ");
                    ++position;
                }
            }
            this.myWriter.print(this.addIndention(column, subInfo[infoIndex]));
            ++infoIndex;
        }
    }

    private int getColumnPosition(int col) {
        int position = 0;
        int i = 0;
        while (i < col && col <= this.myColumnLength.length) {
            position += this.myColumnLength[i];
            ++i;
        }
        return position;
    }

    private void writeAlarmHeaders(int width) {
        this.myWriter.print(this.addIndention(0, this.myResourceBundle.getString("PAlarmView.Column.Severity_Text")));
        this.myWriter.print(this.addIndention(1, this.myResourceBundle.getString("PDefaultAlarmFileWriter.Time_Text")));
        this.myWriter.print(this.addIndention(2, this.myResourceBundle.getString("PAlarmView.Column.Description_Text")));
        this.myWriter.print(this.addIndention(3, this.myResourceBundle.getString("PDefaultAlarmFileWriter.Source_Text")));
        this.myWriter.print(this.addIndention(4, this.myResourceBundle.getString("PDefaultAlarmFileWriter.Status_Text")));
        this.myWriter.print(this.addIndention(5, this.myResourceBundle.getString("PDefaultAlarmFileWriter.ClearTime_Text")));
        this.myWriter.print(this.addIndention(6, this.myResourceBundle.getString("PAlarmDetailsView.ReportedAlarm_Text")));
        this.myWriter.print(this.addIndention(7, this.myResourceBundle.getString("PAlarmDetailsView.Addtional_Information")));
        int i = 8;
        for (String key : this.myCustomizedPrintableColumns.keySet()) {
            this.myWriter.print(this.addIndention(i, key));
            ++i;
        }
        this.myWriter.println();
        int index = 0;
        while (index < width) {
            this.myWriter.print("-");
            ++index;
        }
        this.myWriter.println();
    }

    private int defineTableWidth() {
        return this.getColumnPosition(this.myColumnLength.length);
    }

    private String addIndention(int column, String text) {
        String textToAdd = text == null ? "" : text;
        StringBuilder indention = new StringBuilder();
        indention.append(textToAdd);
        int indentionInt = this.myColumnLength[column] - textToAdd.length();
        int index = 0;
        while (index < indentionInt) {
            indention.append(" ");
            ++index;
        }
        return indention.toString();
    }

    private void writeHeader(List<PAlarmEntry> alarms) {
        this.myFileWriterHelper.writeHeaderByRow(this.myResourceBundle.getString("PDefaultAlarmFileWriter.ReportHeader_Text"), alarms.size() > 0 ? MessageFormat.format(this.myResourceBundle.getString("PDefaultAlarmFileWriter.ReportSubHeader_Text"), AlarmTextFormatter.formatAlarmReportSubHeader(alarms)) : "");
    }

    private void writeFooter() {
        this.myFileWriterHelper.writeFooter();
    }

    private void initColumnLengths(List<PAlarmEntry> alarms) {
        this.myCustomizedPrintableColumns = new LinkedHashMap<String, List<String>>();
        for (PAlarmEntry alarm : alarms) {
            for (String key : alarm.getPrintableValues().keySet()) {
                if (this.myCustomizedPrintableColumns.containsKey(key)) {
                    this.myCustomizedPrintableColumns.get(key).add(alarm.getPrintableValues().get(key));
                    continue;
                }
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(alarm.getPrintableValues().get(key));
                this.myCustomizedPrintableColumns.put(key, valueList);
            }
        }
        this.myColumnLength = new int[8 + this.myCustomizedPrintableColumns.keySet().size()];
        this.myColumnLength[0] = this.myResourceBundle.getString("PAlarmView.Column.Severity_Text").length();
        this.myColumnLength[1] = this.myResourceBundle.getString("PDefaultAlarmFileWriter.Time_Text").length();
        this.myColumnLength[2] = this.myResourceBundle.getString("PAlarmView.Column.Description_Text").length();
        this.myColumnLength[3] = this.myResourceBundle.getString("PDefaultAlarmFileWriter.Source_Text").length();
        this.myColumnLength[4] = this.myResourceBundle.getString("PDefaultAlarmFileWriter.Status_Text").length();
        this.myColumnLength[5] = this.myResourceBundle.getString("PDefaultAlarmFileWriter.ClearTime_Text").length();
        this.myColumnLength[6] = this.myResourceBundle.getString("PAlarmDetailsView.ReportedAlarm_Text").length();
        this.myColumnLength[7] = this.myResourceBundle.getString("PAlarmDetailsView.Addtional_Information").length();
        int i = 8;
        for (String key : this.myCustomizedPrintableColumns.keySet()) {
            int lenght = key.length();
            for (String value : this.myCustomizedPrintableColumns.get(key)) {
                lenght = key.equals(PATH_NODE) ? Math.max(lenght, this.calculatePathMaxStringSize(value)) : Math.max(lenght, value.length());
            }
            this.myColumnLength[i] = lenght + 3;
            ++i;
        }
        for (PAlarmEntry alarm : alarms) {
            this.updateColumnLengths(alarm);
        }
        this.addIndentForColumns();
    }

    private void addIndentForColumns() {
        this.myColumnLength[0] = this.myColumnLength[0] + 3;
        this.myColumnLength[1] = this.myColumnLength[1] + 3;
        this.myColumnLength[2] = this.myColumnLength[2] + 3;
        this.myColumnLength[3] = this.myColumnLength[3] + 3;
        this.myColumnLength[4] = this.myColumnLength[4] + 3;
        this.myColumnLength[5] = this.myColumnLength[5] + 3;
        this.myColumnLength[6] = this.myColumnLength[6] + 3;
        this.myColumnLength[7] = this.myColumnLength[7] + 3;
    }

    private void updateColumnLengths(PAlarmEntry alarm) {
        this.updateColumnLength(0, alarm.serverityToString());
        this.updateColumnLength(1, AlarmTextFormatter.formatAlarmTimeStamp(alarm));
        this.updateColumnLength(2, alarm.getDescription());
        this.updateColumnLength(3, alarm.getSource());
        this.updateColumnLength(4, AlarmTextFormatter.formatAlarmState(alarm));
        this.updateColumnLength(5, AlarmTextFormatter.formatAlarmClearTime(alarm));
        this.updateColumnLength(6, String.valueOf(alarm.getAlarmCode()) + " " + (alarm.getAlarmScope() != null ? alarm.getAlarmScope() : ""));
        this.updateColumnLength(7, alarm.getAdditionalInformationPrintValue() == null ? "" : alarm.getAdditionalInformationPrintValue());
    }

    private void updateColumnLength(int column, String text) {
        if (text == null) {
            return;
        }
        int maxLength = 0;
        String[] subTexts = text.split(System.getProperty("line.separator"));
        int index = 0;
        while (index < subTexts.length) {
            if (maxLength < subTexts[index].length()) {
                maxLength = subTexts[index].length();
            }
            ++index;
        }
        this.myColumnLength[column] = Math.max(this.myColumnLength[column], maxLength);
    }

    public void initializeFields(OutputStream outputStream, String title) {
        this.myWriter = new PrintWriter(outputStream);
        this.myTitle = title;
    }

    @Override
    public PrintWriter getWriter() {
        return this.myWriter;
    }

    @Override
    public String getTitle() {
        return this.myTitle;
    }

    private int calculatePathMaxStringSize(String value) {
        int maxLength = 0;
        String[] subTexts = value.split(System.getProperty("line.separator"));
        int index = 0;
        while (index < subTexts.length) {
            if (maxLength < subTexts[index].length()) {
                maxLength = subTexts[index].length();
            }
            ++index;
        }
        return maxLength;
    }
}

