/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.alarmsview;

import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.print.PPrintHelper;
import com.nokia.em.poseidon.frameworks.print.PPrintTable;
import com.nokia.em.poseidon.frameworks.print.PPrintText;
import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import com.nokia.em.poseidon.frameworks.print.PPrintableDoc;
import com.nokia.em.poseidon.frameworks.print.PPrintableSection;
import com.nokia.em.poseidon.services.alarmsview.AlarmTextFormatter;
import com.nokia.em.poseidon.services.alarmsview.PAlarmPrinter;
import com.nokia.em.poseidon.services.alarmsview.PFilteringCriteria;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;

public class PDefaultAlarmPrinter
extends PPrintableDoc
implements PAlarmPrinter,
PPrintableSection {
    static final int PRINTABLE_FIELDS = 8;
    private List<PAlarmEntry> myPAlarmEntryList = Collections.synchronizedList(new ArrayList());
    private ResourceBundle myResourceBundle;
    private boolean myNoAlarms;
    private JTable myAlarmTable;
    private PPrintHelper myPrintHelper;
    private String myReportName;
    private static final PPrintText.ALIGN myAlignment = PPrintText.ALIGN.CENTER;
    private List<String> myCustomizedPrintableColumns;

    public PDefaultAlarmPrinter(List<PAlarmEntry> alarmList, String siteName, PFilteringCriteria criteria, boolean noAlarms) {
        this.myPAlarmEntryList.addAll(alarmList);
        this.myNoAlarms = noAlarms;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myPrintHelper = new PPrintHelper(this);
        this.myReportName = this.myResourceBundle.getString("PDefaultAlarmPrinter.ReportTitle_Text");
    }

    @Override
    public void setAlarmList(List<PAlarmEntry> alarmList) {
        this.myPAlarmEntryList.clear();
        this.myPAlarmEntryList.addAll(alarmList);
    }

    @Override
    public void doPrinting() {
        this.createAlarmsPrintOut();
    }

    @Override
    public PPrintableArea createPageHeader() {
        StringBuilder headerSecondRow = new StringBuilder();
        headerSecondRow.append(AlarmTextFormatter.formatAlarmReportSubHeader(this.myPAlarmEntryList));
        if (headerSecondRow.length() > 0) {
            headerSecondRow.append(" ");
            headerSecondRow.append(this.myResourceBundle.getString("PAlarmPrinter.AlarmsPrinted_Text"));
        }
        PPrintText secondRowText = new PPrintText(headerSecondRow.toString(), this);
        secondRowText.setAlignment(myAlignment);
        this.myPrintHelper.addHeaderRow(secondRowText);
        return this.myPrintHelper.createPageHeader(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAlarmsPrintOut() {
        this.setPageHeader(this.createPageHeader());
        if (this.myNoAlarms) {
            this.add(new PPrintText(this.myResourceBundle.getString("PDefaultAlarmFileWriter.NoAlarms_Text"), this));
        } else {
            List<PAlarmEntry> list = this.myPAlarmEntryList;
            synchronized (list) {
                this.createAlarmPrintOut();
            }
        }
        this.add(this.createPageFooter());
    }

    private void createAlarmPrintOut() {
        this.initializeCustomizedPrintableColumns();
        Object[] headers = new String[8 + this.myCustomizedPrintableColumns.size()];
        headers[0] = this.myResourceBundle.getString("PAlarmView.Column.Severity_Text");
        headers[1] = this.myResourceBundle.getString("PAlarmPrinter.Time_Text");
        headers[2] = this.myResourceBundle.getString("PAlarmView.Column.Description_Text");
        headers[3] = this.myResourceBundle.getString("PAlarmView.Column.Source_Text");
        headers[4] = this.myResourceBundle.getString("PDefaultAlarmFileWriter.Status_Text");
        headers[5] = this.myResourceBundle.getString("PAlarmPrinter.ClearTime_Text");
        headers[6] = this.myResourceBundle.getString("PAlarmDetailsView.ReportedAlarm_Text");
        headers[7] = this.myResourceBundle.getString("PAlarmDetailsView.Addtional_Information");
        int column = 8;
        Iterator<String> iterator = this.myCustomizedPrintableColumns.iterator();
        while (iterator.hasNext()) {
            String columnName;
            headers[column] = columnName = iterator.next();
            ++column;
        }
        Object[][] alarms = new String[this.myPAlarmEntryList.size()][8 + this.myCustomizedPrintableColumns.size()];
        int i = 0;
        while (i < this.myPAlarmEntryList.size()) {
            alarms[i] = this.createAlarmDataTable(this.myPAlarmEntryList.get(i));
            ++i;
        }
        this.myAlarmTable = new JTable(alarms, headers);
        PPrintTable alarmDataTable = new PPrintTable(this.myAlarmTable.getModel(), (PPrintableArea)this);
        alarmDataTable.setPaintTableHeader(true);
        alarmDataTable.setPaintHeaderLine(true);
        alarmDataTable.setDrawTableLines(false);
        alarmDataTable.setColumnMaxWidth(90);
        alarmDataTable.setCellBottomMarginal(5);
        alarmDataTable.setCellTopMarginal(2);
        alarmDataTable.setCellLeftMarginal(2);
        alarmDataTable.setCellRightMarginal(2);
        this.add(alarmDataTable);
        this.add(new PPrintText(" ", this));
    }

    private String[] createAlarmDataTable(PAlarmEntry alarm) {
        String[] alarmRow = new String[8 + this.myCustomizedPrintableColumns.size()];
        alarmRow[0] = alarm.serverityToString();
        alarmRow[1] = AlarmTextFormatter.formatAlarmTimeStamp(alarm);
        alarmRow[2] = alarm.getDescription();
        alarmRow[3] = alarm.getSource();
        alarmRow[4] = AlarmTextFormatter.formatAlarmState(alarm);
        alarmRow[5] = AlarmTextFormatter.formatAlarmClearTime(alarm);
        alarmRow[6] = String.valueOf(Long.valueOf(alarm.getAlarmCode()).toString()) + " " + (alarm.getAlarmScope() != null ? alarm.getAlarmScope() : "");
        alarmRow[7] = alarm.getAdditionalInformationPrintValue() == null ? "" : alarm.getAdditionalInformationPrintValue();
        int column = 8;
        for (String headerName : this.myCustomizedPrintableColumns) {
            if (alarm.getPrintableValues().containsKey(headerName)) {
                alarmRow[column] = alarm.getPrintableValues().get(headerName);
            }
            ++column;
        }
        return alarmRow;
    }

    private PPrintableArea createPageFooter() {
        return this.myPrintHelper.createPageFooter();
    }

    private void initializeCustomizedPrintableColumns() {
        this.myCustomizedPrintableColumns = new ArrayList<String>();
        for (PAlarmEntry alarm : this.myPAlarmEntryList) {
            for (String label : alarm.getPrintableValues().keySet()) {
                if (this.myCustomizedPrintableColumns.contains(label)) continue;
                this.myCustomizedPrintableColumns.add(label);
            }
        }
    }

    @Override
    public String getReportName() {
        return this.myReportName;
    }

    @Override
    public PPrintText.ALIGN getAlignment() {
        return myAlignment;
    }
}

