/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.appcomm;

import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.appcomm.PCommPathListener;
import com.nokia.em.poseidon.services.appcomm.PCommPathService;
import com.nokia.em.poseidon.services.appcomm.PMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class PCommPathServiceImpl
implements PCommPathService,
Service {
    private Map<String, PCommPathListener> myListeners;
    private Logger myLogger;

    @Override
    public void add(String appName, PCommPathListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener interface can not be null!");
        }
        this.myLogger.debug("Adding new appcomm listener. App: " + appName + ", listener interface: " + listener);
        this.myListeners.put(appName, listener);
    }

    @Override
    public void remove(String appName) {
        this.myLogger.debug("Removing appcomm listener: " + appName);
        this.myListeners.remove(appName);
    }

    @Override
    public List sendToAll(PMessage message) {
        this.myLogger.debug("Sending message to all appcomm listeners. Message: " + message);
        ArrayList<Object> responses = new ArrayList<Object>();
        PCommPathListener senderListener = this.myListeners.get(message.getSenderAppName());
        for (PCommPathListener listener : this.myListeners.values()) {
            if (listener.equals(senderListener)) continue;
            Object response = listener.processMessage(message);
            this.myLogger.debug("Got response " + response + " from listener " + listener);
            responses.add(response);
        }
        return responses;
    }

    @Override
    public Object sendTo(PMessage message, String destAppName) {
        this.myLogger.debug("Sending message to appcomm listener " + destAppName + ". Message: " + message);
        PCommPathListener listener = this.myListeners.get(destAppName);
        if (listener == null) {
            this.myLogger.error("Application " + destAppName + " not found.");
            return null;
        }
        Object response = listener.processMessage(message);
        this.myLogger.debug("Got response " + response);
        return response;
    }

    @Override
    public void start() {
        this.myListeners = new ConcurrentHashMap<String, PCommPathListener>();
        this.myLogger = Logger.getLogger(this.getClass());
        this.myLogger.info("Appcomm service initialized");
    }

    @Override
    public void stop() {
        this.myListeners.clear();
    }
}

