/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.certificate;

import com.nokia.em.poseidon.gui.certificate.CertificateUtils;
import com.nokia.em.poseidon.services.certificate.KeyStoreFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class CertKeyStoreManager {
    private KeyStore myKeyStore;
    private Logger myLogger;
    protected String myKeyStoreFileName = "trustcacerts.jks";
    protected String myKeyStoreFile = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + this.myKeyStoreFileName;
    private char[] myKeyStorePassword = new char[0];

    public CertKeyStoreManager() {
        this.myLogger = Logger.getLogger(this.getClass());
    }

    public boolean initKeyStore(String filePath, char[] password) {
        if (filePath != null) {
            File file = new File(filePath);
            this.myKeyStoreFile = file.isDirectory() ? String.valueOf(filePath) + System.getProperty("file.separator") + this.myKeyStoreFileName : filePath;
        }
        if (password != null) {
            this.myKeyStorePassword = password;
        }
        this.myKeyStore = KeyStoreFactory.initKeyStore(this.myKeyStoreFile, this.myKeyStorePassword);
        return this.myKeyStore != null;
    }

    public KeyStore getKeyStore() {
        if (this.myKeyStore == null) {
            this.myKeyStore = KeyStoreFactory.initKeyStore(this.myKeyStoreFile, this.myKeyStorePassword);
        }
        return this.myKeyStore;
    }

    public boolean saveCertificate(X509Certificate certificate, String alias) throws Exception {
        if (this.myKeyStore == null) {
            this.myKeyStore = KeyStoreFactory.initKeyStore(this.myKeyStoreFile, this.myKeyStorePassword);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.myKeyStoreFile);
            if (alias == null) {
                this.myKeyStore.setCertificateEntry(String.valueOf(certificate.getSerialNumber().toString()) + CertificateUtils.parseFingerprint(certificate), certificate);
            } else {
                this.myKeyStore.setCertificateEntry(alias, certificate);
            }
            this.myKeyStore.store(fos, this.myKeyStorePassword);
            return true;
        }
        catch (Exception e) {
            this.myLogger.debug("Saving certificate to KeyStore failed. " + e);
            throw e;
        }
        finally {
            try {
                fos.close();
                fos = null;
            }
            catch (Exception e) {
                fos = null;
            }
        }
    }

    public List<X509Certificate> getCertificates() {
        if (this.myKeyStore == null) {
            this.myKeyStore = KeyStoreFactory.initKeyStore(this.myKeyStoreFile, this.myKeyStorePassword);
        }
        Enumeration<String> aliases = null;
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        try {
            aliases = this.myKeyStore.aliases();
            String alias = null;
            while (aliases.hasMoreElements()) {
                alias = aliases.nextElement();
                certificates.add((X509Certificate)this.myKeyStore.getCertificate(alias));
            }
        }
        catch (KeyStoreException ex) {
            this.myLogger.debug("Requesting certificate from KeyStore failed. " + ex);
        }
        return certificates;
    }

    public boolean removeCertificate(X509Certificate certificate, String alias) throws Exception {
        if (this.myKeyStore == null) {
            this.myKeyStore = KeyStoreFactory.initKeyStore(this.myKeyStoreFile, this.myKeyStorePassword);
        }
        OutputStream fos = null;
        try {
            fos = new FileOutputStream(this.myKeyStoreFile);
            if (alias == null) {
                this.myKeyStore.deleteEntry(this.myKeyStore.getCertificateAlias(certificate));
            } else {
                this.myKeyStore.deleteEntry(alias);
            }
            this.myKeyStore.store(fos, this.myKeyStorePassword);
            return true;
        }
        catch (KeyStoreException ex) {
            this.myLogger.debug("Removing certificate from KeyStore failed. Keystore is not initialized." + ex);
            throw ex;
        }
        catch (Exception e) {
            this.myLogger.debug("Removing certificate from KeyStore failed. " + e);
            throw e;
        }
        finally {
            try {
                fos.close();
                fos = null;
            }
            catch (Exception e) {
                fos = null;
            }
        }
    }
}

