/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.certificate;

import com.nokia.em.poseidon.gui.certificate.CertificateUtils;
import com.nokia.em.poseidon.services.certificate.CertificateValidator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class CertificateDefaultValidator
implements CertificateValidator {
    protected Exception myDetailedError;
    private static final String TRUST_MANAGER_PROVIDER = "SunX509";
    private static final int BASIC_CONSTRAINTS_NOT_CA_CERT = -1;
    private Map<Integer, X509Certificate[]> mySpecifiedValidationFailures;
    private X509TrustManager myDefaultTrustManager;
    private KeyStore myKeyStore;
    private Logger myLogger = Logger.getLogger(this.getClass());

    public void initTrustManager() {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TRUST_MANAGER_PROVIDER);
            factory.init(this.myKeyStore);
            this.myDefaultTrustManager = (X509TrustManager)factory.getTrustManagers()[0];
        }
        catch (Exception e) {
            this.myLogger.error("Poseidon certificate management trust manager initialization failed." + e);
        }
    }

    protected X509Certificate[] getAcceptedIssuers() {
        return this.myDefaultTrustManager.getAcceptedIssuers();
    }

    private boolean isTrustAnchorInLocalKeyStore(X509Certificate[] chain) {
        boolean trustAnchorFound = false;
        try {
            Enumeration<String> aliases = this.myKeyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this.myKeyStore.getCertificate(alias).equals(chain[chain.length - 1])) continue;
                trustAnchorFound = true;
            }
        }
        catch (KeyStoreException ex) {
            this.myLogger.error("Local key store is not initialized correctly." + ex);
        }
        return trustAnchorFound;
    }

    private boolean chainContainsTrustAnchor(X509Certificate ... x509CertificateArray) {
        int i = 0;
        while (i < x509CertificateArray.length) {
            X509Certificate certificate = x509CertificateArray[i];
            if (certificate.getBasicConstraints() != -1) {
                try {
                    certificate.verify(certificate.getPublicKey());
                    this.myLogger.trace("Root certificate found from chain. ");
                    return true;
                }
                catch (Exception e) {
                    this.myLogger.trace("Not root certificate");
                    this.myLogger.trace("There is CA certificate in chain but it is not root.");
                }
            }
            ++i;
        }
        this.myLogger.warn("Certificate chain doesn't contain trust anchor certificate.");
        return false;
    }

    private void isValidDate(X509Certificate[] certificates) {
        int i = 0;
        while (i < certificates.length) {
            X509Certificate certificate = certificates[i];
            try {
                certificate.checkValidity();
            }
            catch (CertificateExpiredException e) {
                if (certificate.getBasicConstraints() != -1) {
                    this.mySpecifiedValidationFailures.put(1, new X509Certificate[]{certificate});
                    this.myLogger.warn("CA certificate is expired.");
                } else {
                    this.mySpecifiedValidationFailures.put(5, new X509Certificate[]{certificate});
                    this.myLogger.warn("NE certificate is expired.");
                }
            }
            catch (CertificateNotYetValidException e) {
                if (certificate.getBasicConstraints() != -1) {
                    this.mySpecifiedValidationFailures.put(2, new X509Certificate[]{certificate});
                    this.myLogger.warn("CA certificate is not yet valid.");
                }
                this.mySpecifiedValidationFailures.put(6, new X509Certificate[]{certificate});
                this.myLogger.warn("NE certificate is not yet valid.");
            }
            ++i;
        }
    }

    private boolean isCertificateSelfSigned(X509Certificate certificate) {
        try {
            certificate.verify(certificate.getPublicKey());
            this.mySpecifiedValidationFailures.put(7, new X509Certificate[]{certificate});
        }
        catch (Exception e) {
            return false;
        }
        this.myLogger.warn("NE certificate is self-signed. ");
        return true;
    }

    private void isChainBroken(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray.length > 1) {
            int i = 1;
            while (i < x509CertificateArray.length) {
                block6: {
                    try {
                        x509CertificateArray[i - 1].verify(x509CertificateArray[i].getPublicKey());
                    }
                    catch (SignatureException e) {
                        if (!this.mySpecifiedValidationFailures.keySet().contains(12)) {
                            this.mySpecifiedValidationFailures.put(12, x509CertificateArray);
                            this.myLogger.warn("Certificate chain validation failed because invalid signature. Chain is not continuous. " + e);
                        }
                    }
                    catch (Exception e) {
                        if (this.mySpecifiedValidationFailures.keySet().contains(8)) break block6;
                        this.mySpecifiedValidationFailures.put(8, x509CertificateArray);
                        this.myLogger.warn("Certificate chain continuous validation failed because invalid signature. " + e);
                    }
                }
                ++i;
            }
        }
    }

    private void isKeyCertSignKeyUsageSet(X509Certificate ... x509CertificateArray) {
        ArrayList<X509Certificate> invalidCertificates = new ArrayList<X509Certificate>();
        int i = 0;
        while (i < x509CertificateArray.length) {
            if (x509CertificateArray[i].getBasicConstraints() != -1 && !CertificateUtils.checkKeyUsage(x509CertificateArray[i], 5)) {
                invalidCertificates.add(x509CertificateArray[i]);
            }
            ++i;
        }
        if (!invalidCertificates.isEmpty()) {
            this.mySpecifiedValidationFailures.put(13, invalidCertificates.toArray(new X509Certificate[invalidCertificates.size()]));
        }
    }

    private void checkCorrectCertificateVersionsUsed(X509Certificate ... x509CertificateArray) {
        ArrayList<X509Certificate> invalidCertificates = new ArrayList<X509Certificate>();
        int i = 0;
        while (i < x509CertificateArray.length) {
            if (x509CertificateArray[i].getVersion() != 3) {
                invalidCertificates.add(x509CertificateArray[i]);
            }
            ++i;
        }
        if (!invalidCertificates.isEmpty()) {
            this.mySpecifiedValidationFailures.put(14, invalidCertificates.toArray(new X509Certificate[invalidCertificates.size()]));
        }
    }

    @Override
    public Map<Integer, X509Certificate[]> validateCertificateChain(String authType, X509Certificate ... x509CertificateArray) {
        this.mySpecifiedValidationFailures = new HashMap<Integer, X509Certificate[]>();
        if (this.myDefaultTrustManager == null) {
            this.initTrustManager();
        }
        if (this.chainContainsTrustAnchor(x509CertificateArray) && !this.isTrustAnchorInLocalKeyStore(x509CertificateArray)) {
            this.mySpecifiedValidationFailures.put(3, new X509Certificate[]{x509CertificateArray[x509CertificateArray.length - 1]});
        }
        this.isChainBroken(x509CertificateArray);
        this.isValidDate(x509CertificateArray);
        this.isCertificateSelfSigned(x509CertificateArray[0]);
        this.isKeyCertSignKeyUsageSet(x509CertificateArray);
        this.checkCorrectCertificateVersionsUsed(x509CertificateArray);
        if (!this.chainContainsTrustAnchor(x509CertificateArray)) {
            this.mySpecifiedValidationFailures.put(9, x509CertificateArray);
        }
        return this.mySpecifiedValidationFailures;
    }

    @Override
    public void setKeyStore(KeyStore keyStore) {
        this.myKeyStore = keyStore;
        this.initTrustManager();
    }

    @Override
    public Exception getDetailFailingReason() {
        return this.myDetailedError;
    }
}

