/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.certificate;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.event.EventProcessor;
import com.nokia.em.poseidon.frameworks.event.EventTransmitter;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressTask;
import com.nokia.em.poseidon.plugin.application.AppDescription;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.certificate.CertKeyStoreManager;
import com.nokia.em.poseidon.services.certificate.CertificateDefaultValidator;
import com.nokia.em.poseidon.services.certificate.CertificateEventListener;
import com.nokia.em.poseidon.services.certificate.CertificateMediator;
import com.nokia.em.poseidon.services.certificate.CertificateService;
import com.nokia.em.poseidon.services.certificate.CertificateValidator;
import com.nokia.em.poseidon.services.certificate.event.AddCertificateEvent;
import com.nokia.em.poseidon.services.certificate.event.CertificateRemovedEvent;
import com.nokia.em.poseidon.services.certificate.event.CmpKeyUpdateEvent;
import com.nokia.em.poseidon.services.certificate.event.CmpRegenerateCompletedEvent;
import com.nokia.em.poseidon.services.certificate.event.CmpRegenerateRequestEvent;
import com.nokia.em.poseidon.services.certificate.event.CrlUpdateRequestEvent;
import com.nokia.em.poseidon.services.certificate.event.InitializeServiceEvent;
import com.nokia.em.poseidon.services.certificate.event.OperationFailedEvent;
import com.nokia.em.poseidon.services.certificate.event.RefreshCertificatesEvent;
import com.nokia.em.poseidon.services.certificate.event.RemoveCertificateEvent;
import com.nokia.em.poseidon.services.certificate.event.RequestCertificatesEvent;
import com.nokia.em.poseidon.services.certificate.event.RestoreVendorCertificatesEvent;
import com.nokia.em.poseidon.services.certificate.event.ReturnCertificatesEvent;
import com.nokia.em.poseidon.services.certificate.event.ReturnCmpConfigurationEvent;
import com.nokia.em.poseidon.services.certificate.event.ReturnCmpKeyUpdateEvent;
import com.nokia.em.poseidon.services.certificate.event.ReturnCrlStatusEvent;
import com.nokia.em.poseidon.services.certificate.event.SendCertificateEvent;
import com.nokia.em.poseidon.services.certificate.event.SendCmpConfigurationEvent;
import com.nokia.em.poseidon.services.certificate.event.StatusEvent;
import com.nokia.em.poseidon.services.certificate.event.StatusRequestEvent;
import com.nokia.em.poseidon.services.certificate.event.ValidateCertificateCancelEvent;
import com.nokia.em.poseidon.services.certificate.event.ValidateCertificateEvent;
import com.nokia.em.poseidon.services.certificate.event.ValidationResponseEvent;
import com.nokia.em.poseidon.services.certificate.event.ValidationResponseQueryEvent;
import com.nokia.em.poseidon.services.snapshot.PSaveSnapshotModules;
import com.nokia.em.poseidon.services.snapshot.PSnapshotChangeListener;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.services.snapshot.PSnapshotMediator;
import com.nokia.em.poseidon.util.concurrency.ThreadPool;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public class CertificateServiceImpl
implements Service,
CertificateService,
PSnapshotMediator {
    private static final String THREAD_NAME = "CertificateEventTransmitter";
    private static final String SNAPSHOT_NAME = "CertificateServiceSnapshot";
    private Set<EventProcessor> myMediators;
    private Set<EventProcessor> myListeners;
    private Logger myLogger;
    private CertKeyStoreManager myKeyStoreManager;
    private CertificateValidator myCertificateValidator;
    private PSnapshotChangeListener mySnapshotListener;
    private boolean mySnapshotCancelled;
    private ThreadPool myThreadPool = ThreadPool.getInstance();
    private ResourceBundle myResourceBundle;
    private boolean myIsSnapshot;
    private Map<String, URL> mySnapshotMap;
    private X509Certificate[] myCertificateChain;
    private List<X509Certificate[]> myAcceptedCertificateChains;
    private Set<X509Certificate> myNeExistingCertificateChain;
    private Set<X509Certificate> myNeExistingVendorCertificate;
    private boolean myValidationOngoing;
    private boolean myValidationUserConfirmationOngoing;
    private ConcurrentLinkedQueue<ValidateCertificateEvent> myValidateRequestQueue;
    private ValidateCertificateEvent myValidateRequestEvent;
    private ValidationResponseEvent myValidateResponseEvent;
    private boolean myValidateChainOnce = false;
    private boolean myTimeOut;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(CertificateEventListener listener) {
        Set<EventProcessor> set = this.myListeners;
        synchronized (set) {
            this.myListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(CertificateEventListener listener) {
        Set<EventProcessor> set = this.myListeners;
        synchronized (set) {
            this.myListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMediator(CertificateMediator mediator) {
        Set<EventProcessor> set = this.myMediators;
        synchronized (set) {
            this.myMediators.add(mediator);
            mediator.processEvent(new RequestCertificatesEvent(this));
            mediator.processEvent(new StatusRequestEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMediator(CertificateMediator mediator) {
        Set<EventProcessor> set = this.myMediators;
        synchronized (set) {
            this.myMediators.remove(mediator);
            this.processEvent(new StatusRequestEvent(this));
        }
    }

    @Override
    public void setCertificateValidator(CertificateValidator validator) {
        this.myCertificateValidator = validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvent(EventObject event) {
        if (event instanceof AddCertificateEvent) {
            this.handleCertificateAdd((AddCertificateEvent)event);
        } else if (event instanceof RequestCertificatesEvent) {
            this.handleCertificateRequest();
        } else if (event instanceof RemoveCertificateEvent) {
            this.handleCertificateRemove((RemoveCertificateEvent)event);
        } else if (event instanceof ReturnCertificatesEvent) {
            this.handleReturnCertificates((ReturnCertificatesEvent)event);
        } else if (event instanceof SendCertificateEvent) {
            this.handleSendCertificates((SendCertificateEvent)event);
        } else if (event instanceof ValidateCertificateEvent) {
            this.handleValidationEvent((ValidateCertificateEvent)event);
        } else if (event instanceof CertificateRemovedEvent) {
            this.sendEvent(this.myListeners, event);
        } else if (event instanceof OperationFailedEvent) {
            this.sendEvent(this.myListeners, event);
            if (this.myValidationOngoing) {
                Set<EventProcessor> set = this.myMediators;
                synchronized (set) {
                    this.myMediators.notifyAll();
                }
            }
        } else if (event instanceof InitializeServiceEvent) {
            this.handleServiceInitialization((InitializeServiceEvent)event);
        } else if (event instanceof ValidationResponseEvent) {
            this.handleValidationReturn((ValidationResponseEvent)event);
        } else if (event instanceof StatusEvent) {
            this.sendEvent(this.myListeners, event);
        } else if (event instanceof StatusRequestEvent) {
            this.handleStatusRequest((StatusRequestEvent)event);
        } else if (event instanceof SendCmpConfigurationEvent) {
            this.handleCmpConfigurationSend((SendCmpConfigurationEvent)event);
        } else if (event instanceof ReturnCmpConfigurationEvent) {
            this.sendEvent(this.myListeners, event);
        } else if (event instanceof CmpRegenerateRequestEvent) {
            this.sendEvent(this.myMediators, event);
        } else if (event instanceof RefreshCertificatesEvent) {
            this.sendEvent(this.myMediators, event);
        } else if (event instanceof RestoreVendorCertificatesEvent) {
            this.sendEvent(this.myMediators, event);
        } else if (event instanceof ReturnCrlStatusEvent) {
            this.sendEvent(this.myListeners, event);
        } else if (event instanceof CmpRegenerateCompletedEvent) {
            this.sendEvent(this.myListeners, event);
        } else if (event instanceof CmpKeyUpdateEvent) {
            this.sendEvent(this.myMediators, event);
        } else if (event instanceof ReturnCmpKeyUpdateEvent) {
            this.sendEvent(this.myListeners, event);
        } else if (event instanceof CrlUpdateRequestEvent) {
            this.sendEvent(this.myMediators, event);
        } else if (event instanceof ValidateCertificateCancelEvent) {
            this.handleValidationCancel((ValidateCertificateCancelEvent)event);
        }
    }

    private void handleValidationCancel(ValidateCertificateCancelEvent cancelEvent) {
        if (this.myValidationOngoing) {
            for (ValidateCertificateEvent validEvent : this.myValidateRequestQueue) {
                if (!validEvent.getSource().equals(cancelEvent.getSource())) continue;
                this.myValidateRequestQueue.remove(validEvent);
            }
            if (this.myValidationUserConfirmationOngoing) {
                this.sendEvent(this.myMediators, cancelEvent);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleValidation(ValidateCertificateEvent validEvent) {
        block7: {
            block8: {
                block10: {
                    block9: {
                        this.myLogger.debug("Validating certificate chain from: " + validEvent.getSource());
                        this.myValidateRequestEvent = validEvent;
                        if (this.myCertificateChain == null) {
                            Map<Integer, X509Certificate[]> failings = this.validateChain(validEvent);
                            this.handleValidationFailures(validEvent, failings);
                            return;
                        }
                        if (this.checkChainsMatch(this.myCertificateChain, validEvent.getCertificateChain())) break block8;
                        this.myLogger.debug("Certificate chain does not match with the previously validated one. Comparing to previously sent one.");
                        this.logCertificateChain(validEvent);
                        if (this.myNeExistingCertificateChain == null || !this.checkChainMatchWithCurrentNeChain(validEvent.getCertificateChain(), this.myNeExistingCertificateChain)) break block9;
                        this.myLogger.debug("Accepting the chain because it is the same that was previously sent");
                        this.sendEvent(this.myMediators, new ValidationResponseEvent(validEvent, 1));
                        break block7;
                    }
                    if (this.myNeExistingVendorCertificate == null || !this.checkChainMatchWithCurrentNeChain(validEvent.getCertificateChain(), this.myNeExistingVendorCertificate)) break block10;
                    this.myLogger.debug("Accepting the chain because existing vendor certificates is used.");
                    this.sendEvent(this.myMediators, new ValidationResponseEvent(validEvent, 1));
                    break block7;
                }
                if (this.checkChainMatchWithEarlierAccepted(validEvent.getCertificateChain())) {
                    this.myLogger.debug("Accepting the chain because user have accepted this chain or part of it earlier during this connection.");
                    this.sendEvent(this.myMediators, new ValidationResponseEvent(validEvent, 1));
                    break block7;
                } else if (!this.myValidateChainOnce && this.validateChain(validEvent).isEmpty()) {
                    this.myLogger.debug("Chain doesn't match with any chains accepted during this session, but validation against keystore passed.");
                    this.myCertificateChain = validEvent.getCertificateChain();
                    this.myAcceptedCertificateChains.add(this.myCertificateChain);
                    this.myValidateResponseEvent = new ValidationResponseEvent(validEvent, 1);
                    this.sendEvent(this.myMediators, this.myValidateResponseEvent);
                    this.myValidationOngoing = false;
                    this.handleValidationEvent(this.myValidateRequestQueue.poll());
                    break block7;
                } else {
                    this.myLogger.debug("Chain is NOT the same that was previously sent or validated and it is not accepted in validation. Query acceptance from user.");
                    Map<Integer, X509Certificate[]> failings = this.validateChain(validEvent);
                    failings.put(11, validEvent.getCertificateChain());
                    this.myCertificateChain = validEvent.getCertificateChain();
                    this.sendEvent(this.myMediators, new ValidationResponseQueryEvent(validEvent.getSource(), validEvent.getCertificateChain(), failings, null));
                    this.myValidationUserConfirmationOngoing = true;
                    return;
                }
            }
            if (this.myValidateResponseEvent != null && this.myValidateResponseEvent.getResponse() == 4) {
                this.myLogger.debug("Chain match with previous one but timeout occured during previous user confirmation request. So request again: ");
                Map<Integer, X509Certificate[]> failings = this.validateChain(validEvent);
                failings.put(11, validEvent.getCertificateChain());
                this.myTimeOut = false;
                this.handleValidationFailures(validEvent, failings);
                return;
            }
            if (this.myValidateResponseEvent != null) {
                this.myLogger.debug("Chains match with previous one so send same response as for previous request: " + this.myValidateResponseEvent.getResponse());
                this.sendEvent(this.myMediators, new ValidationResponseEvent(validEvent, this.myValidateResponseEvent.getResponse()));
            }
        }
        this.myValidationOngoing = false;
        this.handleValidationEvent(this.myValidateRequestQueue.poll());
    }

    private void handleValidationFailures(ValidateCertificateEvent validEvent, Map<Integer, X509Certificate[]> failings) {
        if (failings.isEmpty()) {
            this.myLogger.debug("Certificate validation succeed");
            this.myCertificateChain = validEvent.getCertificateChain();
            this.myAcceptedCertificateChains.add(this.myCertificateChain);
            this.myValidateResponseEvent = new ValidationResponseEvent(validEvent, 1);
            this.sendEvent(this.myMediators, this.myValidateResponseEvent);
            this.myValidationOngoing = false;
            this.handleValidationEvent(this.myValidateRequestQueue.poll());
        } else {
            this.myLogger.debug("Certificate validation fails");
            this.myCertificateChain = validEvent.getCertificateChain();
            this.sendEvent(this.myMediators, new ValidationResponseQueryEvent(this, validEvent.getCertificateChain(), failings, this.myCertificateValidator.getDetailFailingReason()));
            this.myValidationUserConfirmationOngoing = true;
        }
    }

    private Map<Integer, X509Certificate[]> validateChain(ValidateCertificateEvent validEvent) {
        HashMap<Integer, X509Certificate[]> failings = new HashMap<Integer, X509Certificate[]>();
        if (this.myCertificateValidator == null) {
            this.myCertificateValidator = new CertificateDefaultValidator();
        }
        this.myCertificateValidator.setKeyStore(this.myKeyStoreManager.getKeyStore());
        try {
            failings = this.myCertificateValidator.validateCertificateChain(validEvent.getAuthenticationType(), validEvent.getCertificateChain());
        }
        catch (Exception e) {
            if (failings == null) {
                failings = new HashMap();
            }
            failings.put(8, validEvent.getCertificateChain());
            this.myLogger.error("Certificate chain or algorithm type is null" + e);
        }
        return failings;
    }

    private boolean checkChainMatchWithEarlierAccepted(X509Certificate[] certChainToBeValidated) {
        boolean chainAcceptedEarlier = false;
        for (X509Certificate[] acceptedChain : this.myAcceptedCertificateChains) {
            int i = 0;
            while (i < certChainToBeValidated.length) {
                if (certChainToBeValidated[i] != null && i < acceptedChain.length && certChainToBeValidated[i].equals(acceptedChain[i])) {
                    chainAcceptedEarlier = true;
                }
                ++i;
            }
        }
        return chainAcceptedEarlier;
    }

    private boolean checkChainsMatch(X509Certificate[] chain1, X509Certificate[] chain2) {
        if (chain1.length != chain2.length) {
            return false;
        }
        int i = 0;
        while (i < chain1.length) {
            if (chain1[i] != null && !chain1[i].equals(chain2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkChainMatchWithCurrentNeChain(X509Certificate[] chainToValidate, Set<X509Certificate> neChain) {
        if (neChain != null && neChain.contains(chainToValidate[0])) {
            if (chainToValidate.length > 1) {
                X509Certificate caCert = chainToValidate[1];
                if (neChain.contains(caCert)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void handleValidationEvent(ValidateCertificateEvent validEvent) {
        if (validEvent == null) {
            return;
        }
        if (this.myCertificateChain == null) {
            this.logCertificateChain(validEvent);
        }
        if (this.myValidationOngoing) {
            this.myLogger.debug("Validation already ongoing. Set event to queue.");
            this.myValidateRequestQueue.offer(validEvent);
        } else {
            this.myValidationOngoing = true;
            this.handleValidation(validEvent);
        }
    }

    private void logCertificateChain(ValidateCertificateEvent validEvent) {
        try {
            String source = validEvent.getSource().getClass().getName();
            X509Certificate[] chain = validEvent.getCertificateChain();
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < chain.length) {
                if (chain[i] != null) {
                    builder.append(" Certificate " + i + chain[i].toString());
                } else {
                    builder.append(" Certificate " + i + " = null");
                }
                ++i;
            }
            this.myLogger.debug("Validate chain from " + source + " chain length " + chain.length + " content ->" + builder.toString());
        }
        catch (Exception e) {
            this.myLogger.error("Exception happened in certificate validation.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReturnCertificates(ReturnCertificatesEvent event) {
        if (this.myNeExistingCertificateChain == null) {
            this.myNeExistingCertificateChain = new CopyOnWriteArraySet<X509Certificate>();
        }
        if (event.isVendorCertificates()) {
            this.myNeExistingVendorCertificate = new CopyOnWriteArraySet<X509Certificate>();
            this.myNeExistingVendorCertificate.add(event.getNeCertificate());
        } else if (event.getCaCertificates() != null) {
            this.myNeExistingCertificateChain.add(event.getNeCertificate());
            int i = 0;
            while (i < event.getCaCertificates().size()) {
                this.myNeExistingCertificateChain.add(event.getCaCertificates().get(i));
                ++i;
            }
        } else {
            this.myNeExistingCertificateChain.add(event.getNeCertificate());
        }
        this.sendEvent(this.myListeners, event);
        if (this.myValidationOngoing) {
            Set<EventProcessor> set = this.myMediators;
            synchronized (set) {
                this.myMediators.notifyAll();
            }
        }
    }

    private void handleSendCertificates(SendCertificateEvent event) {
        if (this.myMediators.isEmpty()) {
            this.sendEvent(this.myListeners, new OperationFailedEvent(this, 1, this.myResourceBundle.getString("CertificateManagement.InstallFails_Title_Text"), this.myResourceBundle.getString("CertificateManagement.InstallFails_Message_Text")));
        } else {
            this.sendEvent(this.myMediators, event);
        }
    }

    private void handleCertificateRequest() {
        this.sendEvent(this.myMediators, new RequestCertificatesEvent(this));
        List<X509Certificate> certificates = this.myKeyStoreManager.getCertificates();
        if (!certificates.isEmpty()) {
            this.sendEvent(this.myListeners, new ReturnCertificatesEvent(this, true, certificates, null));
        }
    }

    private void handleCertificateRemove(RemoveCertificateEvent event) {
        if (event.isLocalCertificate()) {
            if (this.myIsSnapshot) {
                this.sendEvent(this.myListeners, new OperationFailedEvent(this, 1, this.myResourceBundle.getString("CertificateManagement.Snapshot_Title_Text"), this.myResourceBundle.getString("CertificateManagement.Snapshot_Message_Text")));
            } else {
                X509Certificate cert = event.getCertificate();
                String alias = event.getAlias();
                try {
                    this.myKeyStoreManager.removeCertificate(cert, alias);
                    this.sendEvent(this.myListeners, new CertificateRemovedEvent(this, cert, alias, true));
                }
                catch (Exception e) {
                    OperationFailedEvent failureEvent = new OperationFailedEvent(this, 0, this.myResourceBundle.getString("CertificateManagement.DeleteFails_Title_Text"), this.myResourceBundle.getString("CertificateManagement.DeleteFails_Message_Text"));
                    failureEvent.setFailureDetails(e);
                    this.sendEvent(this.myListeners, failureEvent);
                }
            }
        } else if (this.myMediators.isEmpty()) {
            this.sendEvent(this.myListeners, new OperationFailedEvent(this, 1, this.myResourceBundle.getString("CertificateManagement.DeleteFails_Title_Text"), this.myResourceBundle.getString("CertificateManagement.DeleteFails_Message2_Text")));
        } else {
            this.sendEvent(this.myMediators, event);
        }
    }

    private void handleServiceInitialization(InitializeServiceEvent event) {
        this.mySnapshotMap = event.getSnapshot();
        boolean bl = this.myIsSnapshot = this.mySnapshotMap != null;
        if (this.myIsSnapshot && this.mySnapshotMap.get(SNAPSHOT_NAME) != null) {
            this.myKeyStoreManager.initKeyStore(this.mySnapshotMap.get(SNAPSHOT_NAME).getPath(), null);
        } else if (event.getKeyStorePath() != null && !this.myKeyStoreManager.initKeyStore(event.getKeyStorePath(), event.getPassword())) {
            this.sendEvent(this.myListeners, new OperationFailedEvent(this, 0, this.myResourceBundle.getString("CertificateManagement.KeyStoreInitFails_Title_Text"), this.myResourceBundle.getString("CertificateManagement.KeyStoreInitFails_Message_Text")));
        }
        if (event.resetValidationMemory()) {
            this.myCertificateChain = null;
            this.myAcceptedCertificateChains.clear();
            this.myTimeOut = false;
            if (this.myNeExistingCertificateChain != null) {
                this.myNeExistingCertificateChain.clear();
            }
            if (this.myNeExistingVendorCertificate != null) {
                this.myNeExistingVendorCertificate.clear();
            }
        }
    }

    private void handleCmpConfigurationSend(SendCmpConfigurationEvent event) {
        if (this.myMediators.isEmpty()) {
            this.sendEvent(this.myListeners, new OperationFailedEvent(this, 1, this.myResourceBundle.getString("CertificateManagement.RequestFails_Title_Text"), this.myResourceBundle.getString("CertificateManagement.RequestFails_Message_Text")));
        } else {
            this.sendEvent(this.myMediators, event);
        }
    }

    private void handleStatusRequest(StatusRequestEvent event) {
        this.sendEvent(this.myMediators, event);
        if (this.myMediators.isEmpty()) {
            this.sendEvent(this.myListeners, new StatusEvent(this, StatusEvent.STATUS.NOT_AVAILABLE));
        }
    }

    private void handleCertificateAdd(AddCertificateEvent event) {
        if (this.myIsSnapshot) {
            this.sendEvent(this.myListeners, new OperationFailedEvent(this, 1, this.myResourceBundle.getString("CertificateManagement.Snapshot_Title_Text"), this.myResourceBundle.getString("CertificateManagement.Snapshot_Message_Text")));
        } else {
            try {
                this.myKeyStoreManager.saveCertificate(event.getCertificate(), event.getAlias());
                List<X509Certificate> certificates = this.myKeyStoreManager.getCertificates();
                if (!certificates.isEmpty()) {
                    this.sendEvent(this.myListeners, new ReturnCertificatesEvent(this, true, certificates, null));
                }
            }
            catch (Exception e) {
                OperationFailedEvent failEvent = new OperationFailedEvent(this, 0, this.myResourceBundle.getString("CertificateManagement.SaveFails_Title_Text"), this.myResourceBundle.getString("CertificateManagement.SaveFails_Message_Text"));
                failEvent.setFailureDetails(e);
                this.sendEvent(this.myListeners, failEvent);
            }
        }
    }

    private void handleValidationReturn(ValidationResponseEvent event) {
        if (event.getResponse() == 3) {
            this.storeChain();
        } else if (event.getResponse() == 2 || event.getResponse() == 1) {
            this.myAcceptedCertificateChains.add(this.myCertificateChain);
        }
        if (event.getResponse() == 4) {
            this.myTimeOut = true;
        }
        if (this.myTimeOut) {
            this.myValidateResponseEvent = new ValidationResponseEvent(this.myValidateRequestEvent, 4);
            this.sendEvent(this.myMediators, this.myValidateResponseEvent);
        } else {
            this.myValidateResponseEvent = new ValidationResponseEvent(this.myValidateRequestEvent, event.getResponse());
            this.sendEvent(this.myMediators, this.myValidateResponseEvent);
        }
        this.myValidationOngoing = false;
        this.myValidationUserConfirmationOngoing = false;
        this.handleValidationEvent(this.myValidateRequestQueue.poll());
    }

    private void storeChain() {
        this.myAcceptedCertificateChains.add(this.myCertificateChain);
        X509Certificate root = this.myCertificateChain[this.myCertificateChain.length - 1];
        if (root.getBasicConstraints() != -1) {
            try {
                root.verify(root.getPublicKey());
                this.myKeyStoreManager.saveCertificate(root, null);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(Collection<EventProcessor> recipients, EventObject event) {
        Collection<EventProcessor> collection = recipients;
        synchronized (collection) {
            this.myLogger.debug("Send certificate event to listeners. Event: " + event.getClass().getSimpleName());
            for (EventProcessor interceptor : recipients) {
                this.myThreadPool.execute(new EventTransmitter(interceptor, event, THREAD_NAME));
            }
        }
    }

    private void saveFile(String sourceFileUrl, URL snapshotURL) {
        try {
            File snapshotFile;
            this.myLogger.debug("Saving certificate keystore file: " + sourceFileUrl);
            File sourceFile = new File(sourceFileUrl);
            try {
                snapshotFile = new File(snapshotURL.toURI());
            }
            catch (URISyntaxException e) {
                snapshotFile = new File(snapshotURL.getFile());
            }
            File file = new File(snapshotFile, sourceFile.getName());
            PFileUtils.copyFile(file, sourceFile);
        }
        catch (Exception e) {
            this.myLogger.error("Exception happened when copying certificate keystore file.", e);
        }
    }

    @Override
    public void start() {
        this.myListeners = new HashSet<EventProcessor>();
        this.myMediators = new HashSet<EventProcessor>();
        this.myLogger = Logger.getLogger(this.getClass());
        this.myKeyStoreManager = new CertKeyStoreManager();
        this.myAcceptedCertificateChains = new ArrayList<X509Certificate[]>();
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myValidateRequestQueue = new ConcurrentLinkedQueue();
        PoseidonRuntime.getRuntime().addObject(this);
    }

    @Override
    public void stop() {
        this.myListeners.clear();
        this.myMediators.clear();
        PoseidonRuntime.getRuntime().removeObject(this);
    }

    @Override
    public void addSnapshotChangeListener(PSnapshotChangeListener listener) {
        this.mySnapshotListener = listener;
    }

    @Override
    public void cancelSnapshotSaving() {
        this.mySnapshotCancelled = true;
    }

    @Override
    public PStepProgressTask getSnapshotSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL level) {
        return null;
    }

    @Override
    public void removeSnapshotChangeListener(PSnapshotChangeListener listener) {
        if (listener.equals(this.mySnapshotListener)) {
            this.mySnapshotListener = null;
        }
    }

    @Override
    public void saveSnapshot(URL snapshotURL, PSnapshotConst.SNAPSHOT_LEVEL level) {
        this.saveFile(this.myKeyStoreManager.myKeyStoreFile, snapshotURL);
        if (this.mySnapshotCancelled) {
            this.mySnapshotListener.savingCancelled(this);
        } else {
            this.mySnapshotListener.savingCompleted(this);
        }
        this.mySnapshotCancelled = false;
    }

    @Override
    public boolean stillAlive() {
        return true;
    }

    @Override
    public AppDescription getDescription() {
        AppDescription desc = new AppDescription(SNAPSHOT_NAME, SNAPSHOT_NAME);
        desc.setProperty("elementName", SNAPSHOT_NAME);
        return desc;
    }

    @Override
    public List<PSaveSnapshotModules> getModules() {
        return null;
    }
}

