/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.certificate.event;

import java.security.cert.X509Certificate;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

public class SendCertificateEvent
extends EventObject {
    private Map<CERTIFICATE_TYPE, Object> myCertificates = new HashMap<CERTIFICATE_TYPE, Object>();

    public SendCertificateEvent(Object source, X509Certificate neCertificate, X509Certificate caCertificate, byte[] privateKey) {
        super(source);
        this.myCertificates.put(CERTIFICATE_TYPE.CA_CERTIFICATE, caCertificate);
        this.myCertificates.put(CERTIFICATE_TYPE.NE_CERTIFICATE, neCertificate);
        this.myCertificates.put(CERTIFICATE_TYPE.PRIVATE_KEY, privateKey);
    }

    public SendCertificateEvent(Object source, X509Certificate vendorCertificate, byte[] vendorPrivateKey) {
        super(source);
        this.myCertificates.put(CERTIFICATE_TYPE.VENDOR_NE_CERTIFICATE, vendorCertificate);
        this.myCertificates.put(CERTIFICATE_TYPE.VENDOR_PRIVATE_KEY, vendorPrivateKey);
    }

    public X509Certificate getCaCertificate() {
        return this.getCertificate(CERTIFICATE_TYPE.CA_CERTIFICATE);
    }

    public X509Certificate getNeCertificate() {
        return this.getCertificate(CERTIFICATE_TYPE.NE_CERTIFICATE);
    }

    public byte[] getKeyCertificate() {
        return this.getKey(CERTIFICATE_TYPE.PRIVATE_KEY);
    }

    public X509Certificate getCertificate(CERTIFICATE_TYPE certificateType) {
        return (X509Certificate)this.myCertificates.get((Object)certificateType);
    }

    public byte[] getKey(CERTIFICATE_TYPE keyType) {
        return (byte[])this.myCertificates.get((Object)keyType);
    }

    public boolean isSendingVendorCertificates() {
        return this.myCertificates.get((Object)CERTIFICATE_TYPE.VENDOR_NE_CERTIFICATE) != null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (CERTIFICATE_TYPE type : this.myCertificates.keySet()) {
            builder.append((Object)type);
            builder.append(this.myCertificates.get((Object)type));
        }
        return builder.toString();
    }

    public static enum CERTIFICATE_TYPE {
        PRIVATE_KEY,
        NE_CERTIFICATE,
        CA_CERTIFICATE,
        TRUST_ANCHOR,
        VENDOR_PRIVATE_KEY,
        VENDOR_NE_CERTIFICATE;

    }
}

