/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.cl;

import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.cl.CLCommunication;
import com.nokia.em.poseidon.services.cl.CLCommunicationListener;
import com.nokia.em.poseidon.services.cl.ConfirmationRequestInfo;
import com.nokia.em.poseidon.services.cl.MessageFactory;
import com.nokia.em.poseidon.services.cl.StreamReader;
import com.nokia.em.poseidon.util.concurrency.CachedThread;
import com.nokia.em.poseidon.util.xml.XmlUtils;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public final class CLCommunicationImpl
implements Observer,
CLCommunication,
Service {
    private Vector<CLCommunicationListener> myListeners;
    private StreamResult myResult;
    private Logger myLogger = null;
    private Transformer myTransformer;
    private static CLCommunication myInstance;
    private StreamReader myInputReader;
    private String myLastSent = "";

    public static synchronized CLCommunication getInstance() {
        if (myInstance != null) {
            return myInstance;
        }
        myInstance = new CLCommunicationImpl();
        return myInstance;
    }

    @Override
    public String getLastSent() {
        return this.myLastSent;
    }

    @Override
    public void close() {
        this.myInputReader.close();
    }

    private synchronized void sendMsgToCL(Document message) {
        DOMSource source = new DOMSource(message);
        this.myLastSent = message.getDocumentElement().getLastChild().getFirstChild().getNodeName();
        char c = '\u0004';
        System.out.print(c);
        try {
            this.myTransformer.transform(source, this.myResult);
        }
        catch (TransformerException te) {
            this.myLogger.error("TransformerConfigurationException", te);
        }
        System.out.print(c);
        this.myLogger.debug("Message sent to CL, Message: " + message.getDocumentElement().getLastChild().getFirstChild().getNodeName());
    }

    @Override
    public void update(Observable observable, Object message) {
        Document doc = XmlUtils.getInstance().parseDoc((String)message, "jar:file:./cl/cl.jar!/message.xsd");
        if (doc != null) {
            MessageFactory.getInstance().parseAndNotifyListeners(doc, this.myListeners.subList(0, this.myListeners.size()));
            this.myLogger.info("Received from CL: " + doc.getDocumentElement().getLastChild().getFirstChild().getNodeName());
        }
    }

    @Override
    public void addCommunicationListener(CLCommunicationListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeCommunicationListener(CLCommunicationListener listener) {
        if (this.myListeners.contains(listener)) {
            this.myListeners.remove(listener);
        }
    }

    @Override
    public void sendInitializedMessage(String interfaceVersion) {
        this.sendMsgToCL(MessageFactory.getInstance().createInitializedMessage("cl", "em", interfaceVersion));
    }

    @Override
    public void sendInitializedMessage() {
        this.sendInitializedMessage("5.0");
    }

    @Override
    public void sendProgressTaskStartedMessage(String progressTaskName) {
        this.sendMsgToCL(MessageFactory.getInstance().createProgressTaskStartedMessage("cl", "em", progressTaskName));
    }

    @Override
    public void sendProgressTaskFinishedMessage(boolean failed) {
        this.sendMsgToCL(MessageFactory.getInstance().createProgressTaskFinishedMessage("cl", "em", failed));
    }

    @Override
    public void sendOperationFinishedMessage(String failureText, String troubleshootFunction, String failureType) {
        this.sendMsgToCL(MessageFactory.getInstance().createOperationFinishedMessage("cl", "em", failureText, troubleshootFunction, failureType));
        this.myLogger.debug("Failure type: " + failureType);
    }

    @Override
    public void sendCancellableMessage(boolean cancelValue) {
        this.sendMsgToCL(MessageFactory.getInstance().createCancelableMessage("cl", "em", cancelValue));
    }

    @Override
    public void sendReconnectMessage(String ip, String siteemPort, String userName, String passWord, String sessionId, boolean readOnly) {
        this.sendMsgToCL(MessageFactory.getInstance().createReconnectMessage("cl", "em", ip, siteemPort, userName, passWord, sessionId, readOnly));
    }

    @Override
    public void sendCancelReconnectMessage() {
        this.sendMsgToCL(MessageFactory.getInstance().createCancelReConnectMessage("cl", "em"));
    }

    @Override
    public void sendSetPropertyMessage(String key, String value) {
        this.sendMsgToCL(MessageFactory.getInstance().createSetPropertyMessage("cl", "em", key, value));
    }

    @Override
    public void sendGetPropertyMessage(String key, String value) {
        this.sendMsgToCL(MessageFactory.getInstance().createGetPropertyMessage("cl", "em", key, value));
    }

    @Override
    public void sendManagerDisconnectedMessage(String viewInCL, String failureText, String troubleshootFunction, String failureType) {
        this.sendMsgToCL(MessageFactory.getInstance().createManagerDisconnectedMessage("cl", "em", viewInCL, failureText, troubleshootFunction, failureType));
    }

    @Override
    public void sendResponseMessage(String failureReason, String desiredAction) {
        this.sendMsgToCL(MessageFactory.getInstance().createResponseMessage("cl", "em", failureReason, desiredAction));
    }

    @Override
    public void sendResponseMessage(String failureReason) {
        this.sendResponseMessage(failureReason, "");
    }

    @Override
    public void sendProgressTasksMessage(int operationTimeout, String[] tasks) {
        this.sendMsgToCL(MessageFactory.getInstance().createProgressTasksMessage("cl", "em", operationTimeout, tasks));
    }

    @Override
    public void sendStillAliveMessage() {
        this.sendMsgToCL(MessageFactory.getInstance().createStillAliveMessage("cl", "em"));
    }

    @Override
    public void sendManagerClosedMessage(boolean closeCL, Map<String, String> changedProperties, String desiredAction) {
        this.sendMsgToCL(MessageFactory.getInstance().createManagerClosedMessage("cl", "em", closeCL, changedProperties, desiredAction));
    }

    @Override
    public void sendConfirmationRequestMessage(String type, ConfirmationRequestInfo confirmationRequestInfo) {
        this.sendMsgToCL(MessageFactory.getInstance().createConfirmationRequestMessage("cl", "em", type, confirmationRequestInfo));
    }

    @Override
    public void sendConfirmationResponseMessage(String type, Map<String, String> parameters) {
        this.sendMsgToCL(MessageFactory.getInstance().createConfirmationResponseMessage("cl", "em", type, parameters));
    }

    @Override
    public void start() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myListeners = new Vector();
        this.myInputReader = new StreamReader(System.in);
        this.myInputReader.addObserver(this);
        CachedThread t = new CachedThread(this.myInputReader);
        t.setName("CLCommunicationStreamListener");
        t.setDaemon(true);
        t.start();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        this.myResult = new StreamResult(System.out);
        try {
            this.myTransformer = tFactory.newTransformer();
            this.myTransformer.setOutputProperty("encoding", "ISO-8859-15");
        }
        catch (TransformerConfigurationException e) {
            this.myLogger.error("TransformerConfigurationException", e);
        }
    }

    @Override
    public void stop() {
        this.close();
        this.myListeners.clear();
    }
}

