/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.cl;

import com.nokia.em.poseidon.services.cl.CLCommunicationListener;
import com.nokia.em.poseidon.services.cl.ConfirmationAction;
import com.nokia.em.poseidon.services.cl.ConfirmationRequestInfo;
import com.nokia.em.poseidon.services.cl.Parameter;
import com.nokia.em.poseidon.services.cl.parsers.MsgParser;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.em.poseidon.util.security.Base64;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MessageFactory {
    private static MessageFactory myInstance;
    private static int myEMId;
    private Logger myLogger = null;
    private DocumentBuilder myDocBuilder;
    private Map<String, Object> myMessageParams = new LinkedHashMap<String, Object>();

    static {
        myEMId = 0;
    }

    private MessageFactory() {
        this.myLogger = Logger.getLogger(this.getClass());
        DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
        try {
            this.myDocBuilder = docBF.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.myLogger.error("ParserConfigurationException", e);
        }
    }

    public static int getEMId() {
        return myEMId;
    }

    public static void setEMId(int emId) {
        myEMId = emId;
    }

    public static MessageFactory getInstance() {
        if (myInstance != null) {
            return myInstance;
        }
        myInstance = new MessageFactory();
        return myInstance;
    }

    public Document createProgressTaskStartedMessage(String targetName, String sourceName, String taskName) {
        this.myMessageParams.clear();
        this.myMessageParams.put("progressTaskName", taskName);
        return this.message(targetName, sourceName, "progressTaskStarted", this.myMessageParams);
    }

    public Document createProgressTaskFinishedMessage(String targetName, String sourceName, boolean failed) {
        this.myMessageParams.clear();
        this.myMessageParams.put("failed", Boolean.toString(failed));
        return this.message(targetName, sourceName, "progressTaskFinished", this.myMessageParams);
    }

    public Document createOperationFinishedMessage(String targetName, String sourceName, String failureText, String troubleShootFunction, String failureType) {
        this.myMessageParams.clear();
        this.myMessageParams.put("failureText", failureText);
        this.myMessageParams.put("troubleshootFunction", troubleShootFunction);
        this.myMessageParams.put("failureType", failureType);
        return this.message(targetName, sourceName, "operationFinished", this.myMessageParams);
    }

    public Document createCancelableMessage(String targetName, String sourceName, boolean cancellable) {
        this.myMessageParams.clear();
        this.myMessageParams.put("cancelValue", Boolean.toString(cancellable));
        return this.message(targetName, sourceName, "cancelable", this.myMessageParams);
    }

    public Document createCancelReConnectMessage(String targetName, String sourceName) {
        this.myMessageParams.clear();
        return this.message(targetName, sourceName, "cancelReconnect", this.myMessageParams);
    }

    public Document createReconnectMessage(String targetName, String sourceName, String ip, String siteemPort, String userName, String passWord, String sessionId, boolean readOnly) {
        this.myMessageParams.clear();
        this.myMessageParams.put("ip", ip);
        if (!TextUtils.isNullOrBlank(siteemPort)) {
            this.myMessageParams.put("siteemport", siteemPort);
        }
        this.myMessageParams.put("userName", userName);
        this.myMessageParams.put("passWord", passWord);
        this.myMessageParams.put("readOnly", String.valueOf(readOnly));
        if (sessionId != null) {
            this.myMessageParams.put("sessionId", sessionId);
        }
        return this.message(targetName, sourceName, "reconnect", this.myMessageParams);
    }

    public Document createSetPropertyMessage(String targetName, String sourceName, String key, String value) {
        this.myMessageParams.clear();
        this.myMessageParams.put("key", key);
        this.myMessageParams.put("value", value);
        return this.message(targetName, sourceName, "setProperty", this.myMessageParams);
    }

    public Document createGetPropertyMessage(String targetName, String sourceName, String key, String value) {
        this.myMessageParams.clear();
        this.myMessageParams.put("key", key);
        this.myMessageParams.put("value", value);
        return this.message(targetName, sourceName, "getProperty", this.myMessageParams);
    }

    public Document createManagerDisconnectedMessage(String targetName, String sourceName, String viewInCL, String failureText, String troubleshootFunction, String failureType) {
        this.myMessageParams.clear();
        if (viewInCL != null) {
            this.myMessageParams.put("viewInCL", viewInCL);
        }
        if (failureText != null && troubleshootFunction != null && failureType != null) {
            this.myMessageParams.put("failureText", failureText);
            this.myMessageParams.put("troubleshootFunction", troubleshootFunction);
            this.myMessageParams.put("failureType", failureType);
        }
        return this.message(targetName, sourceName, "managerDisconnected", this.myMessageParams);
    }

    public Document createInitializedMessage(String targetName, String sourceName, String interfaceVersion) {
        this.myMessageParams.clear();
        this.myMessageParams.put("communicationInterfaceVersion", interfaceVersion);
        return this.message(targetName, sourceName, "initialized", this.myMessageParams);
    }

    public Document createResponseMessage(String targetName, String sourceName, String failureReason, String desiredAction) {
        this.myMessageParams.clear();
        this.myMessageParams.put("failureReason", failureReason);
        this.myMessageParams.put("desiredAction", desiredAction);
        return this.message(targetName, sourceName, "response", this.myMessageParams);
    }

    public Document createProgressTasksMessage(String targetName, String sourceName, int operationTimeout, String[] tasks) {
        this.myMessageParams.clear();
        this.myMessageParams.put("operationTimeout", String.valueOf(operationTimeout));
        this.myMessageParams.put("tasks", tasks);
        return this.message(targetName, sourceName, "progressTasks", this.myMessageParams);
    }

    public Document createStillAliveMessage(String targetName, String sourceName) {
        this.myMessageParams.clear();
        return this.message(targetName, sourceName, "stillAlive", this.myMessageParams);
    }

    public Document createManagerClosedMessage(String targetName, String sourceName, boolean closeCL, Map<String, String> changedProperties, String desiredAction) {
        this.myMessageParams.clear();
        this.myMessageParams.put("closeCL", Boolean.toString(closeCL));
        this.myMessageParams.put("changedProperties", changedProperties);
        this.myMessageParams.put("desiredAction", desiredAction);
        return this.message(targetName, sourceName, "managerClosed", this.myMessageParams);
    }

    public Document createConfirmationRequestMessage(String targetName, String sourceName, String type, ConfirmationRequestInfo confirmationRequestInfo) {
        this.myMessageParams.clear();
        this.myMessageParams.put("type", type);
        List<Parameter> confirmationParameters = this.createConfirmationParameters(confirmationRequestInfo);
        this.myMessageParams.put("parameter", confirmationParameters);
        return this.message(targetName, sourceName, "confirmationRequest", this.myMessageParams);
    }

    public Document createConfirmationResponseMessage(String targetName, String sourceName, String type, Map<String, String> params) {
        this.myMessageParams.clear();
        this.myMessageParams.put("type", type);
        this.myMessageParams.put("parameter", params);
        return this.message(targetName, sourceName, "confirmationResponse", this.myMessageParams);
    }

    private Document message(String targetName, String sourceName, String type, Map<String, Object> values) {
        Document doc = this.myDocBuilder.newDocument();
        Element root = doc.createElement("message");
        doc.appendChild(root);
        Element header = doc.createElement("header");
        Element target = doc.createElement("target");
        target.appendChild(doc.createTextNode(targetName));
        header.appendChild(target);
        Element source = doc.createElement("source");
        source.appendChild(doc.createTextNode(sourceName));
        header.appendChild(source);
        if (myEMId != 0) {
            Element emId = doc.createElement("emId");
            emId.appendChild(doc.createTextNode(String.valueOf(myEMId)));
            header.appendChild(emId);
        }
        root.appendChild(header);
        Element messageData = doc.createElement("messageData");
        Element messageType = doc.createElement(type);
        Object[] keys = values.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            if (keys[i].equals("tasks")) {
                String[] tasks = (String[])values.get("tasks");
                int j = 0;
                while (j < tasks.length) {
                    Node node = messageType.appendChild(doc.createElement("task"));
                    node.appendChild(doc.createTextNode(tasks[j]));
                    ++j;
                }
            } else if (keys[i].equals("changedProperties")) {
                Map changedProperties = (Map)values.get("changedProperties");
                if (changedProperties != null && !changedProperties.isEmpty()) {
                    Node changedPropertiesNode = messageType.appendChild(doc.createElement("changedProperties"));
                    Set changedPropertySet = changedProperties.entrySet();
                    for (Map.Entry property : changedPropertySet) {
                        Node propertyNode = changedPropertiesNode.appendChild(doc.createElement("property"));
                        Node keyNode = propertyNode.appendChild(doc.createElement("key"));
                        keyNode.appendChild(doc.createTextNode((String)property.getKey()));
                        Node valueNode = propertyNode.appendChild(doc.createElement("value"));
                        valueNode.appendChild(doc.createTextNode((String)property.getValue()));
                    }
                }
            } else if (keys[i].equals("type")) {
                messageType.setAttribute("type", (String)values.get(keys[i]));
            } else if (keys[i].equals("parameter")) {
                List confirmationParameters = (List)values.get("parameter");
                for (Parameter parameter : confirmationParameters) {
                    Element parameterElement = doc.createElement("parameter");
                    Node keyNode = parameterElement.appendChild(doc.createElement("key"));
                    keyNode.appendChild(doc.createTextNode(Base64.encodeToString(parameter.getKey(), false)));
                    Node valueNode = parameterElement.appendChild(doc.createElement("value"));
                    valueNode.appendChild(doc.createTextNode(Base64.encodeToString(parameter.getValue(), false)));
                    messageType.appendChild(parameterElement);
                }
            } else {
                Node node = messageType.appendChild(doc.createElement((String)keys[i]));
                node.appendChild(doc.createTextNode((String)values.get(keys[i])));
            }
            ++i;
        }
        messageData.appendChild(messageType);
        root.appendChild(messageData);
        return doc;
    }

    public void parseAndNotifyListeners(Document message, List<CLCommunicationListener> listeners) {
        NodeList messageDataList = message.getElementsByTagName("messageData");
        Node messageNode = messageDataList.item(0).getFirstChild();
        String messageType = messageNode.getNodeName();
        MsgParser msg = null;
        String className = String.valueOf(messageType.substring(0, 1).toUpperCase()) + messageType.substring(1);
        try {
            Class<?> temp = Class.forName(String.valueOf(MsgParser.class.getPackage().getName()) + "." + className);
            msg = (MsgParser)temp.newInstance();
            msg.parseAndNotify(messageNode, listeners);
        }
        catch (Exception e) {
            this.myLogger.error("Exception parsing the message", e);
        }
    }

    private List<Parameter> createConfirmationParameters(ConfirmationRequestInfo confReqInfo) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String icon = confReqInfo.getIcon() == ConfirmationRequestInfo.ICON.ERROR ? "error" : (confReqInfo.getIcon() == ConfirmationRequestInfo.ICON.WARNING ? "warning" : "info");
        parameters.add(new Parameter("Icon", icon));
        parameters.add(new Parameter("Header", confReqInfo.getHeaderText()));
        parameters.add(new Parameter("Text", confReqInfo.getText()));
        String details = confReqInfo.getDetails();
        if (details != null) {
            parameters.add(new Parameter("Details", details));
        }
        List<ConfirmationAction> confirmationActions = confReqInfo.getConfirmationActions();
        for (ConfirmationAction confirmationAction : confirmationActions) {
            String actionText;
            String name = confirmationAction.getName();
            parameters.add(new Parameter("Action", name));
            String mnemonic = confirmationAction.getMnemonic();
            if (mnemonic != null) {
                parameters.add(new Parameter(String.valueOf(name) + "_Mnemonic", mnemonic));
            }
            if ((actionText = confirmationAction.getText()) != null) {
                parameters.add(new Parameter(String.valueOf(name) + "_Text", actionText));
            }
            if (confirmationAction.isAutomaticDefault()) {
                parameters.add(new Parameter("AutomaticDefault", name));
            }
            if (confReqInfo.getDefaultActionName() == null || !confirmationAction.getName().equals(confReqInfo.getDefaultActionName())) continue;
            parameters.add(new Parameter("DefaultAction", name));
        }
        return parameters;
    }
}

