/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.cl.conf.application;

import com.nokia.em.poseidon.services.cl.conf.application.Build;
import com.nokia.em.poseidon.services.cl.conf.application.FeatureBuild;
import com.nokia.em.poseidon.services.cl.conf.application.MR;
import com.nokia.em.poseidon.services.cl.conf.application.Major;
import com.nokia.em.poseidon.services.cl.conf.application.Minor;
import com.nokia.em.poseidon.services.cl.conf.application.Patch;
import com.nokia.em.poseidon.services.cl.conf.application.ValueProvider;
import java.util.ArrayList;
import java.util.List;

public class InterfaceVersion {
    private String myType;
    private List<ValueProvider> myMajors = new ArrayList<ValueProvider>();
    private FeatureBuild myFeatureBuild;
    private Patch myPatch;
    private MR myMR;
    private Major myOldInterfaceMajor = new Major();
    private Minor myOldInterfaceMinor = new Minor();
    private Build myOldInterfaceBuild = new Build();

    public InterfaceVersion() {
        ArrayList<Minor> oldMinors = new ArrayList<Minor>();
        oldMinors.add(this.myOldInterfaceMinor);
        this.myOldInterfaceMajor.setMinors(oldMinors);
        ArrayList<Build> oldBuilds = new ArrayList<Build>();
        oldBuilds.add(this.myOldInterfaceBuild);
        this.myOldInterfaceMinor.setBuilds(oldBuilds);
    }

    public String getInterfaceType() {
        return this.myType;
    }

    public List<ValueProvider> getMajors() {
        return this.myMajors;
    }

    public void setInterfaceType(String type) {
        this.myType = type;
    }

    public void setMajors(List<ValueProvider> majors) {
        this.myMajors = majors;
    }

    public void setFeatureBuild(FeatureBuild featureBuild) {
        this.myFeatureBuild = featureBuild;
    }

    public void setPatch(Patch patch) {
        this.myPatch = patch;
    }

    public void setMr(MR mr) {
        this.myMR = mr;
    }

    public MR getMR() {
        return this.myMR;
    }

    public boolean hasFeatureBuild() {
        return this.myFeatureBuild != null;
    }

    public boolean hasMR() {
        return this.myMR != null;
    }

    public int getFeatureBuild() {
        return this.myFeatureBuild.getValue() < 100 ? 0 : this.myFeatureBuild.getValue();
    }

    public int getPatch() {
        return this.myPatch.getValue();
    }

    public Major getMajor() {
        return this.myOldInterfaceMajor;
    }

    public Minor getMinor() {
        return this.myOldInterfaceMinor;
    }

    public Build getBuild() {
        return this.myOldInterfaceBuild;
    }

    public void setMajor(Major major) {
        if (major.getMinors() == null) {
            this.setOldMajor(major);
        } else {
            this.myMajors.add(major);
        }
    }

    public void setMinor(Minor minor) {
        this.myOldInterfaceMinor.setValue(minor.getValue());
        this.setOldMajor(this.myOldInterfaceMajor);
    }

    public void setBuild(Build build) {
        this.myOldInterfaceBuild.setValue(build.getValue());
        this.setOldMajor(this.myOldInterfaceMajor);
    }

    private void setOldMajor(Major major) {
        this.myOldInterfaceMajor.setValue(major.getValue());
        ArrayList<ValueProvider> majors = new ArrayList<ValueProvider>();
        majors.add(this.myOldInterfaceMajor);
        this.myMajors = majors;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Interface type: ");
        stringBuffer.append(this.myType);
        stringBuffer.append(" Majors: ");
        stringBuffer.append(this.myMajors);
        if (this.hasMR()) {
            stringBuffer.append("MR: " + this.getMR().getValue());
            stringBuffer.append("Patch: " + this.getPatch());
        } else if (this.hasFeatureBuild()) {
            stringBuffer.append("Feature build: " + this.getFeatureBuild());
            stringBuffer.append("Patch: " + this.getPatch());
        }
        return stringBuffer.toString();
    }
}

