/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.cl.conf.application;

import com.nokia.em.poseidon.services.cl.conf.Adaptation;
import com.nokia.em.poseidon.services.cl.conf.AdaptationVersionMapping;
import com.nokia.em.poseidon.services.cl.conf.application.AppIcon;
import com.nokia.em.poseidon.services.cl.conf.application.InterfaceVersion;
import com.nokia.em.poseidon.services.cl.conf.application.Manager;
import com.nokia.em.poseidon.services.cl.conf.application.NetworkElement;
import com.nokia.em.poseidon.services.cl.conf.application.ValueProvider;
import com.nokia.em.poseidon.util.xml.ObjectLoadException;
import com.nokia.em.poseidon.util.xml.ObjectLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ManagerInfoParser {
    Manager myManager;

    public ManagerInfoParser(URL url) throws ObjectLoadException {
        ObjectLoader loader = new ObjectLoader(AppIcon.class.getPackage().getName());
        loader.registerTag("AdaptationVersionMapping", AdaptationVersionMapping.class);
        loader.registerTag("Adaptation", Adaptation.class);
        this.myManager = (Manager)loader.loadObject(url);
    }

    public String getManagerBuild() {
        return this.myManager.getManagerInformation().getManagerBuild();
    }

    public String getSoftwareReleaseVersion() {
        return this.myManager.getManagerInformation().getSoftwareReleaseVersion();
    }

    public String getManagedObjectVersionInScf() {
        return this.myManager.getManagerInformation().getManagedObjectVersionInScf();
    }

    public Manager getManagerInfo() {
        return this.myManager;
    }

    public int[] getBestInterface(String elementName, String functionality, int[] requiredVersions) {
        int[] best = new int[5];
        ValueProvider temp = null;
        for (NetworkElement element : this.myManager.getNetworkElements()) {
            if (!element.getNetworkElementName().equals(elementName)) continue;
            for (InterfaceVersion interfaceVersion : element.getInterfaceVersions()) {
                if (!interfaceVersion.getInterfaceType().equals(functionality)) continue;
                temp = this.getBestValueProvider(interfaceVersion.getMajors(), requiredVersions[0]);
                best[0] = temp.getValue();
                temp = this.getBestValueProvider(temp.getSubVersions(), requiredVersions[1]);
                best[1] = temp.getValue();
                temp = this.getBestValueProvider(temp.getSubVersions(), requiredVersions[3]);
                best[3] = temp.getValue();
                if (interfaceVersion.hasFeatureBuild()) {
                    best[2] = interfaceVersion.getFeatureBuild();
                    best[4] = interfaceVersion.getPatch();
                    continue;
                }
                if (interfaceVersion.hasMR()) {
                    best[2] = interfaceVersion.getMR().getValueAsInt();
                    best[4] = interfaceVersion.getPatch();
                    continue;
                }
                best[2] = 0;
                best[4] = 0;
            }
        }
        return best;
    }

    private ValueProvider getBestValueProvider(List<ValueProvider> values, int requiredValue) {
        ValueProvider best = null;
        for (ValueProvider provider : values) {
            if (best == null) {
                best = provider;
                continue;
            }
            if (this.getBestMatch(best.getValue(), provider.getValue(), requiredValue) <= 0) continue;
            best = provider;
        }
        return best;
    }

    private int getBestMatch(int param1, int param2, int requiredValue) {
        int param1Difference = requiredValue - param1;
        int param2Difference = requiredValue - param2;
        if (param1Difference >= 0 && param2Difference >= 0 || param1Difference <= 0 && param2Difference <= 0) {
            return Math.abs(param1Difference) - Math.abs(param2Difference);
        }
        return param2 - param1;
    }

    public List<String> getElementNamesThatHaveInterface(String functionality) {
        ArrayList<String> elements = new ArrayList<String>();
        for (NetworkElement element : this.myManager.getNetworkElements()) {
            for (InterfaceVersion interfaceVersion : element.getInterfaceVersions()) {
                if (!interfaceVersion.getInterfaceType().equals(functionality)) continue;
                elements.add(element.getNetworkElementName());
            }
        }
        return elements;
    }
}

