/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.cl.conf.node;

import com.nokia.em.poseidon.services.cl.conf.AdaptationVersionMapping;
import com.nokia.em.poseidon.services.cl.conf.node.Version;
import com.nokia.em.poseidon.util.xml.XmlUtils;

public class NetworkElement {
    private String myName;
    private boolean myAvailable;
    private boolean myHasAvailable;
    private String myPublicIP;
    private String myLocalIP;
    private Version myVersion;
    private String myAdditionalInformation;
    private String myObjectModelVersion;
    private AdaptationVersionMapping myAdaptationVersionMapping;

    public void deleteAvailable() {
        this.myHasAvailable = false;
    }

    public AdaptationVersionMapping getAdaptationVersionMapping() {
        return this.myAdaptationVersionMapping;
    }

    public void setAdaptationVersionMapping(AdaptationVersionMapping adaptationVersionMapping) {
        this.myAdaptationVersionMapping = adaptationVersionMapping;
    }

    public String getAdditionalInformation() {
        return this.myAdditionalInformation;
    }

    public String getObjectModelVersion() {
        return this.myObjectModelVersion;
    }

    public boolean getAvailable() {
        return this.myAvailable;
    }

    public String getLocalIP() {
        return this.myLocalIP;
    }

    public String getName() {
        return this.myName;
    }

    public String getPublicIP() {
        return this.myPublicIP;
    }

    public Version getVersion() {
        return this.myVersion;
    }

    public boolean hasAvailable() {
        return this.myHasAvailable;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.myAdditionalInformation = additionalInformation;
    }

    public void setObjectModelVersion(String objectModelVersion) {
        this.myObjectModelVersion = objectModelVersion;
    }

    public void setAvailable(boolean available) {
        this.myAvailable = available;
        this.myHasAvailable = true;
    }

    public void setLocalIP(String localIP) {
        this.myLocalIP = localIP;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setPublicIP(String publicIP) {
        this.myPublicIP = publicIP;
    }

    public void setVersion(Version version) {
        this.myVersion = version;
    }

    public boolean hasFeatureBuild() {
        return this.getFeatureBuild() != 0;
    }

    public int getFeatureBuild() {
        int result;
        block4: {
            if (this.myAdditionalInformation == null) {
                return 0;
            }
            String value = XmlUtils.getValue(this.myAdditionalInformation, "featureBuild");
            try {
                result = Integer.parseInt(value);
                if (result >= 100) break block4;
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return result;
    }

    public int getPatch() {
        if (this.myAdditionalInformation == null) {
            return 0;
        }
        String value = XmlUtils.getValue(this.myAdditionalInformation, "patch");
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getMR() {
        if (this.myAdditionalInformation == null) {
            return "";
        }
        return XmlUtils.getValue(this.myAdditionalInformation, "MR");
    }

    public boolean hasMR() {
        return this.getMR() != null && !"".equals(this.getMR());
    }

    public boolean isSharingInUse() {
        if (this.myAdditionalInformation == null) {
            return false;
        }
        String value = XmlUtils.getValue(this.myAdditionalInformation, "sharingInUse");
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getVersionAsString() {
        Version version = this.getVersion();
        StringBuilder builder = new StringBuilder();
        builder.append(version.getMajor());
        builder.append(".");
        builder.append(version.getMinor());
        builder.append(".");
        if (this.hasMR()) {
            builder.append(this.getMR());
        } else {
            builder.append(this.getFeatureBuild());
        }
        builder.append(".");
        builder.append(version.getBuild());
        builder.append(".");
        builder.append(this.getPatch());
        return builder.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Name: ");
        stringBuffer.append(this.getName());
        stringBuffer.append(", Available: ");
        stringBuffer.append(this.getAvailable());
        stringBuffer.append(", LocalIP: ");
        stringBuffer.append(this.getLocalIP());
        stringBuffer.append(", PublicIP: ");
        stringBuffer.append(this.getPublicIP());
        stringBuffer.append(", Version: ");
        stringBuffer.append(this.getVersionAsString());
        stringBuffer.append(", AdditionalInformation: ");
        stringBuffer.append(this.getAdditionalInformation());
        return stringBuffer.toString();
    }
}

