/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.cl.conf.node;

import com.nokia.em.poseidon.services.cl.conf.node.NetworkElement;
import java.util.ArrayList;
import java.util.List;

public class SiteEM {
    private String myNotationVersion;
    private List<NetworkElement> myNetworkElementList = new ArrayList<NetworkElement>();

    public void addNetworkElement(NetworkElement vNetworkElement) {
        this.myNetworkElementList.add(vNetworkElement);
    }

    public void addNetworkElement(int index, NetworkElement vNetworkElement) {
        this.myNetworkElementList.add(index, vNetworkElement);
    }

    public NetworkElement getNetworkElement(int index) throws IndexOutOfBoundsException {
        return this.myNetworkElementList.get(index);
    }

    public NetworkElement[] getNetworkElementsArray() {
        int size = this.myNetworkElementList.size();
        NetworkElement[] mArray = new NetworkElement[size];
        int index = 0;
        while (index < size) {
            mArray[index] = this.myNetworkElementList.get(index);
            ++index;
        }
        return mArray;
    }

    public List getNetworkElements() {
        return this.myNetworkElementList;
    }

    public int getNetworkElementCount() {
        return this.myNetworkElementList.size();
    }

    public String getNotationVersion() {
        return this.myNotationVersion;
    }

    public void removeAllNetworkElement() {
        this.myNetworkElementList.clear();
    }

    public NetworkElement removeNetworkElement(int index) {
        return this.myNetworkElementList.remove(index);
    }

    public void setNetworkElement(int index, NetworkElement vNetworkElement) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.myNetworkElementList.size()) {
            throw new IndexOutOfBoundsException("setNetworkElement: Index value '" + index + "' not in range [0.." + this.myNetworkElementList.size() + "]");
        }
        this.myNetworkElementList.set(index, vNetworkElement);
    }

    public void setNetworkElements(NetworkElement[] networkElementArray) {
        this.myNetworkElementList.clear();
        int i = 0;
        while (i < networkElementArray.length) {
            this.myNetworkElementList.add(networkElementArray[i]);
            ++i;
        }
    }

    public void setNetworkElements(List networkElementList) {
        this.myNetworkElementList = networkElementList;
    }

    public boolean isElementSharingInUse() {
        int i = 0;
        while (i < this.getNetworkElementCount()) {
            NetworkElement element = this.getNetworkElement(i);
            if (element.isSharingInUse()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setNotationVersion(String notationVersion) {
        this.myNotationVersion = notationVersion;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NotationVersion: ");
        stringBuffer.append(this.myNotationVersion);
        stringBuffer.append(", NetworkElements: {");
        int neCount = this.myNetworkElementList.size();
        int neCounter = 0;
        while (neCounter < neCount) {
            stringBuffer.append(this.myNetworkElementList.get(neCounter));
            if (neCounter < neCount - 1) {
                stringBuffer.append(", ");
            }
            ++neCounter;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

