/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.cl.parsers;

import com.nokia.em.poseidon.services.cl.CLCommunicationListener;
import com.nokia.em.poseidon.services.cl.CLCommunicationUtils;
import com.nokia.em.poseidon.services.cl.ConfirmationAction;
import com.nokia.em.poseidon.services.cl.ConfirmationRequestInfo;
import com.nokia.em.poseidon.services.cl.parsers.CLParser;
import com.nokia.em.poseidon.util.security.Base64;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfirmationRequest
extends CLParser {
    private ConfirmationRequestInfo myConfirmationRequestInfo;
    private String myType;

    @Override
    public void parseMessage(Node messageNode) {
        NamedNodeMap attributeMap = messageNode.getAttributes();
        this.myType = attributeMap.getNamedItem("type").getNodeValue();
        NodeList parameters = messageNode.getChildNodes();
        ConfirmationRequestInfo.ICON icon = null;
        String header = null;
        String text = null;
        String details = null;
        String automaticDefault = null;
        ArrayList<String> actions = new ArrayList<String>();
        HashMap<String, String> actionTextAndMnemonics = new HashMap<String, String>();
        int i = 0;
        while (i < parameters.getLength()) {
            Node parameter = parameters.item(i);
            String key = Base64.decodeToString(CLCommunicationUtils.getNodeValue(parameter, "key"));
            String value = Base64.decodeToString(CLCommunicationUtils.getNodeValue(parameter, "value"));
            if (key.equals("Icon")) {
                icon = value.equals("error") ? ConfirmationRequestInfo.ICON.ERROR : (value.equals("warning") ? ConfirmationRequestInfo.ICON.WARNING : ConfirmationRequestInfo.ICON.INFO);
            } else if (key.equals("Text")) {
                text = value;
            } else if (key.equals("Header")) {
                header = value;
            } else if (key.equals("Action")) {
                actions.add(value);
            } else if (key.equals("Details")) {
                details = value;
            } else if (key.equals("AutomaticDefault")) {
                automaticDefault = value;
            } else {
                actionTextAndMnemonics.put(key, value);
            }
            ++i;
        }
        this.myConfirmationRequestInfo = new ConfirmationRequestInfo(icon, header, text);
        if (details != null) {
            this.myConfirmationRequestInfo.setDetails(details);
        }
        for (String action : actions) {
            ConfirmationAction confirmationAction = new ConfirmationAction(action);
            confirmationAction.setMnemonic((String)actionTextAndMnemonics.get(String.valueOf(action) + "_Mnemonic"));
            confirmationAction.setText((String)actionTextAndMnemonics.get(String.valueOf(action) + "_Text"));
            if (automaticDefault != null && automaticDefault.equals(action)) {
                confirmationAction.setAsAutomaticDefault();
            }
            this.myConfirmationRequestInfo.addConfirmationAction(confirmationAction);
        }
    }

    @Override
    public void notifyListeners(CLCommunicationListener listener) {
        listener.receiveConfirmationRequestMessage(this.myType, this.myConfirmationRequestInfo);
    }
}

