/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.cl.parsers;

import com.nokia.em.poseidon.services.cl.CLCommunicationListener;
import com.nokia.em.poseidon.services.cl.CLCommunicationUtils;
import com.nokia.em.poseidon.services.cl.CLErrorInfo;
import com.nokia.em.poseidon.services.cl.UserOption;
import com.nokia.em.poseidon.services.cl.parsers.CLParser;
import java.util.ArrayList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReconnectFailed
extends CLParser {
    private String myFailureReason;
    private CLErrorInfo myErrorInfo;

    @Override
    public void parseMessage(Node messageNode) {
        this.myFailureReason = CLCommunicationUtils.getNodeValue(messageNode, "failureReason");
        Node errorInfonode = messageNode.getOwnerDocument().getElementsByTagName("errorInfo").item(0);
        if (errorInfonode != null) {
            String failureText = CLCommunicationUtils.getNodeValue(errorInfonode, "failureText");
            String failureType = CLCommunicationUtils.getNodeValue(errorInfonode, "failureType");
            NodeList userOptionNodes = messageNode.getOwnerDocument().getElementsByTagName("userOption");
            ArrayList<UserOption> userOptions = new ArrayList<UserOption>();
            int i = 0;
            while (i < userOptionNodes.getLength()) {
                Node optionNode = userOptionNodes.item(i);
                userOptions.add(new UserOption(CLCommunicationUtils.getNodeValue(optionNode, "optionText"), CLCommunicationUtils.getNodeValue(optionNode, "optionMnemonic"), CLCommunicationUtils.getNodeValue(optionNode, "desiredAction")));
                ++i;
            }
            this.myErrorInfo = new CLErrorInfo(failureText, failureType, userOptions);
        }
    }

    @Override
    public void notifyListeners(CLCommunicationListener listener) {
        listener.receiveReconnectFailedMessage(this.myFailureReason, this.myErrorInfo);
    }
}

