/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.cl.parsers;

import com.nokia.em.poseidon.services.cl.CLCommunicationListener;
import com.nokia.em.poseidon.services.cl.CLCommunicationUtils;
import com.nokia.em.poseidon.services.cl.parsers.CLParser;
import com.nokia.em.poseidon.util.xml.XmlUtils;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StartOperation
extends CLParser {
    private String myOpName;
    private NodeList myElements;
    private Map<String, String> myOpParams;

    @Override
    public void parseMessage(Node messageNode) {
        this.myOpName = CLCommunicationUtils.getNodeValue(messageNode, "opName");
        this.myElements = messageNode.getOwnerDocument().getElementsByTagName("networkElement");
        Node opParamsNode = messageNode.getOwnerDocument().getElementsByTagName("operationParameters").item(0);
        if (opParamsNode != null) {
            this.myOpParams = new HashMap<String, String>();
            NodeList paramNodeList = opParamsNode.getChildNodes();
            int paramNodeCount = paramNodeList.getLength();
            int neNodeCounter = 0;
            while (neNodeCounter < paramNodeCount) {
                Node paramNode = paramNodeList.item(neNodeCounter);
                if (paramNode.getNodeName().equals("parameter")) {
                    String key = XmlUtils.getInstance().getNodeValue(paramNode, "key");
                    String value = XmlUtils.getInstance().getNodeValue(paramNode, "value");
                    this.myOpParams.put(key, value);
                }
                ++neNodeCounter;
            }
        }
    }

    @Override
    public void notifyListeners(CLCommunicationListener listener) {
        listener.receiveStartOperationMessage(this.myOpName, this.myElements, this.myOpParams);
    }
}

