/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.conninfo;

import com.nokia.em.poseidon.services.conninfo.ConnectionStatus;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ConnectionEvent {
    protected final ConnectionStatus myConnectionStatus;
    protected final Object mySource;
    protected final String myNetworkElementName;
    protected final String myIpAddress;
    protected final long myTimeStamp;
    protected final Map<String, Object> myOptionalParams;

    public ConnectionEvent(ConnectionStatus connectionStatus, Object eventSource, String networkElementName, String ipAddress, Map<String, Object> optionalParams) {
        this.myConnectionStatus = connectionStatus;
        this.mySource = eventSource;
        this.myNetworkElementName = networkElementName;
        this.myIpAddress = ipAddress;
        this.myTimeStamp = System.currentTimeMillis();
        this.myOptionalParams = optionalParams != null ? new HashMap<String, Object>(optionalParams) : null;
    }

    public ConnectionEvent(ConnectionEvent event) {
        this(event.getConnectionStatus(), event.getSource(), event.getNetworkElementName(), event.getIpAddress(), event.getOptionalParams());
    }

    public ConnectionStatus getConnectionStatus() {
        return this.myConnectionStatus;
    }

    public Object getSource() {
        return this.mySource;
    }

    public String getNetworkElementName() {
        return this.myNetworkElementName;
    }

    public String getIpAddress() {
        return this.myIpAddress;
    }

    public Map<String, Object> getOptionalParams() {
        return this.myOptionalParams;
    }

    public Date getTimeStamp() {
        return new Date(this.myTimeStamp);
    }

    public String toString() {
        return "ConnectionEvent{myConnectionStatus=" + (Object)((Object)this.myConnectionStatus) + ", mySource=" + this.mySource + ", myNetworkElementName='" + this.myNetworkElementName + '\'' + ", myIpAddress='" + this.myIpAddress + '\'' + ", myTimeStamp=" + new Date(this.myTimeStamp) + ", myOptionalParams=" + this.myOptionalParams + '}';
    }
}

