/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.conninfo;

import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.conninfo.ConnectionEvent;
import com.nokia.em.poseidon.services.conninfo.ConnectionEventFilter;
import com.nokia.em.poseidon.services.conninfo.ConnectionEventListener;
import com.nokia.em.poseidon.services.conninfo.ConnectionInfo;
import com.nokia.em.poseidon.services.conninfo.ConnectionStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConnectionInfoImpl
implements Service,
ConnectionInfo {
    private static final int DEFAULT_HISTORY_SIZE = 100;
    private int myHistorySize = 100;
    private List<ConnectionEvent> myConnectionEvents;
    private List<ConnectionEventListener> myListeners;
    private Map<ConnectionEventListener, ConnectionEventFilter> myListenersFilters;
    private Logger myLogger;

    @Override
    public synchronized void addConnectionEvent(ConnectionEvent connectionEvent) {
        this.myLogger.debug("New connection event: " + connectionEvent);
        if (this.myConnectionEvents.size() >= this.myHistorySize) {
            this.myConnectionEvents.remove(this.myConnectionEvents.size() - 1);
        }
        this.myConnectionEvents.add(0, connectionEvent);
        this.fireConnectionEventReceived(connectionEvent);
    }

    @Override
    public synchronized ConnectionEvent getLatestConnectionEvent() {
        if (this.myConnectionEvents.size() > 0) {
            return new ConnectionEvent(this.myConnectionEvents.get(0));
        }
        return null;
    }

    @Override
    public synchronized ConnectionEvent getLatestConnectionEvent(ConnectionEventFilter filter) {
        return this.findLastConnectionEvent(filter);
    }

    @Override
    public synchronized List<ConnectionEvent> getConnectionEventHistory() {
        return new ArrayList<ConnectionEvent>(this.myConnectionEvents);
    }

    @Override
    public synchronized List<ConnectionEvent> getConnectionEventHistory(ConnectionEventFilter filter) {
        ArrayList<ConnectionEvent> returnList = new ArrayList<ConnectionEvent>(0);
        for (ConnectionEvent event : this.myConnectionEvents) {
            if (!filter.isEventAccepted(event)) continue;
            returnList.add(new ConnectionEvent(event));
        }
        return returnList;
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.addConnectionEventListener(listener, null);
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener, ConnectionEventFilter filter) {
        this.myLogger.debug("New connection event listener: " + listener);
        if (this.myListeners.contains(listener)) {
            return;
        }
        this.myListeners.add(listener);
        if (filter != null) {
            this.myListenersFilters.put(listener, filter);
        }
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.myLogger.debug("Connection event listener removed: " + listener);
        this.myListeners.remove(listener);
        this.myListenersFilters.remove(listener);
    }

    private void fireConnectionEventReceived(ConnectionEvent connectionEvent) {
        for (ConnectionEventListener listener : this.myListeners) {
            if (!this.isEventBroadcasted(listener, connectionEvent)) continue;
            if (connectionEvent.getConnectionStatus() == ConnectionStatus.CONNECTED) {
                listener.connectionCreated(new ConnectionEvent(connectionEvent));
                continue;
            }
            listener.connectionClosed(new ConnectionEvent(connectionEvent));
        }
    }

    private boolean isEventBroadcasted(ConnectionEventListener listener, ConnectionEvent event) {
        ConnectionEventFilter filter;
        boolean broadcasted = true;
        if (this.myListenersFilters.containsKey(listener) && !(filter = this.myListenersFilters.get(listener)).isEventAccepted(event)) {
            broadcasted = false;
        }
        return broadcasted;
    }

    private ConnectionEvent findLastConnectionEvent(ConnectionEventFilter filter) {
        ConnectionEvent targetEvent = null;
        for (ConnectionEvent event : this.myConnectionEvents) {
            if (!filter.isEventAccepted(event)) continue;
            targetEvent = new ConnectionEvent(event);
            break;
        }
        return targetEvent;
    }

    @Override
    public void start() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myLogger.debug("Initializing connection info service");
        this.myConnectionEvents = new ArrayList<ConnectionEvent>();
        this.myListeners = new ArrayList<ConnectionEventListener>();
        this.myListenersFilters = new HashMap<ConnectionEventListener, ConnectionEventFilter>();
    }

    @Override
    public void stop() {
        this.myConnectionEvents.clear();
        this.myListeners.clear();
        this.myListenersFilters.clear();
    }

    @Override
    public boolean hasConnectionEvents() {
        return this.myConnectionEvents.size() > 0;
    }
}

