/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.help;

import com.nokia.em.poseidon.services.help.PHelp;
import java.awt.Component;
import java.awt.Window;
import java.net.URL;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class HelpProxy
implements PHelp {
    private PHelp myHelpInstance;

    private PHelp getHelpInstance() {
        if (this.myHelpInstance == null) {
            try {
                Class<?> clazz = Class.forName("com.nokia.em.poseidon.services.help.PHelpImpl");
                this.myHelpInstance = (PHelp)clazz.newInstance();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error("Tried to access the HelpService via help proxy, but failed", e);
            }
        }
        return this.myHelpInstance;
    }

    @Override
    public void showHelp() {
        PHelp help = this.getHelpInstance();
        if (help != null) {
            help.showHelp();
        }
    }

    @Override
    public void showHelp(String helpTopic) {
        PHelp help = this.getHelpInstance();
        if (help != null) {
            help.showHelp(helpTopic);
        }
    }

    @Override
    public void showHelp(Window parentWindow, String helpTopic) {
        PHelp help = this.getHelpInstance();
        if (help != null) {
            help.showHelp(parentWindow, helpTopic);
        }
    }

    @Override
    public void addHelpSet(String applicationName, URL helpSetURL) {
        PHelp help = this.getHelpInstance();
        if (help != null) {
            help.addHelpSet(applicationName, helpSetURL);
        }
    }

    @Override
    public void closeHelpWindow() {
        PHelp help = this.getHelpInstance();
        if (help != null) {
            help.closeHelpWindow();
        }
    }

    @Override
    public void start() {
        PHelp help = this.getHelpInstance();
        if (help != null) {
            help.start();
        }
    }

    @Override
    public void stop() {
        PHelp help = this.getHelpInstance();
        if (help != null) {
            help.stop();
        }
    }

    @Override
    public void addContextSensitiveHelpAction(Component comp, Action helpAction) {
        PHelp help = this.getHelpInstance();
        if (help != null) {
            help.addContextSensitiveHelpAction(comp, helpAction);
        }
    }

    @Override
    public Action getCurrentContextSensitiveHelpAction() {
        PHelp help = this.getHelpInstance();
        if (help != null) {
            return help.getCurrentContextSensitiveHelpAction();
        }
        return null;
    }

    @Override
    public Action removeContextSensitiveHelpAction(Component comp) {
        PHelp help = this.getHelpInstance();
        if (help != null) {
            return help.removeContextSensitiveHelpAction(comp);
        }
        return null;
    }
}

