/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.help;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.plugin.application.AppDescription;
import com.nokia.em.poseidon.plugin.application.ApplicationRegistry;
import com.nokia.em.poseidon.services.help.NetHelpContentViewerUI;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.util.ViewUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.NavigatorView;
import javax.help.TOCView;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class PHelpImpl
implements PHelp {
    protected Logger myLogger;
    protected Map<String, ApplicationHelpData> myAppNameToHelp;
    protected JDialog myDialog;
    private Map<Component, Action> myContextSensitiveHelpActions = new WeakHashMap<Component, Action>();
    private static final Dimension MIN_DIALOG_SIZE = new Dimension(600, 350);
    private static final String WINDOW_PRESENTATION = "WindowPresentation";

    protected void initHelpsetsIfNeeded() {
        for (AppDescription appDesc : PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class).getAppDescriptions()) {
            String helpSetName;
            String applicationName = appDesc.getStringProperty("internalName");
            if (this.myAppNameToHelp.containsKey(applicationName) || (helpSetName = appDesc.getStringProperty("helpSetName")) == null) continue;
            URL helpSetURL = HelpSet.findHelpSet((ClassLoader)this.getClass().getClassLoader(), (String)helpSetName);
            if (helpSetURL != null) {
                this.addHelpSet(applicationName, helpSetURL);
                this.myLogger.debug("Added help set for application: " + applicationName + " with helpset name: " + helpSetName);
                continue;
            }
            this.myLogger.debug("Can not find helpset for application: " + applicationName + " with helpset name: " + helpSetName);
        }
    }

    protected HelpBroker createHelpBroker(HelpSet helpset) {
        HelpBroker helpBroker = null;
        try {
            helpBroker = helpset.createHelpBroker();
        }
        catch (Exception e) {
            this.myLogger.error("Cannot create help broker for helpset " + helpset, e);
        }
        return helpBroker;
    }

    protected Rectangle getDefaultRectangle(Dimension size) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle desktopArea = ge.getMaximumWindowBounds();
        Dimension defaultSize = size;
        if (defaultSize.width > desktopArea.width) {
            defaultSize.width = desktopArea.width;
        }
        if (defaultSize.height > desktopArea.height) {
            defaultSize.height = desktopArea.height;
        }
        int x = (desktopArea.width - defaultSize.width) / 2;
        int y = (desktopArea.height - defaultSize.height) / 2;
        return new Rectangle(new Point(x, y), defaultSize);
    }

    @Override
    public void start() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myAppNameToHelp = new ConcurrentHashMap<String, ApplicationHelpData>();
        UIManager.getDefaults().put("HelpContentViewerUI", NetHelpContentViewerUI.class.getName());
    }

    @Override
    public void stop() {
        this.myAppNameToHelp.clear();
        this.myContextSensitiveHelpActions.clear();
    }

    @Override
    public void showHelp() {
        this.showHelp("");
    }

    @Override
    public void showHelp(String helpTopic) {
        this.showHelp(null, helpTopic);
    }

    @Override
    public void showHelp(Window parentWindow, String helpTopic) {
        String topic = helpTopic;
        this.initHelpsetsIfNeeded();
        if (this.myAppNameToHelp.isEmpty()) {
            this.myLogger.error("Request to show help with id: " + topic + " but no helpsets are available.");
            return;
        }
        ApplicationHelpData rightHelpData = null;
        for (ApplicationHelpData helpdata : this.myAppNameToHelp.values()) {
            HelpSet helpSet = helpdata.getHelpSet();
            if (topic == null || !helpSet.getCombinedMap().isValidID(topic, helpSet)) continue;
            rightHelpData = helpdata;
            break;
        }
        if (rightHelpData == null) {
            rightHelpData = this.myAppNameToHelp.values().iterator().next();
            topic = null;
        }
        if (topic != null && rightHelpData.getHelpBroker().getCurrentID() != null && !topic.equals(rightHelpData.getHelpBroker().getCurrentID().getIDString())) {
            this.removePreviousHelpWindowListener();
        }
        this.closeHelpWindow();
        if (topic == null || "".equals(topic)) {
            rightHelpData.getHelpBroker().setCurrentID(rightHelpData.getHelpSet().getHomeID().id);
        } else {
            rightHelpData.getHelpBroker().setCurrentID(topic);
        }
        if (rightHelpData.getHelpBroker() instanceof DefaultHelpBroker) {
            DefaultHelpBroker broker = (DefaultHelpBroker)rightHelpData.getHelpBroker();
            if (parentWindow == null) {
                broker.setActivationWindow((Window)PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame());
            } else {
                broker.setActivationWindow(parentWindow);
            }
        }
        Rectangle defaultLocation = this.getDefaultRectangle(rightHelpData.getHelpBroker().getSize());
        NavigatorView[] navigatorViewArray = rightHelpData.getHelpBroker().getHelpSet().getNavigatorViews();
        int n = navigatorViewArray.length;
        int helpSet = 0;
        while (helpSet < n) {
            NavigatorView view = navigatorViewArray[helpSet];
            if (view instanceof TOCView) {
                rightHelpData.getHelpBroker().setCurrentView(view.getName());
                rightHelpData.getHelpBroker().setLocation(ViewUtils.restoreSettings("HelpLocation", defaultLocation).getLocation());
            }
            ++helpSet;
        }
        rightHelpData.getHelpBroker().setDisplayed(true);
        if (rightHelpData.getHelpBroker() instanceof DefaultHelpBroker) {
            RootPaneContainer container;
            Container contentPane;
            Window helpWindow = ((DefaultHelpBroker)rightHelpData.getHelpBroker()).getWindowPresentation().getHelpWindow();
            helpWindow.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
            if (helpWindow instanceof JFrame) {
                JFrame helpJFrame = (JFrame)helpWindow;
                helpJFrame.getRootPane().putClientProperty("OrangeTouch.closeWindowOnEscape", true);
            }
            if (helpWindow instanceof RootPaneContainer && (contentPane = (container = (RootPaneContainer)((Object)helpWindow)).getRootPane().getContentPane()) instanceof JComponent) {
                ((JComponent)contentPane).setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 12));
            }
            helpWindow.setSize(ViewUtils.restoreSettings("HelpLocation", defaultLocation).getSize());
            helpWindow.setMinimumSize(MIN_DIALOG_SIZE);
            if (helpWindow instanceof Frame) {
                ((Frame)helpWindow).setIconImage(PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame().getIconImage());
            }
            this.addHelpWindowListener(helpWindow);
        }
    }

    private void addHelpWindowListener(Window helpWindow) {
        boolean listenerAdded = false;
        ComponentListener[] componentListenerArray = helpWindow.getComponentListeners();
        int n = componentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentListener listener = componentListenerArray[n2];
            if (listener instanceof HelpWindowListener) {
                listenerAdded = true;
                break;
            }
            ++n2;
        }
        if (!listenerAdded) {
            helpWindow.addComponentListener(new HelpWindowListener(helpWindow));
        }
    }

    private void removePreviousHelpWindowListener() {
        for (ApplicationHelpData helpdata : this.myAppNameToHelp.values()) {
            if (!(helpdata.getHelpBroker() instanceof DefaultHelpBroker)) continue;
            Window helpWindow = ((DefaultHelpBroker)helpdata.getHelpBroker()).getWindowPresentation().getHelpWindow();
            WindowListener tempListener = null;
            if (helpWindow instanceof JFrame) {
                WindowListener[] windowListeners = helpWindow.getWindowListeners();
                int i = 0;
                while (i < windowListeners.length) {
                    String classSimpleName = windowListeners[i].getClass().getSimpleName();
                    if (classSimpleName.startsWith(WINDOW_PRESENTATION)) {
                        tempListener = windowListeners[i];
                    }
                    ++i;
                }
                if (tempListener == null) continue;
                helpWindow.removeWindowListener(tempListener);
                continue;
            }
            if (!(helpWindow instanceof JDialog) || !(helpWindow.getParent() instanceof JDialog)) continue;
            JDialog parentDialog = (JDialog)helpWindow.getParent();
            WindowListener[] windowListenerArray = parentDialog.getWindowListeners();
            int n = windowListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                WindowListener winListener = windowListenerArray[n2];
                String name = winListener.getClass().getSimpleName();
                if (name.startsWith(WINDOW_PRESENTATION)) {
                    tempListener = winListener;
                }
                ++n2;
            }
            if (tempListener == null) continue;
            parentDialog.removeWindowListener(tempListener);
        }
    }

    @Override
    public void addHelpSet(String applicationName, URL helpSetURL) {
        this.myLogger.debug("Adding helpset. Application name: " + applicationName + ", helpset URL: " + helpSetURL);
        try {
            HelpSet helpset = new HelpSet(this.getClass().getClassLoader(), helpSetURL);
            this.myAppNameToHelp.put(applicationName, new ApplicationHelpData(helpset, this.createHelpBroker(helpset)));
        }
        catch (Exception e) {
            this.myLogger.error("Cannot add helpset to help service", e);
        }
    }

    @Override
    public void closeHelpWindow() {
        for (ApplicationHelpData helpdata : this.myAppNameToHelp.values()) {
            Window helpWindow;
            boolean isHelpWindowVisible = helpdata.getHelpBroker().isDisplayed();
            if (helpdata.getHelpBroker() instanceof DefaultHelpBroker && (helpWindow = ((DefaultHelpBroker)helpdata.getHelpBroker()).getWindowPresentation().getHelpWindow()) != null) {
                isHelpWindowVisible = helpWindow.isVisible();
            }
            if (!isHelpWindowVisible) continue;
            helpdata.getHelpBroker().setDisplayed(false);
        }
    }

    @Override
    public void addContextSensitiveHelpAction(Component comp, Action helpAction) {
        this.myContextSensitiveHelpActions.put(comp, helpAction);
    }

    @Override
    public Action removeContextSensitiveHelpAction(Component comp) {
        return this.myContextSensitiveHelpActions.remove(comp);
    }

    @Override
    public Action getCurrentContextSensitiveHelpAction() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (focusOwner != null) {
            if (this.myContextSensitiveHelpActions.get(focusOwner) != null) {
                return this.myContextSensitiveHelpActions.get(focusOwner);
            }
            Container parent = focusOwner.getParent();
            while (parent != null) {
                Action action = this.myContextSensitiveHelpActions.get(parent);
                if (action != null) {
                    return action;
                }
                parent = parent.getParent();
            }
        }
        Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        for (Component comp : this.myContextSensitiveHelpActions.keySet()) {
            Window parentWindow = SwingUtilities.getWindowAncestor(comp);
            if (parentWindow != focusedWindow || !comp.isShowing()) continue;
            return this.myContextSensitiveHelpActions.get(comp);
        }
        return null;
    }

    private static class ApplicationHelpData {
        private HelpBroker myHelpBroker;
        private HelpSet myHelpSet;

        public ApplicationHelpData(HelpSet helpSet, HelpBroker broker) {
            this.myHelpSet = helpSet;
            this.myHelpBroker = broker;
        }

        public HelpBroker getHelpBroker() {
            return this.myHelpBroker;
        }

        public HelpSet getHelpSet() {
            return this.myHelpSet;
        }
    }

    private class HelpWindowListener
    extends ComponentAdapter {
        private Window helpWindow;

        public HelpWindowListener(Window helpWindow) {
            this.helpWindow = helpWindow;
        }

        @Override
        public void componentShown(ComponentEvent e) {
            ViewUtils.scrollBarsScrollToLeft(this.helpWindow);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            ViewUtils.storeSettings("HelpLocation", new Rectangle(e.getComponent().getLocation(), e.getComponent().getSize()));
        }

        @Override
        public void componentResized(ComponentEvent e) {
            ViewUtils.storeSettings("HelpLocation", new Rectangle(e.getComponent().getLocation(), e.getComponent().getSize()));
        }
    }
}

