/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.help;

import com.nokia.em.poseidon.util.ViewUtils;
import com.nokia.laf.NetLookAndFeel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class StandAloneHelp {
    public static void main(String[] args) {
        StandAloneHelp help = new StandAloneHelp();
        help.initNLAF();
        help.displayHelp(args[0]);
    }

    public void displayHelp(String helpSetName) {
        try {
            URL helpSetURL = HelpSet.findHelpSet((ClassLoader)StandAloneHelp.class.getClassLoader(), (String)helpSetName);
            HelpSet helpset = new HelpSet(StandAloneHelp.class.getClassLoader(), helpSetURL);
            DefaultHelpBroker helpBroker = new DefaultHelpBroker(helpset);
            Font helpFont = UIManager.getFont("Label.font");
            if (helpFont != null) {
                helpBroker.setFont(helpFont);
            }
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension helpWindowSize = helpBroker.getSize();
            helpBroker.setLocation(new Point((screenSize.width - helpWindowSize.width) / 2, (screenSize.height - helpWindowSize.height) / 2));
            helpBroker.setDisplayed(true);
            Window window = helpBroker.getWindowPresentation().getHelpWindow();
            window.setMinimumSize(helpWindowSize);
            ViewUtils.scrollBarsScrollToLeft(window);
            ImageIcon icon = this.getImageIcon();
            if (icon != null) {
                window.setIconImage(icon.getImage());
            }
            helpBroker.getWindowPresentation().getHelpWindow().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        catch (HelpSetException e) {
            System.err.println("Exception opening helpset: " + helpSetName);
            e.printStackTrace();
        }
    }

    public ImageIcon getImageIcon() {
        ImageIcon imageIcon = null;
        try {
            String applicationIcon = System.getProperty("sem.applicationIcon");
            if (applicationIcon != null) {
                try {
                    URL url = new URL(applicationIcon);
                    imageIcon = new ImageIcon(url);
                }
                catch (MalformedURLException muE) {
                    imageIcon = new ImageIcon(applicationIcon);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return imageIcon;
    }

    private void initNLAF() {
        try {
            UIManager.setLookAndFeel(new NetLookAndFeel());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

