/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.licence;

import com.nokia.em.poseidon.services.licence.PLicence;
import com.nokia.em.poseidon.util.file.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PLicenceParser {
    public static final String TARGET = "target";
    public static final String TARGET_NE_TYPE = "targetNeType";
    public static final String TARGET_NE = "targetNe";
    public static final String TARGET_ID = "targetId";
    public static final String FEATURE_DATA = "featureData";
    public static final String FEATURE_INFO = "featureInfo";
    public static final String FEATURE_CODE = "featureCode";
    public static final String FEATURE_NAME = "featureName";
    public static final String ID = "Id";
    public static final String LICENCE_DATA = "LicenceData";
    public static final String LICENCE_INFO = "licenceInfo";
    public static final String LICENCE_CODE = "licenceCode";
    public static final String LICENCE_NAME = "licenceName";
    public static final String ORDER = "order";
    public static final String ORDER_ID = "orderId";
    public static final String SERIAL = "serial";
    public static final String SERIAL_NBR = "serialNbr";
    public static final String CUSTOMER = "customer";
    public static final String CUSTOMER_ID = "customerId";
    public static final String CUSTOMER_NAME = "customerName";
    public static final String THRESHOLD = "threshold";
    public static final String OBJECT_LIMIT = "objectLimit";
    public static final String MAX_VALUE = "maxValue";
    public static final String TIME_LIMIT = "timeLimit";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String SUPLEMENTARY_INFO = "supplementaryInfo";
    public static final String ADDITIONAL_INFO = "additionalInfo";
    private Document myDoc;
    private File myFile;
    private DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static PLicence parse(File file) throws IOException, ParserConfigurationException, SAXException {
        return new PLicenceParser(file).parse();
    }

    public static PLicence parse(URL licenceUrl) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        if (licenceUrl == null) {
            throw new IllegalArgumentException("Licence URL is null.");
        }
        return new PLicenceParser(new File(licenceUrl.toURI())).parse();
    }

    protected PLicenceParser(File file) throws ParserConfigurationException, IOException, SAXException {
        this.myFile = file;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        FileInputStream is = new FileInputStream(this.myFile);
        this.myDoc = builder.parse(is);
        IOUtils.closeQuietly(is);
    }

    protected Map<String, String> parseFeatures() {
        HashMap<String, String> featureMap = new HashMap<String, String>();
        NodeList features = this.myDoc.getElementsByTagName(FEATURE_INFO);
        int idx = 0;
        while (idx < features.getLength()) {
            Element feature = (Element)features.item(idx);
            String featureCode = feature.getAttribute(FEATURE_CODE);
            String featureName = feature.getAttribute(FEATURE_NAME);
            featureMap.put(featureCode, featureName);
            ++idx;
        }
        return featureMap;
    }

    protected String getAttribute(String element, String attrName) {
        Element target = (Element)this.myDoc.getElementsByTagName(element).item(0);
        if (target == null) {
            return null;
        }
        return target.getAttribute(attrName);
    }

    protected List<String> parseTargetIds() {
        ArrayList<String> targetIds = new ArrayList<String>();
        NodeList targetNes = this.myDoc.getElementsByTagName(TARGET_NE);
        int idx = 0;
        while (idx < targetNes.getLength()) {
            Element targetNe = (Element)targetNes.item(idx);
            targetIds.add(targetNe.getAttribute(TARGET_ID));
            ++idx;
        }
        return targetIds;
    }

    protected Map<String, String> parseSupplementaryInfo() {
        HashMap<String, String> targetIds = new HashMap<String, String>();
        NodeList targetNes = this.myDoc.getElementsByTagName(SUPLEMENTARY_INFO);
        if (targetNes.getLength() == 0) {
            return null;
        }
        int idx = 0;
        while (idx < targetNes.getLength()) {
            Element targetNe = (Element)targetNes.item(idx);
            NamedNodeMap nodes = targetNe.getAttributes();
            int i = 0;
            while (i < nodes.getLength()) {
                targetIds.put(nodes.item(i).getNodeName(), nodes.item(i).getNodeValue());
                ++i;
            }
            ++idx;
        }
        return targetIds;
    }

    protected Calendar parseTime(String attrName) {
        String attribute;
        GregorianCalendar cal;
        block3: {
            cal = null;
            attribute = this.getAttribute(TIME_LIMIT, attrName);
            if (attribute != null) break block3;
            return null;
        }
        try {
            Date date = this.DATE_FORMAT.parse(attribute);
            cal = new GregorianCalendar();
            cal.setTime(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return cal;
    }

    protected int parseObjectLimit() {
        try {
            return Integer.parseInt(this.getAttribute(OBJECT_LIMIT, MAX_VALUE));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private PLicence parse() {
        PLicence licence = new PLicence();
        licence.setFileId(this.myFile.getName());
        licence.setLicenceCode(this.getAttribute(LICENCE_INFO, LICENCE_CODE));
        licence.setLicenceName(this.getAttribute(LICENCE_INFO, LICENCE_NAME));
        licence.setOrderId(this.getAttribute(ORDER, ORDER_ID));
        licence.setSerialNumber(this.getAttribute(SERIAL, SERIAL_NBR));
        licence.setCustomerId(this.getAttribute(CUSTOMER, CUSTOMER_ID));
        licence.setCustomerName(this.getAttribute(CUSTOMER, CUSTOMER_NAME));
        licence.setElementType(this.getAttribute(TARGET, TARGET_NE_TYPE));
        licence.setElementCodes(this.parseTargetIds());
        licence.setFeatureData(this.parseFeatures());
        licence.setStartTime(this.parseTime(START_TIME));
        licence.setEndTime(this.parseTime(END_TIME));
        licence.setCapacity(this.parseObjectLimit());
        licence.setLicenceFile(this.myFile);
        licence.setAdditionalInfo(this.getAttribute(SUPLEMENTARY_INFO, ADDITIONAL_INFO));
        licence.setSupplementaryInfo(this.parseSupplementaryInfo());
        return licence;
    }
}

